/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.impl.CaseImpl;
import org.ow2.bonita.facade.runtime.impl.LabelImpl;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.persistence.WebDbSession;
import org.ow2.bonita.services.WebService;
import org.ow2.bonita.util.EnvTool;

public class DbWebService
implements WebService {
    private String persistenceServiceName;

    protected DbWebService() {
    }

    public DbWebService(String persistenceServiceName) {
        this.persistenceServiceName = persistenceServiceName;
    }

    protected WebDbSession getDbSession() {
        return EnvTool.getWebServiceDbSession(this.persistenceServiceName);
    }

    @Override
    public Set<ProcessInstanceUUID> getAllCases() {
        return this.getDbSession().getAllCases();
    }

    @Override
    public void deleteAllCases() {
        this.getDbSession().deleteAllCases();
    }

    @Override
    public void addLabel(LabelImpl label) {
        this.getDbSession().save(label);
    }

    @Override
    public void addCase(CaseImpl case_) {
        this.getDbSession().save(case_);
    }

    @Override
    public void removeCase(CaseImpl case_) {
        this.getDbSession().delete(case_);
    }

    @Override
    public void removeCase(ProcessInstanceUUID caseUUID, String ownerName, String labelName) {
        WebDbSession webSession = this.getDbSession();
        HashSet<ProcessInstanceUUID> caseList = new HashSet<ProcessInstanceUUID>();
        caseList.add(caseUUID);
        Set<CaseImpl> cases = webSession.getCases(ownerName, labelName, caseList);
        if (cases != null) {
            for (CaseImpl caseImpl : cases) {
                webSession.delete(caseImpl);
            }
        }
    }

    @Override
    public List<ProcessInstanceUUID> getLabelsCaseUUIDs(String ownerName, Set<String> labelNames, int fromIndex, int pageSize) {
        return this.getDbSession().getLabelsCaseUUIDs(ownerName, labelNames, fromIndex, pageSize);
    }

    @Override
    public Set<ProcessInstanceUUID> getLabelCases(String labelName, Set<ProcessInstanceUUID> caseUUIDs) {
        return this.getDbSession().getLabelCases(labelName, caseUUIDs);
    }

    @Override
    public Set<CaseImpl> getLabelCases(String ownerName, Set<String> labelNames, Set<ProcessInstanceUUID> caseUUIDs) {
        return this.getDbSession().getLabelCases(ownerName, labelNames, caseUUIDs);
    }

    @Override
    public void removeLabel(String ownerName, String labelName) {
        WebDbSession webSession = this.getDbSession();
        LabelImpl label = webSession.getLabel(ownerName, labelName);
        if (label != null) {
            webSession.delete(label);
            for (CaseImpl case_ : webSession.getCases(ownerName, labelName)) {
                webSession.delete(case_);
            }
        }
    }

    @Override
    public void removeCategories(Set<Category> categories) {
        WebDbSession webSession = this.getDbSession();
        for (Category category : categories) {
            webSession.delete(category);
        }
    }

    @Override
    public LabelImpl getLabel(String ownerName, String labelName) {
        return this.getDbSession().getLabel(ownerName, labelName);
    }

    @Override
    public Set<CaseImpl> getCases(Set<ProcessInstanceUUID> caseUUIDs) {
        return this.getDbSession().getCases(caseUUIDs);
    }

    @Override
    public Set<ProcessInstanceUUID> getCases(String ownerName, Set<String> theLabelsName) {
        return this.getDbSession().getCases(ownerName, theLabelsName);
    }

    @Override
    public Set<LabelImpl> getLabels(String ownerName) {
        return this.getDbSession().getLabels(ownerName);
    }

    @Override
    public List<LabelImpl> getSystemLabels(String ownerName) {
        return this.getDbSession().getSystemLabels(ownerName);
    }

    @Override
    public List<LabelImpl> getUserCustomLabels(String ownerName) {
        return this.getDbSession().getUserCustomLabels(ownerName);
    }

    @Override
    public Set<LabelImpl> getCaseLabels(String ownerName, ProcessInstanceUUID case_) {
        return this.getDbSession().getCaseLabels(ownerName, case_);
    }

    @Override
    public CaseImpl getCase(ProcessInstanceUUID caseUUID, String ownerName, String labelName) {
        return this.getDbSession().getCase(caseUUID, ownerName, labelName);
    }

    @Override
    public void removeCase(ProcessInstanceUUID case_) {
        WebDbSession webSession = this.getDbSession();
        Set<CaseImpl> cases = webSession.getCases(case_);
        if (cases != null) {
            for (CaseImpl caseImpl : cases) {
                webSession.delete(caseImpl);
            }
        }
    }

    @Override
    public void deleteCases(Set<ProcessInstanceUUID> webCases) {
        this.getDbSession().deleteCases(webCases);
    }

    @Override
    public void removeCasesFromLabel(String ownerName, String labelName, Set<ProcessInstanceUUID> caseList) {
        if (caseList == null || caseList.isEmpty()) {
            return;
        }
        WebDbSession webSession = this.getDbSession();
        Set<CaseImpl> cases = webSession.getCases(ownerName, labelName, caseList);
        if (cases != null) {
            for (CaseImpl caseImpl : cases) {
                webSession.delete(caseImpl);
            }
        }
    }

    @Override
    public Set<LabelImpl> getLabels(String ownerName, Set<String> labelsName) {
        return this.getDbSession().getLabels(ownerName, labelsName);
    }

    @Override
    public int getCasesNumber(String ownerName, String labelName) {
        return this.getDbSession().getCasesNumber(ownerName, labelName);
    }

    @Override
    public int getCasesNumber(String ownerName, String label1Name, String label2Name) {
        return this.getDbSession().getCasesNumberWithTwoLabels(ownerName, label1Name, label2Name);
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String labelName, int limit) {
        return this.getDbSession().getCases(ownerName, labelName, limit);
    }

    @Override
    public Set<CaseImpl> getCases(String ownerName, String label1Name, String label2Name, int limit) {
        return this.getDbSession().getCasesWithTwoLabels(ownerName, label1Name, label2Name, limit);
    }

    @Override
    public void updateLabelName(String ownerName, String labelName, String newName) {
        LabelImpl label = EnvTool.getWebService().getLabel(ownerName, labelName);
        label.setName(newName);
        Set<CaseImpl> cases = this.getDbSession().getCases(ownerName, labelName);
        if (cases != null && !cases.isEmpty()) {
            for (CaseImpl case1 : cases) {
                case1.setLabelName(newName);
            }
        }
    }

    @Override
    public Set<LabelImpl> getLabelsByName(Set<String> labelNames) {
        return this.getDbSession().getLabels(labelNames);
    }

    @Override
    public Set<LabelImpl> getLabelsByNameExcept(Set<String> labelNames) {
        return this.getDbSession().getLabelsByNameExcept(labelNames);
    }
}

