/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.services.impl;

import java.util.ArrayList;
import java.util.List;
import org.ow2.bonita.services.Archiver;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.services.impl.QuerierChainer;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;

public class QuerierListAccessor {
    private Querier allQueriers;
    private Querier journals;
    private Querier histories;

    public QuerierListAccessor(List<Querier> queriers) {
        ArrayList<Querier> journalsList = new ArrayList<Querier>();
        ArrayList<Querier> historiesList = new ArrayList<Querier>();
        for (Querier q : queriers) {
            if (q instanceof Recorder) {
                journalsList.add(q);
                continue;
            }
            if (q instanceof Archiver) {
                historiesList.add(q);
                continue;
            }
            String message = ExceptionManager.getInstance().getMessage("bs_QLA_1", q, Recorder.class.getName(), Archiver.class.getName());
            throw new BonitaRuntimeException(message);
        }
        this.allQueriers = new QuerierChainer(queriers);
        this.journals = new QuerierChainer(journalsList);
        this.histories = new QuerierChainer(historiesList);
    }

    public Querier getAllQueriers() {
        return this.allQueriers;
    }

    public Querier getJournals() {
        return this.journals;
    }

    public Querier getHistories() {
        return this.histories;
    }
}

