/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.File;
import org.ow2.bonita.util.BonitaRuntimeException;

public final class BonitaConstants {
    public static final String LOGGING_PROPERTY = "java.util.logging.config.file";
    public static final String JAAS_PROPERTY = "java.security.auth.login.config";
    public static final String ENVIRONMENT_PROPERTY = "org.ow2.bonita.environment";
    public static final String API_TYPE_PROPERTY = "org.ow2.bonita.api-type";
    public static final String INITIAL_CONTEXT_FACTORY_PROPERTY = "java.naming.factory.initial";
    public static final String PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String SYSTEM_USER = "SYSTEM";
    public static final String JEE_SERVER_PROPERTY = "org.ow2.bonita.test.jee.server";
    public static final String DEFAULT_DOMAIN = "default";
    public static final String HOME = "BONITA_HOME";
    public static final String LOGIN_MODE_PROPERTY = "login.mode";
    public static final String LOGIN_MODE_TEST = "test";
    public static final String LOGIN_MODE_EXAMPLE = "example";
    public static final int MAX_QUERY_SIZE = 500;
    public static final int MAX_LIST_SIZE = 2500;
    public static final String TIMER_EVENT_PREFIX = "**bonita_timer**-";
    public static final String DEADLINE_EVENT_PREFIX = "**bonita_deadline**-";
    public static final String ASYNC_EVENT_PREFIX = "**bonita_async**-";
    public static final String FILE_ENCONDING = "UTF-8";
    public static final String XPATH_VAR_SEPARATOR = "$";
    public static final Object XPATH_APPEND_FLAG = "APPEND";
    public static final String JAVA_VAR_SEPARATOR = "#";
    public static final String CONTEXT_PREFIX = "#context[";
    public static final String CONTEXT_SUFFIX = "]";
    public static final String CONTEXTS_FOLDER_IN_BAR = "contexts/";
    public static final String API_ACCESSOR = "apiAccessor";
    public static final String PROCESS_DEFINITION = "processDefinition";
    public static final String LOGGED_USER = "loggedUser";
    public static final String ACTIVITY_INSTANCE = "activityInstance";
    public static final String PROCESS_INSTANCE = "processInstance";
    public static final String TIMER_LAST_EXECUTION = "timerLastExecution";
    public static final String USER_LOCALE = "webUserLocale";
    public static final String PROCESS_INSTANCE_INITIATOR = "processInstanceInitiator";
    public static final String REST_SERVER_ADDRESS_PROPERTY = "org.ow2.bonita.rest-server-address";
    public static final String REST_SERVER_EXCEPTION = "rest.server.exception";

    private BonitaConstants() {
    }

    public static final String getBonitaHomeFolder() {
        String home = System.getProperty(HOME);
        if (home == null) {
            throw new BonitaRuntimeException("The system property 'BONITA_HOME' is not set");
        }
        return home;
    }

    private static final String getClientFolder() {
        StringBuilder clientPath = new StringBuilder(BonitaConstants.getBonitaHomeFolder());
        clientPath.append(File.separator).append("client");
        return clientPath.toString();
    }

    public static final String getTemporaryFolder() {
        StringBuilder tempPath = new StringBuilder(BonitaConstants.getClientFolder());
        tempPath.append(File.separator).append("tmp").append(File.separator).append("engine");
        return tempPath.toString();
    }
}

