/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.ow2.bonita.util.ExceptionManager;

public class DateUtil {
    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT_1 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss/SSS");
        }
    };
    private static ThreadLocal<SimpleDateFormat> DATE_FORMAT_2 = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss");
        }
    };
    private static ThreadLocal<SimpleDateFormat> ISO_8601_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected synchronized SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };

    private DateUtil() {
    }

    public static Date parseDate(String formattedDate) {
        Date result;
        try {
            result = DATE_FORMAT_1.get().parse(formattedDate);
        }
        catch (ParseException e1) {
            try {
                result = DATE_FORMAT_2.get().parse(formattedDate);
            }
            catch (ParseException e2) {
                try {
                    result = ISO_8601_FORMAT.get().parse(formattedDate);
                }
                catch (ParseException e3) {
                    String message = ExceptionManager.getInstance().getFullMessage("bu_DU_1", formattedDate, DATE_FORMAT_2.get().toPattern(), DATE_FORMAT_1.get().toPattern(), ISO_8601_FORMAT.get().toPattern());
                    throw new IllegalArgumentException(message);
                }
            }
        }
        return result;
    }

    public static String format(Date date) {
        return ISO_8601_FORMAT.get().format(date);
    }

    public static Date backTo(Date date, int dayNumber) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, -dayNumber);
        return calendar.getTime();
    }

    public static Date getNextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    public static Date getBeginningOfTheDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(11, 0);
        Date first = calendar.getTime();
        return first;
    }
}

