/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.engine.SessionFactoryImplementor;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.DbTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.IoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DbMigration {
    private static final Logger LOG = LoggerFactory.getLogger(DbMigration.class);

    private DbMigration() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void migrateDb(String domain, String configurationName, String db, String currentVersion, String targetVersion) throws Exception {
        BonitaConstants.getBonitaHomeFolder();
        SessionFactoryImplementor sessionFactory = DbTool.getSessionFactory(domain, configurationName.replaceAll("-configuration", "-session-factory"));
        String database = db.toLowerCase();
        LOG.info("Running " + database + " " + configurationName + " DB migration...");
        InputStream inputStream = null;
        try {
            inputStream = DbMigration.findMigrationScript(database, currentVersion, targetVersion);
            DbMigration.executeScript((SessionFactory)sessionFactory, inputStream, database);
            LOG.info("---------------Schema migrated---------------");
            sessionFactory.close();
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public static void executeScript(SessionFactory sessionFactory, InputStream inputStream, String db) {
        byte[] bytes = IoUtil.readBytes(inputStream);
        String scriptContent = new String(bytes);
        List<String> commands = DbMigration.getCommands(scriptContent, db);
        Session session = sessionFactory.openSession();
        session.getTransaction().begin();
        LOG.info("DB Commands Execution");
        for (String command : commands) {
            LOG.info("Executing command : " + command);
            try {
                session.createSQLQuery(command).executeUpdate();
            }
            catch (Exception e) {
                System.err.println("Error while executing command: " + command);
                LOG.error(e.getMessage(), e.getCause());
            }
        }
        session.getTransaction().commit();
        session.close();
    }

    public static List<String> getCommands(String scriptContent, String db) {
        String[] tmp;
        String delimiter = ";";
        if (db.equals("sqlserver") || db.equals("sybase")) {
            delimiter = "go";
        }
        String regex = delimiter.concat("\r?\n");
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : tmp = scriptContent.split(regex)) {
            commands.add(command.trim());
        }
        int lastIndex = commands.size() - 1;
        String lastCommand = (String)commands.get(lastIndex);
        int index = lastCommand.lastIndexOf(delimiter);
        if (index > 0) {
            lastCommand = lastCommand.substring(0, index);
            commands.remove(lastIndex);
            commands.add(lastCommand);
        }
        return commands;
    }

    public static InputStream findMigrationScript(String db, String currentVersion, String targetVersion) {
        StringBuilder migrationScript = new StringBuilder();
        migrationScript.append("/migration/").append(db).append("-").append(currentVersion).append("-").append(targetVersion).append(".sql");
        LOG.info("Loading Script " + migrationScript.toString());
        InputStream inputStream = DbMigration.class.getResourceAsStream(migrationScript.toString());
        if (inputStream == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_2", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        return inputStream;
    }

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 3) {
            String message = ExceptionManager.getInstance().getFullMessage("bh_DBM_1", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        String domain = args[0];
        String db = args[1].toLowerCase();
        String currentVersion = args[2];
        String targetVersion = "5.6.1";
        String disableSearch = "bonita.search.use";
        System.setProperty("bonita.search.use", "false");
        LOG.info("Starting History DB migration");
        DbMigration.migrateDb(domain, "hibernate-configuration:history", db, currentVersion, "5.6.1");
        LOG.info("Starting Core DB migration");
        DbMigration.migrateDb(domain, "hibernate-configuration:core", db, currentVersion, "5.6.1");
        System.clearProperty("bonita.search.use");
    }
}

