/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.runtime.AttachmentInstance;
import org.ow2.bonita.facade.runtime.impl.AttachmentInstanceImpl;
import org.ow2.bonita.facade.runtime.impl.DocumentImpl;
import org.ow2.bonita.facade.uuid.DocumentUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.util.BonitaRuntimeException;

public class DocumentService {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";

    public static DocumentImpl getClientDocument(DocumentationManager manager, Document document) {
        DocumentUUID uuid = new DocumentUUID(document.getId());
        String name = document.getName();
        String author = document.getAuthor();
        Date creationDate = document.getCreationDate();
        String lastModifiedBy = document.getLastModifiedBy();
        Date lastModificationDate = document.getLastModificationDate();
        boolean isLatestVersion = document.isLatestVersion();
        boolean isMajorVersion = document.isMajorVersion();
        String versionLabel = document.getVersionLabel();
        String versionSeriesId = document.getVersionSeriesId();
        String fileName = document.getContentFileName();
        String mimeType = document.getContentMimeType();
        long size = document.getContentSize();
        ProcessDefinitionUUID definitionUUID = document.getProcessDefinitionUUID();
        ProcessInstanceUUID instanceUUID = document.getProcessInstanceUUID();
        DocumentImpl doc = new DocumentImpl(uuid, name, definitionUUID, instanceUUID, author, creationDate, lastModifiedBy, lastModificationDate, isLatestVersion, isMajorVersion, versionLabel, versionSeriesId, fileName, mimeType, size);
        return doc;
    }

    public static List<org.ow2.bonita.facade.runtime.Document> getClientDocuments(DocumentationManager manager, List<Document> documents) {
        ArrayList<org.ow2.bonita.facade.runtime.Document> result = new ArrayList<org.ow2.bonita.facade.runtime.Document>();
        for (Document document : documents) {
            result.add(DocumentService.getClientDocument(manager, document));
        }
        return result;
    }

    public static AttachmentInstance getAttachmentFromDocument(DocumentationManager manager, Document document) {
        String name = document.getName();
        String author = document.getAuthor();
        Date creationDate = document.getCreationDate();
        String fileName = document.getContentFileName();
        String mimeType = document.getContentMimeType();
        DocumentUUID documentUUID = new DocumentUUID(document.getId());
        ProcessInstanceUUID instanceUUID = document.getProcessInstanceUUID();
        AttachmentInstanceImpl attachment = new AttachmentInstanceImpl(documentUUID, name, instanceUUID, author, creationDate);
        attachment.setFileName(fileName);
        if (mimeType != null) {
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("content-type", mimeType);
            attachment.setMetaData(metadata);
        }
        return attachment;
    }

    public static SearchResult getDocuments(DocumentationManager manager, ProcessDefinitionUUID definitionUUID, String documentName) {
        DocumentSearchBuilder builder = new DocumentSearchBuilder();
        builder.criterion(DocumentIndex.PROCESS_DEFINITION_UUID).equalsTo(definitionUUID.getValue()).and().criterion(DocumentIndex.NAME).equalsTo(documentName);
        return manager.search(builder, 0, Integer.MAX_VALUE);
    }

    public static SearchResult getDocuments(DocumentationManager manager, ProcessInstanceUUID instanceUUID, String documentName) {
        DocumentSearchBuilder builder = new DocumentSearchBuilder();
        builder.criterion(DocumentIndex.PROCESS_INSTANCE_UUID).equalsTo(instanceUUID.getValue()).and().criterion(DocumentIndex.NAME).equalsTo(documentName);
        return manager.search(builder, 0, Integer.MAX_VALUE);
    }

    public static SearchResult getDocuments(DocumentationManager manager, ProcessInstanceUUID instanceUUID) {
        DocumentSearchBuilder builder = new DocumentSearchBuilder();
        builder.criterion(DocumentIndex.PROCESS_INSTANCE_UUID).equalsTo(instanceUUID.getValue());
        return manager.search(builder, 0, Integer.MAX_VALUE);
    }

    public static List<Document> getAllDocumentVersions(DocumentationManager manager, ProcessInstanceUUID instanceUUID) {
        DocumentSearchBuilder builder = new DocumentSearchBuilder();
        builder.criterion(DocumentIndex.PROCESS_INSTANCE_UUID).equalsTo(instanceUUID.getValue());
        SearchResult search = manager.search(builder, 0, Integer.MAX_VALUE);
        ArrayList<Document> result = new ArrayList<Document>();
        List<Document> documents = search.getDocuments();
        for (Document document : documents) {
            try {
                List<Document> versionsOfDocument = manager.getVersionsOfDocument(document.getId());
                result.addAll(versionsOfDocument);
            }
            catch (DocumentNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return result;
    }

    private static List<Document> getAllDocumentVersions(DocumentationManager manager, ProcessInstanceUUID instanceUUID, String attachmentName) {
        SearchResult search = DocumentService.getDocuments(manager, instanceUUID, attachmentName);
        ArrayList<Document> result = new ArrayList<Document>();
        List<Document> documents = search.getDocuments();
        for (Document document : documents) {
            try {
                List<Document> versionsOfDocument = manager.getVersionsOfDocument(document.getId());
                result.addAll(versionsOfDocument);
            }
            catch (DocumentNotFoundException e) {
                throw new BonitaRuntimeException(e);
            }
        }
        return result;
    }

    public static List<AttachmentInstance> getAllAttachmentVersions(DocumentationManager manager, ProcessInstanceUUID instanceUUID) {
        ArrayList<AttachmentInstance> attachments = new ArrayList<AttachmentInstance>();
        List<Document> allDocumentVersions = DocumentService.getAllDocumentVersions(manager, instanceUUID);
        for (Document document : allDocumentVersions) {
            attachments.add(DocumentService.getAttachmentFromDocument(manager, document));
        }
        return attachments;
    }

    public static List<AttachmentInstance> getAllAttachmentVersions(DocumentationManager manager, ProcessInstanceUUID instanceUUID, String attachmentName) {
        ArrayList<AttachmentInstance> attachments = new ArrayList<AttachmentInstance>();
        List<Document> allDocumentVersions = DocumentService.getAllDocumentVersions(manager, instanceUUID, attachmentName);
        for (Document document : allDocumentVersions) {
            attachments.add(DocumentService.getAttachmentFromDocument(manager, document));
        }
        return attachments;
    }

    public static List<AttachmentInstance> getLastAttachments(DocumentationManager manager, ProcessInstanceUUID instanceUUID) {
        ArrayList<AttachmentInstance> attachments = new ArrayList<AttachmentInstance>();
        SearchResult result = DocumentService.getDocuments(manager, instanceUUID);
        List<Document> lastDocuments = result.getDocuments();
        for (Document document : lastDocuments) {
            attachments.add(DocumentService.getAttachmentFromDocument(manager, document));
        }
        return attachments;
    }
}

