/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class GroovyScriptBuilder {
    private static ThreadLocal<SoftReference<Map<GroovyScriptCacheKey, Script>>> scriptCacheThreadLocal = new ThreadLocal();

    public static Script getScript(String expression, ClassLoader scriptClassLoader) {
        GroovyScriptCacheKey key = new GroovyScriptCacheKey(scriptClassLoader, expression);
        SoftReference<Map<GroovyScriptCacheKey, Script>> softReference = scriptCacheThreadLocal.get();
        Map<GroovyScriptCacheKey, Script> scriptCache = null;
        if (softReference != null) {
            scriptCache = softReference.get();
        }
        Script script = null;
        if (scriptCache == null) {
            scriptCache = new HashMap<GroovyScriptCacheKey, Script>();
            scriptCacheThreadLocal.set(new SoftReference<Map<GroovyScriptCacheKey, Script>>(scriptCache));
        } else {
            script = scriptCache.get(key);
        }
        if (script == null) {
            script = GroovyScriptBuilder.doBuildScript(expression, scriptClassLoader);
            scriptCache.put(key, script);
        }
        return script;
    }

    private static Script doBuildScript(String expression, ClassLoader scriptClassLoader) {
        GroovyShell shell = new GroovyShell(scriptClassLoader);
        URL defaultGroovyMethods = scriptClassLoader.getResource("org/codehaus/groovy/runtime/DefaultGroovyMethods.class");
        String parsedExpression = expression;
        if (defaultGroovyMethods != null && !expression.contains("org.codehaus.groovy.runtime.DefaultGroovyMethods.*")) {
            parsedExpression = "import static org.codehaus.groovy.runtime.DefaultGroovyMethods.*;\n".concat(expression);
        }
        Script script = shell.parse(parsedExpression);
        return script;
    }

    private static class GroovyScriptCacheKey {
        private final String expression;
        private final ClassLoader classLoader;

        private GroovyScriptCacheKey(ClassLoader classLoader, String expression) {
            assert (classLoader != null);
            assert (expression != null);
            this.classLoader = classLoader;
            this.expression = expression;
        }

        public boolean equals(Object o) {
            if (null == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroovyScriptCacheKey that = (GroovyScriptCacheKey)o;
            if (!this.classLoader.equals(that.classLoader)) {
                return false;
            }
            return this.expression.equals(that.expression);
        }

        public int hashCode() {
            int result = this.expression.hashCode();
            result = 31 * result + this.classLoader.hashCode();
            return result;
        }
    }
}

