/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.Comparator;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.paging.ProcessDefinitionCriterion;

public class InternalProcessDefinitionComparator
implements Comparator<InternalProcessDefinition> {
    private ProcessDefinitionCriterion pagingCriterion;

    public InternalProcessDefinitionComparator(ProcessDefinitionCriterion pagingCriterion) {
        this.pagingCriterion = pagingCriterion;
    }

    @Override
    public int compare(InternalProcessDefinition o1, InternalProcessDefinition o2) {
        switch (this.pagingCriterion) {
            case NAME_ASC: {
                return o1.getName().compareTo(o2.getName());
            }
            case LABEL_ASC: {
                if (o1.getLabel() == null) {
                    if (o2.getLabel() == null) {
                        return 0;
                    }
                    return -1;
                }
                return o1.getLabel().compareTo(o2.getLabel());
            }
            case VERSION_ASC: {
                return o1.getVersion().compareTo(o2.getVersion());
            }
            case STATE_ASC: {
                return o1.getState().toString().compareTo(o2.getState().toString());
            }
            case NAME_DESC: {
                return o2.getName().compareTo(o1.getName());
            }
            case LABEL_DESC: {
                if (o2.getLabel() == null) {
                    if (o1.getLabel() == null) {
                        return 0;
                    }
                    return -1;
                }
                return o2.getLabel().compareTo(o1.getLabel());
            }
            case VERSION_DESC: {
                return o2.getVersion().compareTo(o1.getVersion());
            }
            case STATE_DESC: {
                return o2.getState().toString().compareTo(o1.getState().toString());
            }
            case DEFAULT: {
                o1.getLabelOrName().compareTo(o2.getLabelOrName());
            }
        }
        return 0;
    }
}

