/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.TypeVariable;
import java.net.InetAddress;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.Permissions;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.util.Base64;
import org.ow2.bonita.util.BonitaConstants;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.Chainer;
import org.ow2.bonita.util.ClassDataTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.LoggingInvocationHandler;
import org.ow2.bonita.util.MBeanInvocationHandler;
import org.ow2.bonita.util.ProcessBuilder;
import org.ow2.bonita.util.xml.Problem;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Misc {
    private static final Logger LOG = Logger.getLogger(Misc.class.getName());
    private static Object formatterLock = new Object();
    public static final String ATTACHMENT_INDEX_NAME_SEPARATOR = "_____";
    public static final int BASE64_BYTES_FRAGMENT_LENGTH = 65536;
    public static final String BASE64_BYTES_FRAGMENT_SEPARATOR = "::";
    public static final Random RANDOM = new Random();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final DateFormat DELAY_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final long DAY = 86400000L;
    private static final AtomicLong SEQUENCE_NUMBER;

    private Misc() {
    }

    public static boolean isOnWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static <T> List<T> subList(Class<T> clazz, List<T> list, int fromIndex, int toIndex) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        int validToIndex = toIndex;
        if (toIndex > list.size()) {
            validToIndex = list.size();
        }
        if (fromIndex >= validToIndex) {
            return Collections.emptyList();
        }
        return new ArrayList<T>(list.subList(fromIndex, validToIndex));
    }

    public static boolean isSetter(String methodName) {
        return methodName.startsWith("set") && methodName.length() >= 4 && Character.isUpperCase(methodName.charAt(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document generateDocument(String s) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        ByteArrayInputStream contentStream = new ByteArrayInputStream(s.getBytes());
        Document doc = null;
        try {
            doc = builder.parse(contentStream, null);
        }
        finally {
            if (contentStream != null) {
                ((InputStream)contentStream).close();
            }
        }
        return doc;
    }

    public static Date getDate(long time) {
        if (time == 0L) {
            return null;
        }
        return new Date(time);
    }

    public static long getTime(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    public static List<Collection<Object>> splitCollection(Collection<? extends Object> initial, int size) {
        if (initial == null || initial.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Collection<Object>> result = new ArrayList<Collection<Object>>();
        Iterator<? extends Object> it = initial.iterator();
        int i = 0;
        HashSet<Object> set = null;
        while (it.hasNext()) {
            if (i == size) {
                i = 0;
            }
            if (i == 0) {
                set = new HashSet<Object>();
                result.add(set);
            }
            set.add(it.next());
            ++i;
        }
        return result;
    }

    public static String getXPath(String s) {
        if (s.contains("$")) {
            String[] segments = s.split("\\$");
            return segments[1];
        }
        return null;
    }

    public static String getVariableName(String s) {
        if (s.contains("$")) {
            String[] segments = s.split("\\$");
            return segments[0];
        }
        if (s.contains("#")) {
            String[] segments = s.split("#");
            return segments[0];
        }
        return s;
    }

    public static boolean isXMLAppend(String s) {
        String[] segments = s.split("\\$");
        return segments.length >= 3 && segments[2].equals(BonitaConstants.XPATH_APPEND_FLAG);
    }

    public static int getGroovyExpressionEndIndex(String expression) {
        int open = 0;
        char[] characters = expression.toCharArray();
        for (int i = 1; i < characters.length; ++i) {
            if (characters[i] == '{') {
                ++open;
            } else if (characters[i] == '}') {
                --open;
            }
            if (open != 0) continue;
            return i + 1;
        }
        return -1;
    }

    public static boolean isJustAGroovyExpression(String expression) {
        return expression.startsWith("${") && Misc.getGroovyExpressionEndIndex(expression) == expression.length();
    }

    public static boolean containsAGroovyExpression(String expression) {
        int begin = expression.indexOf("${");
        int end = -1;
        if (begin >= 0) {
            end = begin + Misc.getGroovyExpressionEndIndex(expression.substring(begin));
        }
        return begin < end;
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public static Map<String, byte[]> getJarEntries(JarInputStream jis, String jarFile) {
        HashMap<String, byte[]> jarEntries = new HashMap<String, byte[]>();
        JarEntry jarEntry = null;
        try {
            while ((jarEntry = jis.getNextJarEntry()) != null) {
                String jarEntryName = jarEntry.getName();
                if (jarEntryName.startsWith("/")) {
                    jarEntryName = jarEntryName.substring(1);
                }
                byte[] content = Misc.getJarEntriesContent(jis);
                jarEntries.put(jarEntryName, content);
            }
        }
        catch (IOException e) {
            throw new BonitaRuntimeException("Unable to load class: " + jarEntry.getName() + " from jar file: " + jarFile, e);
        }
        return jarEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getJarEntriesContent(JarInputStream jis) throws IOException {
        byte[] buffer = new byte[512];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int c;
            while ((c = jis.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.flush();
        }
        finally {
            baos.close();
        }
        return baos.toByteArray();
    }

    public static Map<String, byte[]> getJarEntries(String jarFile, byte[] jar) {
        Map<String, byte[]> map;
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(new ByteArrayInputStream(jar));
            map = Misc.getJarEntries(jis, jarFile);
        }
        catch (IOException e) {
            try {
                throw new BonitaRuntimeException("Unable to load jar entries from jar file: " + jarFile, e);
            }
            catch (Throwable throwable) {
                Misc.close(jis);
                throw throwable;
            }
        }
        Misc.close(jis);
        return map;
    }

    public static String getUniqueId(String prefix) {
        return prefix + UUID.randomUUID();
    }

    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String convertToJavaIdentifier(String name) {
        StringBuilder tmp = new StringBuilder();
        if (name != null) {
            for (int i = 0; i < name.length(); ++i) {
                char car = name.charAt(i);
                if (i == 0 && Character.isJavaIdentifierStart(car)) {
                    tmp.append(car);
                    continue;
                }
                if (i != 0 && Character.isJavaIdentifierPart(car)) {
                    tmp.append(car);
                    continue;
                }
                tmp.append("_");
            }
            return tmp.toString();
        }
        return "";
    }

    public static String getHumanReadableId(String prefix) {
        return prefix + Misc.getHumanReadableId();
    }

    public static List<String> getBusinessArchiveCategories(ProcessDefinitionUUID processUUID) {
        ArrayList<String> categories = new ArrayList<String>();
        categories.add("BusinessArchives");
        categories.add(Misc.convertToJavaIdentifier(processUUID.getValue()));
        return categories;
    }

    public static List<String> getGlobalClassDataCategories() {
        ArrayList<String> categories = new ArrayList<String>();
        categories.add("GlobalClasses");
        return categories;
    }

    public static List<String> getAttachmentCategories(ProcessDefinitionUUID processUUID) {
        ArrayList<String> categories = new ArrayList<String>();
        categories.add("Attachments");
        categories.add(Misc.convertToJavaIdentifier(processUUID.getValue()));
        return categories;
    }

    public static List<String> getAttachmentCategories(ProcessInstanceUUID instanceUUID) {
        ArrayList<String> categories = new ArrayList<String>();
        categories.add("Attachments");
        categories.add(Misc.convertToJavaIdentifier(instanceUUID.getValue()));
        return categories;
    }

    public static List<String> stringToList(String s, String separator) {
        if (s == null) {
            return Collections.emptyList();
        }
        String[] array = s.split(separator);
        ArrayList<String> result = new ArrayList<String>();
        for (String st : array) {
            result.add(st);
        }
        return result;
    }

    public static String listToString(List<String> list, String separator) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (String s : list) {
            buf.append(separator + s);
        }
        return buf.toString().substring(separator.length());
    }

    public static Map<String, String> stringToMap(String s) {
        if (s == null) {
            return Collections.emptyMap();
        }
        String[] couples = s.split(";");
        HashMap<String, String> result = new HashMap<String, String>();
        for (String couple : couples) {
            String[] st = couple.split(",");
            result.put(st[0], st[1]);
        }
        return result;
    }

    public static String mapToString(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buf.append(";" + entry.getKey() + "," + entry.getValue());
        }
        return buf.toString().substring(";".length());
    }

    public static long getHumanReadableId() {
        return SEQUENCE_NUMBER.getAndIncrement();
    }

    public static int random(int min, int max) {
        if (min >= max) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_1", min, max);
            throw new IllegalArgumentException(message);
        }
        int n = max - min;
        if (n < 0) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_2", min, max);
            throw new IllegalArgumentException(message);
        }
        return RANDOM.nextInt(max - min) + min;
    }

    public static String getRandomString(int size) {
        char[] s = new char[size];
        int c = 65;
        int r1 = 0;
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            r1 = r.nextInt(3);
            switch (r1) {
                case 0: {
                    c = 48 + (int)(Math.random() * 10.0);
                    break;
                }
                case 1: {
                    c = 97 + (int)(Math.random() * 26.0);
                    break;
                }
                case 2: {
                    c = 65 + (int)(Math.random() * 26.0);
                }
            }
            s[i] = (char)c;
        }
        return new String(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String formatDelay(long delay) {
        if (delay == Long.MAX_VALUE) {
            return "INFINITY";
        }
        if (delay == Long.MIN_VALUE) {
            return "-INFINITY";
        }
        if (Math.abs(delay) >= 86400000L) {
            long days = delay / 86400000L;
            return days + " day" + (days > 1L ? "s" : "");
        }
        Object object = formatterLock;
        synchronized (object) {
            return delay < 0L ? "-" + DELAY_FORMATTER.format(new Date(-delay)) : DELAY_FORMATTER.format(new Date(delay));
        }
    }

    public static final String formatDelay(double delay) {
        return Misc.formatDelay((long)delay);
    }

    public static Set<Class<?>> findAllTypes(Class<?> type) {
        Set<Class<?>> superTypes = Misc.findAllSuperTypes(type);
        HashSet result = new HashSet(superTypes);
        for (Class<?> i : superTypes) {
            result.addAll(Misc.findAllInterfaces(i));
        }
        result.addAll(Misc.findAllInterfaces(type));
        return result;
    }

    public static String getGenericFullName(Class<?> clazz) {
        StringBuilder sb = new StringBuilder(clazz.getCanonicalName());
        TypeVariable<Class<?>>[] types = clazz.getTypeParameters();
        if (types.length != 0) {
            sb.append('<');
            for (TypeVariable<Class<?>> type : types) {
                sb.append(type.getName());
                sb.append(',');
            }
            sb.replace(sb.length() - 1, sb.length(), ">");
        }
        return new String(sb);
    }

    public static Set<Class<?>> findAllSuperTypes(Class<?> type) {
        HashSet classes = new HashSet();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            classes.add(c);
        }
        return classes;
    }

    public static Set<Class<?>> findAllInterfaces(Class<?> type) {
        Class<?>[] interfaces;
        HashSet classes = new HashSet();
        for (Class<?> i : interfaces = type.getInterfaces()) {
            classes.add(i);
            classes.addAll(Misc.findAllInterfaces(i));
        }
        Class<?> superClass = type.getSuperclass();
        if (superClass != null) {
            classes.addAll(Misc.findAllInterfaces(superClass));
        }
        return classes;
    }

    public static Class<?>[] findMethodClassArgs(Class<?>[] subClasses, Class<?> classToTest, String methodName) throws NoSuchMethodException {
        Set[] classesList = new Set[subClasses.length];
        for (int i = 0; i < classesList.length; ++i) {
            classesList[i] = Misc.findAllTypes(subClasses[i]);
        }
        Method[] methods = classToTest.getDeclaredMethods();
        for (int i = methods.length - 1; i >= 0; --i) {
            Class<?>[] formal;
            if (!methods[i].getName().equals(methodName) || (formal = methods[i].getParameterTypes()).length != subClasses.length || !Misc.checkFormal(formal, classesList)) continue;
            return formal;
        }
        String message = ExceptionManager.getInstance().getFullMessage("buc_M_3", Misc.componentsToString(subClasses, false), classToTest, methodName);
        throw new NoSuchMethodException(message);
    }

    public static Class<?>[] findConstructorClassArgs(Class<?>[] subClasses, Class<?> classToTest) throws NoSuchMethodException {
        Set[] classesList = new Set[subClasses.length];
        for (int i = 0; i < classesList.length; ++i) {
            classesList[i] = Misc.findAllTypes(subClasses[i]);
        }
        Constructor<?>[] constructors = classToTest.getDeclaredConstructors();
        for (int i = constructors.length - 1; i >= 0; --i) {
            Class<?>[] formal = constructors[i].getParameterTypes();
            if (formal.length != subClasses.length || !Misc.checkFormal(formal, classesList)) continue;
            return formal;
        }
        String message = ExceptionManager.getInstance().getFullMessage("buc_M_4", Misc.componentsToString(subClasses, false), classToTest);
        throw new NoSuchMethodException(message);
    }

    private static boolean checkFormal(Class<?>[] formal, Set<Class<?>>[] types) {
        for (int i = 0; i < formal.length; ++i) {
            Iterator<Class<?>> iterator = types[i].iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Class<?> type = iterator.next();
                if (!type.equals(formal[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static String identityToString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "#" + System.identityHashCode(o);
    }

    public static String componentsToString(Object[] args, boolean deepToString) {
        if (args == null) {
            return "null";
        }
        Class<?> componentType = args.getClass().getComponentType();
        StringBuilder string = new StringBuilder(componentType.getName());
        string.append("[");
        int length = args.length;
        if (length != 0) {
            int max = length - 1;
            for (int i = 0; i < max; ++i) {
                if (args[i] == null) {
                    string.append("null");
                } else if (args[i].getClass().isArray()) {
                    componentType = args[i].getClass().getComponentType();
                    if (componentType.isPrimitive()) {
                        string.append(Misc.primitiveComponentsToString(args[i]));
                    } else {
                        string.append(Misc.componentsToString((Object[])args[i], deepToString));
                    }
                } else {
                    string.append(deepToString ? Misc.deepToString(args[i]) : args[i].toString());
                }
                string.append("; ");
            }
            if (args[max] == null) {
                string.append("null");
            } else if (args[max].getClass().isArray()) {
                componentType = args[max].getClass().getComponentType();
                if (componentType.isPrimitive()) {
                    string.append(Misc.primitiveComponentsToString(args[max]));
                } else {
                    string.append(Misc.componentsToString((Object[])args[max], deepToString));
                }
            } else {
                string.append(deepToString ? Misc.deepToString(args[max]) : args[max].toString());
            }
        }
        string.append("]");
        return new String(string);
    }

    public static String primitiveComponentsToString(Object array) {
        if (array == null) {
            return "null";
        }
        Class<?> c = array.getClass();
        if (!c.isArray() || !c.getComponentType().isPrimitive()) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_5", new Object[0]);
            throw new IllegalArgumentException(message);
        }
        StringBuilder string = new StringBuilder(c.getComponentType().getName());
        string.append("[");
        int length = Array.getLength(array);
        if (length != 0) {
            int max = length - 1;
            for (int i = 0; i < max; ++i) {
                string.append(Array.get(array, i));
                string.append("; ");
            }
            string.append(Array.get(array, max));
        }
        string.append("]");
        return new String(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(File file) throws IOException {
        byte[] byArray;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byArray = Misc.getAllContentFrom(in);
        }
        catch (Throwable throwable) {
            Misc.close(in);
            throw throwable;
        }
        Misc.close(in);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputSource source) throws IOException {
        InputStream in = null;
        try {
            in = source.getByteStream();
            byte[] byArray = Misc.getAllContentFrom(in);
            return byArray;
        }
        finally {
            Misc.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            byte[] byArray = Misc.getAllContentFrom(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getAllContentFrom(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("The InputStream is null!");
        }
        BufferedInputStream bis = new BufferedInputStream(in);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] resultArray = null;
        try {
            int c;
            while ((c = bis.read()) != -1) {
                result.write(c);
            }
            resultArray = result.toByteArray();
            result.flush();
        }
        finally {
            result.close();
            bis.close();
        }
        return resultArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getFile(File file, byte[] fileAsByteArray) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(fileAsByteArray);
            fos.flush();
        }
        finally {
            fos.close();
        }
    }

    public static Exception close(Closeable closeable) {
        return Misc.reflectClose(closeable);
    }

    public static Exception close(XMLEncoder encoder) {
        return Misc.reflectClose(encoder);
    }

    public static Exception close(XMLDecoder decoder) {
        return Misc.reflectClose(decoder);
    }

    public static Exception reflectClose(Object o) {
        if (o == null) {
            return null;
        }
        try {
            Method m = o.getClass().getMethod("close", new Class[0]);
            m.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Exception thrown during close() on: ");
            sb.append(o.toString());
            sb.append(LINE_SEPARATOR);
            sb.append("Exception message is: ");
            sb.append(e.getMessage());
            sb.append(LINE_SEPARATOR);
            sb.append(Misc.getStackTraceFrom(e));
            LOG.warning(sb.toString());
            return e;
        }
        return null;
    }

    public static int getPermissionsSize(Permissions permissions) {
        int size = 0;
        Enumeration<Permission> p = permissions.elements();
        while (p.hasMoreElements()) {
            ++size;
        }
        return size;
    }

    public static <T> T getMBeanProxy(Class<T> mbeanInterface, String jmxServiceUrl, String jmxObjectName) throws IOException, MalformedObjectNameException, InstanceNotFoundException, MBeanException, ReflectionException {
        return (T)Proxy.newProxyInstance(Misc.class.getClassLoader(), new Class[]{mbeanInterface}, (InvocationHandler)new MBeanInvocationHandler(jmxServiceUrl, jmxObjectName));
    }

    public static <T> T getChainOf(List<T> elements) {
        Misc.checkArgsNotNull(elements);
        Chainer<T> chain = new Chainer<T>();
        HashSet classes = new HashSet();
        Set<Class<?>> initial = Misc.findAllInterfaces(elements.get(0).getClass());
        classes.addAll(initial);
        for (T element : elements) {
            chain.add(element);
            Set<Class<?>> interfaces = Misc.findAllInterfaces(element.getClass());
            classes.retainAll(interfaces);
        }
        if (classes.size() == 0) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_6", elements);
            throw new IllegalArgumentException(message);
        }
        return (T)Proxy.newProxyInstance(Misc.class.getClassLoader(), classes.toArray(new Class[classes.size()]), chain);
    }

    public static <T> T getLoggerProxyFor(T target, Logger logger) {
        Set<Class<?>> classes = Misc.findAllInterfaces(target.getClass());
        return (T)Proxy.newProxyInstance(Misc.class.getClassLoader(), classes.toArray(new Class[classes.size()]), new LoggingInvocationHandler<T>(target, logger));
    }

    public static NullCheckResult findNull(Object ... params) {
        if (params == null) {
            BitSet bitSet = new BitSet(1);
            bitSet.set(0);
            return new NullCheckResult(bitSet, 1);
        }
        BitSet bitSet = new BitSet(params.length);
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                bitSet.set(i, true);
                continue;
            }
            bitSet.set(i, false);
        }
        return new NullCheckResult(bitSet, params.length);
    }

    public static void checkArgsNotNull(Object ... params) {
        Misc.checkArgsNotNull(1, params);
    }

    public static void checkArgsNotNull(int offset, Object ... params) {
        NullCheckResult result = Misc.findNull(params);
        if (result.hasNull()) {
            StackTraceElement callerSTE = Misc.getCaller(offset + 1);
            String className = callerSTE.getClassName();
            String methodName = callerSTE.getMethodName();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < result.getSize(); ++i) {
                if (result.isNull(i)) {
                    sb.append("null");
                } else {
                    sb.append(params[i].getClass().getName());
                }
                if (i >= result.getSize() - 1) continue;
                sb.append(", ");
            }
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_7", className, methodName, sb.toString());
            throw new IllegalArgumentException(message);
        }
    }

    public static StackTraceElement getCaller(int offset) {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        StackTraceElement callerSTE = null;
        for (int i = 0; i < stes.length - offset - 1; ++i) {
            if (!stes[i].getClassName().equals(Misc.class.getName()) || !stes[i].getMethodName().equals("getCaller")) continue;
            callerSTE = stes[i + 1 + offset];
            break;
        }
        Misc.badStateIfNull(callerSTE, "Ouch! Can't get the stack trace back to the caller of this method!");
        return callerSTE;
    }

    public static List<String> getStringFrom(NullCheckResult nullCheckResult, String ... names) {
        int n = names.length;
        if (nullCheckResult.getSize() != n) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_8", n, nullCheckResult.getSize());
            throw new IllegalArgumentException(message);
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!nullCheckResult.hasNull()) {
            return list;
        }
        for (int i = 0; i < n; ++i) {
            if (!nullCheckResult.isNull(i)) continue;
            list.add(names[i]);
        }
        return list;
    }

    public static void badStateIfNull(Object valueToCheck, String msg) {
        Misc.badStateIfTrue(valueToCheck == null, msg);
    }

    public static void badStateIfNotNull(Object valueToCheck, String msg) {
        Misc.badStateIfTrue(valueToCheck != null, msg);
    }

    public static void badStateIfTrue(boolean valueToCheck, String msg) {
        if (valueToCheck) {
            throw new IllegalStateException(msg);
        }
    }

    public static void badStateIfFalse(boolean valueToCheck, String msg) {
        Misc.badStateIfTrue(!valueToCheck, msg);
    }

    public static void badStateIfEquals(Object a, Object b, String msg) {
        Misc.badStateIfTrue(a.equals(b), msg);
    }

    public static void dynamicLog(int offset, Level level, String msg) {
        StackTraceElement callerSTE = Misc.getCaller(offset);
        String className = callerSTE.getClassName();
        String methodName = callerSTE.getMethodName();
        Logger logger = Logger.getLogger(className);
        LogRecord record = new LogRecord(level, msg);
        record.setSourceClassName(className);
        record.setSourceMethodName(methodName);
        record.setLoggerName(logger.getName());
        logger.log(record);
    }

    public static void log(Level level, String msg) {
        Misc.dynamicLog(2, level, msg);
    }

    public static void warnIfNull(Level level, Object valueToCheck, String variableName) {
        if (valueToCheck == null) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is null!";
            Misc.dynamicLog(1, level, msg);
        }
    }

    public static void warnIfNotNull(Level level, Object valueToCheck, String variableName) {
        if (valueToCheck != null) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is not null!";
            Misc.dynamicLog(1, level, msg);
        }
    }

    public static void warnIfTrue(Level level, boolean valueToCheck, String variableName) {
        if (valueToCheck) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is true!";
            Misc.dynamicLog(1, level, msg);
        }
    }

    public static void warnIfFalse(Level level, boolean valueToCheck, String variableName) {
        if (!valueToCheck) {
            String msg = "Warning: " + (variableName == null ? "a variable" : variableName) + " is false!";
            Misc.dynamicLog(1, level, msg);
        }
    }

    public static void warnIfEquals(Level level, Object a, Object b) {
        if (a.equals(b)) {
            Misc.dynamicLog(1, level, "Warning: equals objects: " + LINE_SEPARATOR + Misc.details(a, b));
        }
    }

    private static String details(Object a, Object b) {
        return "a.toString(): " + a.toString() + LINE_SEPARATOR + "b.toString(): " + b.toString() + LINE_SEPARATOR + "a.idendityToString(): " + Misc.identityToString(a) + LINE_SEPARATOR + "b.identityToString(): " + Misc.identityToString(b);
    }

    public static void warnIfNotEquals(Level level, Object a, Object b) {
        if (!a.equals(b)) {
            Misc.dynamicLog(1, level, "Warning: non-equals objects: " + LINE_SEPARATOR + Misc.details(a, b));
        }
    }

    public static String getCurrentThreadStackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder stringBuilder = new StringBuilder();
        for (StackTraceElement element : elements) {
            stringBuilder.append(element.toString());
            stringBuilder.append(LINE_SEPARATOR);
        }
        return stringBuilder.toString();
    }

    public static String getStackTraceFrom(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static String deepToString(Object o) {
        return Misc.recursiveDeepToString(o, new HashMap<Object, String>());
    }

    private static String recursiveDeepToString(Object o, Map<Object, String> cache) {
        String result = cache.get(o);
        String id = "@" + Integer.toHexString(System.identityHashCode(o));
        if (result != null && result != id) {
            return result;
        }
        if (o == null) {
            result = "null";
        } else {
            cache.put(o, id);
            Class<?> clazz = o.getClass();
            Package pack = clazz.getPackage();
            if (clazz.isPrimitive() || pack != null && pack.getName().startsWith("java.") || clazz.isEnum()) {
                result = o.toString();
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                result = componentType.isPrimitive() ? Misc.primitiveComponentsToString(o) : Misc.componentsToString((Object[])o, true);
            } else {
                Field[] fields;
                StringBuilder sb = new StringBuilder(clazz.getName());
                sb.append('(').append(id).append(')').append("[");
                for (Field field : fields = clazz.getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                        sb.append(field.getName()).append(": ");
                        Object f = field.get(o);
                        String v = cache.get(f);
                        if (v == id) {
                            sb.append(id);
                        } else {
                            sb.append(Misc.recursiveDeepToString(f, cache));
                        }
                    }
                    catch (IllegalAccessException e) {
                        LOG.warning("An exception occured during information fetching on field: " + field + LINE_SEPARATOR + "Stack trace is: " + Misc.getStackTraceFrom(e) + "Fallbacking to non-intrusive algorithm for toString().");
                        sb.append("(*").append(field.toGenericString()).append("*)");
                    }
                    sb.append(", ");
                }
                if (fields.length != 0) {
                    sb.delete(sb.length() - 2, sb.length());
                }
                sb.append("]");
                result = new String(sb);
            }
        }
        cache.put(o, result);
        return result;
    }

    public static boolean deleteDir(File dir) {
        return Misc.deleteDir(dir, 1, 0L);
    }

    public static boolean deleteDir(File dir, int attempts, long sleepTime) {
        Misc.checkArgsNotNull(dir);
        boolean result = true;
        if (!dir.exists()) {
            return false;
        }
        if (!dir.isDirectory()) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_9", dir.getAbsolutePath());
            throw new IllegalArgumentException(message);
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Misc.deleteDir(files[i], attempts, sleepTime);
                continue;
            }
            result = result && Misc.deleteFile(files[i], attempts, sleepTime);
        }
        result = result && Misc.deleteFile(dir, attempts, sleepTime);
        return result;
    }

    public static boolean deleteFile(File f, int attempts, long sleepTime) {
        int retries = attempts;
        while (retries > 0 && !f.delete()) {
            --retries;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {}
        }
        return retries > 0;
    }

    public static void unreachableStatement() {
        String message = ExceptionManager.getInstance().getFullMessage("buc_M_10", new Object[0]);
        Misc.unreachableStatement(message);
    }

    public static void unreachableStatement(String reason) {
        throw new IllegalStateException(reason);
    }

    public static <E extends Enum<E>> E stringToEnum(Class<E> c, String s) {
        EnumSet<Enum> set = EnumSet.allOf(c);
        for (Enum e : set) {
            if (!e.toString().equals(s)) continue;
            return (E)e;
        }
        String message = ExceptionManager.getInstance().getFullMessage("buc_M_11", c.getName(), s, set.toString());
        throw new IllegalArgumentException(message);
    }

    public static byte[] serialize(Serializable object) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(object);
        out.flush();
        Misc.close(out);
        return bos.toByteArray();
    }

    public static Serializable deserialize(byte[] buf) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bais){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                String className = desc.getName();
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return Class.forName(className, true, classLoader);
            }
        };
        Serializable newObject = (Serializable)ois.readObject();
        ois.close();
        bais.close();
        return newObject;
    }

    public static <T extends Serializable> Throwable checkReallySerializable(T object) {
        try {
            byte[] buf = Misc.serialize(object);
            Misc.deserialize(buf);
            return null;
        }
        catch (Throwable t) {
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String s, File f) throws IOException {
        Misc.checkArgsNotNull(s, f);
        FileWriter writer = new FileWriter(f);
        try {
            writer.write(s);
            writer.flush();
        }
        finally {
            Misc.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File file, byte[] fileContent) throws IOException {
        Misc.checkArgsNotNull(file, fileContent);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(fileContent);
            os.flush();
        }
        catch (Throwable throwable) {
            Misc.close(os);
            throw throwable;
        }
        Misc.close(os);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        File tmpDir = null;
        int retryNumber = 10;
        int j = 0;
        boolean succeded = false;
        do {
            try {
                int lastIndexOfSeparatorChar = prefix.lastIndexOf("/");
                String fileName = prefix;
                if (lastIndexOfSeparatorChar > -1) {
                    String dirToCreate = prefix.substring(0, lastIndexOfSeparatorChar);
                    new File(directory.getAbsolutePath() + File.separator + dirToCreate).mkdirs();
                    fileName = prefix.substring(lastIndexOfSeparatorChar, prefix.length());
                }
                tmpDir = File.createTempFile(fileName, suffix, directory);
                succeded = true;
            }
            catch (IOException e) {
                if (j == 10) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                ++j;
            }
        } while (!succeded);
        return tmpDir;
    }

    public static byte[] generateJar(Class<?> ... classes) throws IOException {
        return Misc.generateJar(Misc.getResources(classes));
    }

    public static Map<String, byte[]> getResources(Class<?> ... classes) throws IOException {
        if (classes == null || classes.length == 0) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_13", new Object[0]);
            throw new IOException(message);
        }
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Class<?> clazz : classes) {
            resources.put(clazz.getName().replace(".", "/") + ".class", ClassDataTool.getClassData(clazz));
        }
        return resources;
    }

    public static byte[] generateJar(Map<String, byte[]> resources) throws IOException {
        if (resources == null || resources.size() == 0) {
            String message = ExceptionManager.getInstance().getFullMessage("buc_M_14", new Object[0]);
            throw new IOException(message);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream(new BufferedOutputStream(baos));
        for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
            out.putNextEntry(new JarEntry(resource.getKey()));
            out.write(resource.getValue());
        }
        out.flush();
        Misc.close(out);
        byte[] jar = baos.toByteArray();
        Misc.close(baos);
        return jar;
    }

    public static Map<String, byte[]> getResourcesFromZip(byte[] barContent) throws IOException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        ByteArrayInputStream in = new ByteArrayInputStream(barContent);
        ZipInputStream zis = new ZipInputStream(in);
        ZipEntry zipEntry = null;
        while ((zipEntry = zis.getNextEntry()) != null) {
            int c;
            if (zipEntry.isDirectory()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[512];
            while ((c = zis.read(buffer)) != -1) {
                baos.write(buffer, 0, c);
            }
            baos.flush();
            resources.put(zipEntry.getName(), baos.toByteArray());
            Misc.close(baos);
        }
        Misc.close(zis);
        Misc.close(in);
        return resources;
    }

    public static <T> T lookup(String name, Hashtable<String, String> environment) throws NamingException {
        InitialContext initialContext = null;
        initialContext = environment != null ? new InitialContext(environment) : new InitialContext();
        return (T)initialContext.lookup(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prefixAllLines(String message, String prefix) {
        Misc.checkArgsNotNull(message, prefix);
        if (message.length() == 0) {
            return prefix;
        }
        BufferedReader reader = new BufferedReader(new StringReader(message));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (builder.length() != 0) {
                    builder.append(LINE_SEPARATOR);
                }
                builder.append(prefix).append(line);
            }
        }
        catch (IOException e) {
            String msg = ExceptionManager.getInstance().getFullMessage("buc_M_15", new Object[0]);
            Misc.unreachableStatement(msg);
        }
        finally {
            Misc.close(reader);
        }
        return builder.toString();
    }

    public static void showProblems(Collection<Problem> problems, String description) {
        if (problems != null) {
            StringBuffer errorMsg = null;
            for (Problem p : problems) {
                if (p.getSeverity().equals("error") || p.getSeverity().equals("fatal-error")) {
                    if (errorMsg == null) {
                        errorMsg = new StringBuffer();
                    }
                    errorMsg.append(LINE_SEPARATOR);
                    errorMsg.append("  ");
                    errorMsg.append(p.toString());
                    if (p.getCause() != null) {
                        LOG.severe(p.toString() + ". Cause: " + p.getCause());
                        continue;
                    }
                    LOG.severe(p.toString());
                    continue;
                }
                LOG.info("WARNING: " + p.toString());
            }
            if (errorMsg != null) {
                String message = ExceptionManager.getInstance().getFullMessage("bp_Pa_1", description, errorMsg);
                throw new BonitaRuntimeException(message);
            }
        }
    }

    public static Object convertIfPossible(String variableId, Object variableValue, String dataTypeClassName) {
        if (variableValue == null) {
            return null;
        }
        try {
            Class<?> destTypeClass = Class.forName(dataTypeClassName, true, Thread.currentThread().getContextClassLoader());
            Class<?> valueClass = variableValue.getClass();
            boolean assignmentOK = destTypeClass.isAssignableFrom(valueClass);
            if (assignmentOK || destTypeClass.getName().equals(valueClass.getName())) {
                return variableValue;
            }
            if ("java.lang".equals(valueClass.getPackage().getName()) && "java.lang".equals(destTypeClass.getPackage().getName())) {
                String varValueAsString = variableValue.toString();
                if (destTypeClass.equals(String.class)) {
                    return varValueAsString;
                }
                if (destTypeClass.equals(Boolean.class)) {
                    if ("true".equals(varValueAsString) || "false".equals(varValueAsString)) {
                        return Boolean.valueOf(varValueAsString);
                    }
                } else if (destTypeClass.equals(Character.class)) {
                    if (varValueAsString != null && varValueAsString.length() == 1) {
                        return Character.valueOf(variableValue.toString().charAt(0));
                    }
                } else {
                    try {
                        Method valueOf = destTypeClass.getMethod("valueOf", String.class);
                        return valueOf.invoke(destTypeClass, varValueAsString);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return variableValue;
        }
        catch (ClassNotFoundException e) {
            throw new BonitaRuntimeException(e);
        }
    }

    public static String getAttachmentIndexName(String name, Date versionDate) {
        Misc.checkArgsNotNull(name, versionDate);
        return name + ATTACHMENT_INDEX_NAME_SEPARATOR + versionDate.getTime();
    }

    public static String getAttachmentName(String indexName) {
        Misc.checkArgsNotNull(indexName);
        return indexName.substring(0, indexName.lastIndexOf(ATTACHMENT_INDEX_NAME_SEPARATOR));
    }

    public static String getActivityPriority(int priority) {
        return Misc.getActivityPriority(priority, Locale.getDefault());
    }

    public static String getActivityPriority(int priority, Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("org.ow2.bonita.util.Priority", locale);
        try {
            if (priority < 0 || priority > 2) {
                return bundle.getString(String.valueOf(0));
            }
            return bundle.getString(String.valueOf(priority));
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Priority: " + priority + " has no label", e);
        }
    }

    public static Object deserialize(byte[] buf, Properties contextProperties) throws IOException, ClassNotFoundException {
        Serializable res = Misc.deserialize(buf);
        if (res == null) {
            return null;
        }
        if (res instanceof String && contextProperties != null) {
            return ProcessBuilder.resolveWithContext((String)((Object)res), contextProperties);
        }
        if (res.getClass().isArray() && contextProperties != null) {
            Object[] array = (Object[])res;
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof String)) continue;
                array[i] = ProcessBuilder.resolveWithContext((String)array[i], contextProperties);
            }
            return array;
        }
        return res;
    }

    public static String fragmentAndBase64Encode(byte[] bytes) throws IOException {
        StringBuilder encodedString = new StringBuilder();
        int bytesFragmentLength = 65536;
        int nbFragment = bytes.length / bytesFragmentLength;
        int remainingBytes = bytes.length % bytesFragmentLength;
        if (remainingBytes > 0) {
            ++nbFragment;
        }
        int bytesPosition = 0;
        for (int nbFragmentsProcessed = 0; nbFragmentsProcessed < nbFragment; ++nbFragmentsProcessed) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            if (nbFragmentsProcessed + 1 < nbFragment) {
                byteArrayOutputStream = new ByteArrayOutputStream(bytesFragmentLength);
                byteArrayOutputStream.write(bytes, bytesPosition, bytesFragmentLength);
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream(remainingBytes);
                byteArrayOutputStream.write(bytes, bytesPosition, remainingBytes);
            }
            String stringFragment = Base64.encodeBytes(byteArrayOutputStream.toByteArray());
            if (bytesPosition != 0) {
                encodedString.append(BASE64_BYTES_FRAGMENT_SEPARATOR);
            }
            encodedString.append(stringFragment);
            byteArrayOutputStream.close();
            bytesPosition += bytesFragmentLength;
        }
        return encodedString.toString();
    }

    public static byte[] base64DecodeAndGather(String encodedString) throws IOException {
        String[] encodedFragments = encodedString.split(BASE64_BYTES_FRAGMENT_SEPARATOR);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (String encodedFragment : encodedFragments) {
            byte[] decodedFragment = Base64.decode(encodedFragment);
            byteArrayOutputStream.write(decodedFragment);
        }
        byte[] decodedBytes = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return decodedBytes;
    }

    public static String hash(String text) {
        if (text == null) {
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new BonitaRuntimeException(e);
        }
        byte[] hash = null;
        try {
            hash = md.digest(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new BonitaRuntimeException(e);
        }
        StringBuilder sb = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            sb.append(String.format("%x", b));
        }
        return sb.toString();
    }

    public static String getGroovyPlaceholderAccessExpression(String variableId) {
        String[] segments = variableId.split("#");
        return segments[1];
    }

    public static String getSetterName(String variableId) {
        String[] segments = variableId.split("#");
        return segments[2];
    }

    public static File createDirectories(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    static {
        DELAY_FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT"));
        SEQUENCE_NUMBER = new AtomicLong(0L);
    }

    public static class NullCheckResult {
        private final int size;
        private final BitSet bitSet;

        NullCheckResult(BitSet bitSet, int size) {
            this.bitSet = bitSet;
            this.size = size;
        }

        public boolean hasNull() {
            return this.bitSet.cardinality() != 0;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isNull(int i) {
            return this.bitSet.get(i);
        }
    }
}

