/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.EventProcessDefinition;
import org.ow2.bonita.facade.exception.DocumentAlreadyExistsException;
import org.ow2.bonita.facade.exception.DocumentNotFoundException;
import org.ow2.bonita.facade.exception.DocumentationCreationException;
import org.ow2.bonita.facade.exception.ProcessNotFoundException;
import org.ow2.bonita.facade.impl.FacadeUtil;
import org.ow2.bonita.facade.impl.SearchResult;
import org.ow2.bonita.facade.runtime.InitialAttachment;
import org.ow2.bonita.facade.runtime.ProcessInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityDefinitionUUID;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.search.DocumentSearchBuilder;
import org.ow2.bonita.search.index.DocumentIndex;
import org.ow2.bonita.services.Document;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.type.Variable;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.DateUtil;
import org.ow2.bonita.util.DocumentService;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.GroovyUtil;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.VariableUtil;

public class ProcessUtil {
    static final Logger LOG = Logger.getLogger(ProcessUtil.class.getName());

    public static void removeAllInstanceEvents(ProcessInstance instance) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeSubscriptions(instance.getUUID());
        Set<OutgoingEventInstance> outgoings = eventService.getOutgoingEvents(instance.getUUID());
        for (OutgoingEventInstance outgoing : outgoings) {
            eventService.removeEvent(outgoing);
        }
    }

    public static void removeSubProcessEvents(ProcessInstance instance) {
        Querier database = EnvTool.getJournalQueriers();
        InternalProcessDefinition process = database.getProcess(instance.getProcessDefinitionUUID());
        if (process != null) {
            EventService eventService = EnvTool.getEventService();
            for (EventProcessDefinition eventSubProcess : process.getEventSubProcesses()) {
                InternalProcessDefinition eventProcess = EnvTool.getJournalQueriers().getProcess(eventSubProcess.getName(), eventSubProcess.getVersion());
                ActivityDefinition startEvent = ProcessUtil.getStartEvent(eventProcess);
                if (!startEvent.isTimer()) continue;
                InternalProcessDefinition def = database.getProcess(startEvent.getProcessDefinitionUUID());
                Set<OutgoingEventInstance> delete = eventService.getOutgoingEvents("**bonita_timer**-" + startEvent.getUUID(), def.getName(), startEvent.getName(), null);
                if (delete.isEmpty()) continue;
                eventService.removeEvent(delete.iterator().next());
            }
        }
    }

    public static void removeInternalInstanceEvents(ProcessInstanceUUID instanceUUID) {
        EventService eventService = EnvTool.getEventService();
        eventService.removeSubscriptions(instanceUUID);
        Set<OutgoingEventInstance> outgoings = eventService.getOutgoingEvents(instanceUUID);
        for (OutgoingEventInstance outgoing : outgoings) {
            String name = outgoing.getName();
            if (!name.startsWith("**bonita_timer**-") && !name.startsWith("**bonita_deadline**-") && !name.startsWith("**bonita_async**-")) continue;
            eventService.removeEvent(outgoing);
        }
    }

    public static Date getTimerDate(String condition, ProcessDefinitionUUID definitionUUID, long lastTime) throws GroovyException {
        return ProcessUtil.getTimerDate(condition, definitionUUID, null, lastTime);
    }

    public static Date getTimerDate(String condition, ActivityInstanceUUID activityUUID) throws GroovyException {
        return ProcessUtil.getTimerDate(condition, null, activityUUID, 0L);
    }

    private static Date getTimerDate(String condition, ProcessDefinitionUUID definitionUUID, ActivityInstanceUUID activityUUID, long lastTime) throws GroovyException {
        Misc.checkArgsNotNull(condition);
        Date dueDate = null;
        String evaluatedCondition = condition;
        if (Misc.isJustAGroovyExpression(condition)) {
            Object value = null;
            if (activityUUID != null) {
                value = GroovyUtil.evaluate(condition, null, activityUUID, false, false);
            } else {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("timerLastExecution", lastTime);
                value = GroovyUtil.evaluate(condition, context, definitionUUID, false);
            }
            if (value instanceof Date) {
                dueDate = (Date)value;
            } else if (value instanceof String) {
                evaluatedCondition = (String)value;
            } else if (value instanceof Long) {
                evaluatedCondition = ((Long)value).toString();
            } else if (value instanceof Integer) {
                evaluatedCondition = ((Integer)value).toString();
            }
        }
        if (dueDate == null) {
            try {
                Long date = Long.parseLong(evaluatedCondition);
                dueDate = activityUUID != null ? new Date(System.currentTimeMillis() + date) : (lastTime < 0L ? new Date(System.currentTimeMillis() + date) : new Date(date));
            }
            catch (NumberFormatException e1) {
                try {
                    if (dueDate == null) {
                        dueDate = DateUtil.parseDate(evaluatedCondition);
                    }
                }
                catch (IllegalArgumentException e2) {
                    throw new BonitaRuntimeException("Timer condition '" + evaluatedCondition + "' is neither a Long nor a formatted date", e2);
                }
            }
        }
        return dueDate;
    }

    public static Execution createProcessInstance(ProcessDefinitionUUID processUUID, Map<String, Object> variables, Collection<InitialAttachment> attachments, ProcessInstanceUUID parentInstanceUUID, ProcessInstanceUUID rootInstanceUUID, ActivityDefinitionUUID activityUUID, ActivityInstanceUUID parentActivityUUID) throws ProcessNotFoundException {
        InternalProcessDefinition process = FacadeUtil.getProcessDefinition(processUUID);
        Execution rootExecution = ProcessUtil.createProcessInstance(process, rootInstanceUUID, activityUUID);
        InternalProcessInstance instance = rootExecution.getInstance();
        Recorder recorder = EnvTool.getRecorder();
        Map<String, Variable> givenVariables = VariableUtil.createVariableMap(processUUID, variables);
        Map<String, Variable> processVariables = VariableUtil.createVariables(process.getDataFields(), null, variables);
        HashMap<String, Variable> initialVariables = new HashMap<String, Variable>();
        if (processVariables != null) {
            initialVariables.putAll(processVariables);
        }
        if (givenVariables != null) {
            initialVariables.putAll(givenVariables);
        }
        instance.setParentUUIDs(parentInstanceUUID, parentActivityUUID);
        instance.setInitialVaribales(initialVariables);
        String initiator = EnvTool.getUserId();
        if (parentInstanceUUID != null) {
            InternalProcessInstance parentInstance = EnvTool.getJournalQueriers().getProcessInstance(parentInstanceUUID);
            initiator = parentInstance.getStartedBy();
        }
        DocumentationManager manager = EnvTool.getDocumentationManager();
        HashSet<String> runtimeAttachmentNames = new HashSet<String>();
        if (attachments != null) {
            for (InitialAttachment attachment : attachments) {
                block21: {
                    try {
                        InternalProcessInstance rootProcessInstance;
                        Document createDocument;
                        byte[] content = attachment.getContent();
                        if (content != null) {
                            String mimeType = attachment.getMetaData().get("content-type");
                            if (mimeType == null) {
                                mimeType = "application/octet-stream";
                            }
                            createDocument = manager.createDocument(attachment.getName(), processUUID, instance.getUUID(), attachment.getFileName(), mimeType, content);
                        } else {
                            createDocument = manager.createDocument(attachment.getName(), processUUID, instance.getUUID());
                        }
                        if (rootInstanceUUID == null || rootInstanceUUID.equals(instance.getUUID()) || (rootProcessInstance = FacadeUtil.getInstance(rootInstanceUUID, null)) == null || rootProcessInstance.getProcessDefinitionUUID() == null) break block21;
                        try {
                            DocumentSearchBuilder criterion = new DocumentSearchBuilder().leftParenthesis().criterion(DocumentIndex.PROCESS_INSTANCE_UUID).equalsTo(rootProcessInstance.getProcessInstanceUUID().getValue()).rightParenthesis().and().leftParenthesis().criterion(DocumentIndex.NAME).equalsTo(createDocument.getName()).rightParenthesis();
                            SearchResult search = manager.search(criterion, 0, 1);
                            if (search.getCount() == 0) {
                                manager.attachDocumentTo(rootProcessInstance.getProcessDefinitionUUID(), rootInstanceUUID, createDocument.getId());
                            }
                        }
                        catch (DocumentNotFoundException e) {
                            throw new BonitaRuntimeException(e);
                        }
                    }
                    catch (DocumentAlreadyExistsException e) {
                        throw new BonitaRuntimeException(e);
                    }
                    catch (DocumentationCreationException e) {
                        throw new BonitaRuntimeException(e);
                    }
                }
                runtimeAttachmentNames.add(attachment.getName());
            }
            instance.setNbOfAttachments(attachments.size());
        } else {
            instance.setNbOfAttachments(0);
        }
        for (AttachmentDefinition attachmentDefinition : process.getAttachments().values()) {
            String attachmentName = attachmentDefinition.getName();
            if (runtimeAttachmentNames.contains(attachmentName)) continue;
            try {
                ProcessDefinitionUUID definitionUUID = attachmentDefinition.getProcessDefinitionUUID();
                SearchResult result = DocumentService.getDocuments(manager, definitionUUID, attachmentName);
                List<Document> documents = result.getDocuments();
                Document document = null;
                Iterator<Document> iterator = documents.iterator();
                while (iterator.hasNext() && document == null) {
                    Document next = iterator.next();
                    if (next.getProcessInstanceUUID() != null) continue;
                    document = next;
                }
                if (document == null) {
                    throw new BonitaRuntimeException("Cannot retrieve document");
                }
                byte[] content = manager.getContent(document);
                manager.createDocument(attachmentDefinition.getName(), processUUID, instance.getUUID(), attachmentDefinition.getFileName(), "application/octet-stream", content);
                int previousNbOfAttachments = instance.getNbOfAttachments();
                if (previousNbOfAttachments <= 0) {
                    instance.setNbOfAttachments(1);
                    continue;
                }
                instance.setNbOfAttachments(previousNbOfAttachments + 1);
            }
            catch (Exception e) {
                throw new BonitaRuntimeException(e);
            }
        }
        recorder.recordInstanceStarted(instance, initiator);
        ConnectorExecutor.executeConnectors(rootExecution, HookDefinition.Event.instanceOnStart);
        return rootExecution;
    }

    public static void startEventSubProcesses(ProcessInstance instance) throws ProcessNotFoundException {
        ProcessInstanceUUID instanceUUID = instance.getUUID();
        InternalProcessDefinition process = FacadeUtil.getProcessDefinition(instance.getProcessDefinitionUUID());
        for (EventProcessDefinition eventSubProcess : process.getEventSubProcesses()) {
            InternalProcessDefinition eventProcess = EnvTool.getJournalQueriers().getProcess(eventSubProcess.getName(), eventSubProcess.getVersion());
            if (eventProcess == null) {
                throw new ProcessNotFoundException("bs_PU_1", eventSubProcess.getName(), eventSubProcess.getVersion());
            }
            ActivityDefinition startEvent = ProcessUtil.getStartEvent(eventProcess);
            if (startEvent.isTimer()) {
                EventService eventService = EnvTool.getEventService();
                String eventName = "**bonita_timer**-" + startEvent.getUUID();
                String condition = startEvent.getTimerCondition();
                try {
                    OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, eventProcess.getName(), startEvent.getName(), null, null, null, -1L);
                    eventService.fire(outgoing);
                    Date date = ProcessUtil.getTimerDate(condition, process.getUUID(), -1L);
                    long enableTime = date.getTime();
                    IncomingEventInstance timerEventInstance = new IncomingEventInstance(eventName, condition, null, startEvent.getUUID(), null, eventProcess.getName(), startEvent.getName(), null, "event.start.timer", enableTime, false);
                    timerEventInstance.setPermanent(true);
                    timerEventInstance.setEventSubProcessRootInstanceUUID(instanceUUID);
                    eventService.subscribe(timerEventInstance);
                    continue;
                }
                catch (GroovyException e) {
                    throw new DeploymentRuntimeException(e.getMessage(), e.getCause());
                }
            }
            if (startEvent.isCatchingSignalEvent()) {
                String eventName = startEvent.getTimerCondition();
                IncomingEventInstance signalEventInstance = new IncomingEventInstance(eventName, null, null, startEvent.getUUID(), null, eventProcess.getName(), startEvent.getName(), null, "event.start.signal", -1L, false);
                signalEventInstance.setPermanent(true);
                signalEventInstance.setEventSubProcessRootInstanceUUID(instanceUUID);
                EventService eventService = EnvTool.getEventService();
                eventService.subscribe(signalEventInstance);
                continue;
            }
            if (startEvent.isReceiveEvent()) {
                IncomingEventDefinition event = startEvent.getIncomingEvent();
                if (event == null) continue;
                EventService eventService = EnvTool.getEventService();
                IncomingEventInstance incomingEventInstance = new IncomingEventInstance(event.getName(), event.getExpression(), null, startEvent.getUUID(), null, eventProcess.getName(), startEvent.getName(), null, "event.start.message", System.currentTimeMillis(), false);
                incomingEventInstance.setPermanent(true);
                incomingEventInstance.setEventSubProcessRootInstanceUUID(instanceUUID);
                eventService.subscribe(incomingEventInstance);
                continue;
            }
            if (!startEvent.isCatchingErrorEvent()) continue;
            String errorCode = startEvent.getTimerCondition();
            StringBuilder builder = new StringBuilder(startEvent.getName());
            builder.append("@3^3NT5@");
            if (errorCode != null) {
                builder.append(errorCode);
            } else {
                builder.append("all");
            }
            IncomingEventInstance errorEventInstance = new IncomingEventInstance(builder.toString(), null, null, startEvent.getUUID(), null, eventProcess.getName(), startEvent.getName(), null, "event.start.error", -1L, true);
            errorEventInstance.setPermanent(true);
            errorEventInstance.setEventSubProcessRootInstanceUUID(instanceUUID);
            EventService eventService = EnvTool.getEventService();
            eventService.subscribe(errorEventInstance);
        }
    }

    private static ActivityDefinition getStartEvent(InternalProcessDefinition eventProcess) {
        for (ActivityDefinition activity : eventProcess.getActivities()) {
            if (!activity.getIncomingTransitions().isEmpty()) continue;
            return activity;
        }
        return null;
    }

    private static Execution createProcessInstance(InternalProcessDefinition process, ProcessInstanceUUID rootInstanceUUID, ActivityDefinitionUUID activityUUID) {
        ProcessDefinitionUUID processUUID = process.getUUID();
        long instanceNb = EnvTool.getUUIDService().getNewProcessInstanceNb(processUUID);
        ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(processUUID, instanceNb);
        ProcessInstanceUUID theRootInstanceUUID = null;
        theRootInstanceUUID = rootInstanceUUID == null ? instanceUUID : rootInstanceUUID;
        InternalProcessInstance instance = new InternalProcessInstance(instanceUUID, process, theRootInstanceUUID, instanceNb);
        Execution processInstance = instance.getRootExecution();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("creating new execution for process '" + process.getName() + "'");
        }
        return processInstance;
    }
}

