/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.exception.VariableNotFoundException;
import org.ow2.bonita.facade.runtime.ActivityState;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.VariableUtil;

public class TransientData {
    static final Logger LOG = Logger.getLogger(TransientData.class.getName());
    private static Map<ActivityInstanceUUID, Map<String, Object>> transientData;

    private TransientData() {
    }

    private static Map<ActivityInstanceUUID, Map<String, Object>> getTransientData() {
        if (transientData == null) {
            transientData = new HashMap<ActivityInstanceUUID, Map<String, Object>>();
        }
        return transientData;
    }

    public static void addTransientVariable(ActivityInstanceUUID activityInstanceUUID, String variableName, Object variableValue) {
        Misc.checkArgsNotNull(activityInstanceUUID, variableName);
        Map<ActivityInstanceUUID, Map<String, Object>> data = TransientData.getTransientData();
        if (!data.containsKey(activityInstanceUUID)) {
            data.put(activityInstanceUUID, new HashMap());
        }
        data.get(activityInstanceUUID).put(variableName, variableValue);
    }

    public static void addTransientVariables(ActivityInstanceUUID activityInstanceUUID, Map<String, Object> variables) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        if (variables != null) {
            Map<ActivityInstanceUUID, Map<String, Object>> data = TransientData.getTransientData();
            if (!data.containsKey(activityInstanceUUID)) {
                data.put(activityInstanceUUID, new HashMap());
            }
            data.get(activityInstanceUUID).putAll(variables);
        }
    }

    public static void removeTransientData(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        TransientData.getTransientData().remove(activityInstanceUUID);
    }

    public static Map<String, Object> getActivityTransientVariables(ActivityInstanceUUID activityInstanceUUID) {
        Misc.checkArgsNotNull(activityInstanceUUID);
        TransientData.ensureTransientVariablesCreated(activityInstanceUUID);
        Map<String, Object> variables = TransientData.getTransientData().get(activityInstanceUUID);
        variables = variables != null ? new HashMap<String, Object>(variables) : new HashMap<String, Object>();
        return variables;
    }

    public static Object getActivityTransientVariableValue(ActivityInstanceUUID activityInstanceUUID, String variableName) throws VariableNotFoundException {
        Misc.checkArgsNotNull(activityInstanceUUID, variableName);
        TransientData.ensureTransientVariablesCreated(activityInstanceUUID);
        Map<String, Object> variables = TransientData.getActivityTransientVariables(activityInstanceUUID);
        if (variables == null || !variables.containsKey(variableName)) {
            throw new VariableNotFoundException("bai_QRAPII_12", activityInstanceUUID, variableName);
        }
        return variables.get(variableName);
    }

    public static void updateActivityTransientVariableValue(ActivityInstanceUUID activityInstanceUUID, String variableName, Object value) throws VariableNotFoundException {
        Misc.checkArgsNotNull(activityInstanceUUID, variableName);
        TransientData.ensureTransientVariablesCreated(activityInstanceUUID);
        Map<String, Object> variables = TransientData.getTransientData().get(activityInstanceUUID);
        if (variables == null || !variables.containsKey(variableName)) {
            throw new VariableNotFoundException("bai_QRAPII_12", activityInstanceUUID, variableName);
        }
        variables.put(variableName, value);
    }

    private static void ensureTransientVariablesCreated(ActivityInstanceUUID activityInstanceUUID) {
        Map<ActivityInstanceUUID, Map<String, Object>> data = TransientData.getTransientData();
        if (!data.containsKey(activityInstanceUUID)) {
            TransientData.restoreTransientVariablesIfNecessary(activityInstanceUUID);
        }
    }

    private static void restoreTransientVariablesIfNecessary(ActivityInstanceUUID activityInstanceUUID) {
        InternalActivityDefinition activityDefinition;
        Map<String, Object> transientVariables;
        InternalActivityInstance activityInstance = EnvTool.getJournalQueriers().getActivityInstance(activityInstanceUUID);
        if (activityInstance != null && TransientData.needRestore(activityInstance.getState()) && (transientVariables = VariableUtil.createTransientVariables((activityDefinition = EnvTool.getJournalQueriers().getActivity(activityInstance.getActivityDefinitionUUID())).getDataFields(), activityInstance.getProcessInstanceUUID())) != null && !transientVariables.isEmpty()) {
            TransientData.addTransientVariables(activityInstanceUUID, transientVariables);
            if (LOG.isLoggable(Level.WARNING)) {
                StringBuilder stb = new StringBuilder("Restoring transient varaibles for activity ");
                stb.append(activityInstanceUUID);
                stb.append(": the system probably was stopped during the variable life cycle. All transient variables for this activity will be restored to their default value.");
                LOG.warning(stb.toString());
            }
        }
    }

    private static boolean needRestore(ActivityState state) {
        return ActivityState.EXECUTING.equals((Object)state) || ActivityState.READY.equals((Object)state) || ActivityState.SUSPENDED.equals((Object)state);
    }
}

