/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.hibernate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.util.Command;

public class HibernateListCommand<T>
implements Command<List<T>> {
    private static final long serialVersionUID = -522051467458658712L;
    private String sessionName;
    private String query;
    private Map<String, String> stringParameters;

    public HibernateListCommand(String sessionName, String query) {
        this.sessionName = sessionName;
        this.query = query;
    }

    protected void addStringParameter(String key, String value) {
        if (this.stringParameters == null) {
            this.stringParameters = new HashMap<String, String>();
        }
        this.stringParameters.put(key, value);
    }

    @Override
    public List<T> execute(Environment environment) throws Exception {
        Session session = (Session)environment.get(this.sessionName);
        Query query = session.createQuery(this.query);
        if (this.stringParameters != null) {
            for (Map.Entry<String, String> stringParameter : this.stringParameters.entrySet()) {
                query.setString(stringParameter.getKey(), stringParameter.getValue());
            }
        }
        query.setCacheable(true);
        ArrayList result = new ArrayList();
        result.addAll(query.list());
        return result;
    }
}

