/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.xml;

import java.io.Serializable;
import org.xml.sax.SAXParseException;

public class Problem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEVERITY_WARNING = "warning";
    public static final String SEVERITY_ERROR = "error";
    public static final String SEVERITY_FATALERROR = "fatal-error";
    String resource;
    String severity;
    Integer line = -1;
    Integer column = -1;
    String msg;
    Throwable cause;

    public Problem(String msg, String severity) {
        this.severity = severity;
        this.msg = msg;
    }

    public Problem(String msg, Exception e, String severity) {
        this.severity = severity;
        this.msg = msg;
        this.cause = e;
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            this.resource = spe.getPublicId();
            this.line = spe.getLineNumber();
            this.column = spe.getColumnNumber();
        }
    }

    public Throwable getCause() {
        return this.cause;
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int columnNumber) {
        this.column = columnNumber;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int lineNumber) {
        this.line = lineNumber;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append(this.severity);
        text.append(" : ");
        text.append(this.msg);
        text.append(" ");
        if (this.line != -1 || this.column != -1 || this.resource != null) {
            text.append("[");
            if (this.line != -1) {
                text.append("line=" + this.line + " ");
            }
            if (this.column != -1) {
                text.append("column=" + this.column + " ");
            }
            if (this.resource != null) {
                text.append("resource=" + this.resource + " ");
            }
            text.append("]");
        }
        if (this.cause != null) {
            text.append(": " + this.cause.toString());
        }
        return text.toString();
    }
}

