/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.util.xml;

import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.xml.Binding;
import org.ow2.bonita.util.xml.XmlUtil;
import org.w3c.dom.Element;

public abstract class TagBinding
implements Binding {
    protected String category;
    protected String tagName;
    protected String namespaceUri;

    public TagBinding(String tagName, String namespaceUri, String category) {
        if (tagName == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bp_TB_1", new Object[0]);
            throw new BonitaRuntimeException(message);
        }
        this.tagName = tagName;
        this.namespaceUri = namespaceUri;
        this.category = category;
    }

    @Override
    public boolean matches(Element element) {
        String elementNamespaceUri = element.getNamespaceURI();
        if (elementNamespaceUri != null && this.namespaceUri != null && !this.namespaceUri.equals(elementNamespaceUri)) {
            return false;
        }
        String elementTagLocalName = XmlUtil.getTagLocalName(element);
        return this.tagName.equals(elementTagLocalName);
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String toString() {
        return this.tagName;
    }
}

