/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectReferenceHandler;
import org.apache.cxf.binding.corba.utils.CorbaUtils;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaObjectReferenceListener
extends AbstractCorbaTypeListener {
    private final CorbaObjectReferenceHandler value;
    private final ORB orb;

    public CorbaObjectReferenceListener(CorbaObjectHandler handler, ORB orbRef) {
        super(handler);
        this.orb = orbRef;
        this.value = (CorbaObjectReferenceHandler)handler;
        this.value.setReference(null);
    }

    public void processCharacters(String text) {
        if (this.currentElement != null && this.currentElement.getLocalPart().equals("Address")) {
            Object ref = null;
            if (text.equals("http://www.w3.org/2005/08/addressing/anonymous")) {
                throw new RuntimeException("Anonymous endpoint reference types not supported");
            }
            try {
                ref = CorbaUtils.importObjectReference(this.orb, text);
            }
            catch (BAD_PARAM ex) {
                throw new RuntimeException("Unable to resolve CORBA object with address " + text);
            }
            this.value.setReference(ref);
        }
    }
}

