/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy.attachment;

import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyProvider;
import org.apache.cxf.ws.policy.attachment.reference.RemoteReferenceResolver;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;

public abstract class AbstractPolicyProvider
implements PolicyProvider {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractPolicyProvider.class);
    protected PolicyBuilder builder;
    protected PolicyRegistry registry;
    protected Bus bus;

    protected AbstractPolicyProvider() {
        this(null);
    }

    protected AbstractPolicyProvider(Bus b) {
        this.bus = b;
    }

    public void setBus(Bus b) {
        this.bus = b;
    }

    public void setBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public void setRegistry(PolicyRegistry r) {
        this.registry = r;
    }

    @PostConstruct
    public void init() {
        if (null != this.bus) {
            this.setBuilder(this.bus.getExtension(PolicyBuilder.class));
            PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
            this.setRegistry(pe.getRegistry());
            ((PolicyEngineImpl)pe).getPolicyProviders().add(this);
        }
    }

    protected Policy resolveExternal(PolicyReference ref, String baseURI) {
        RemoteReferenceResolver resolver = new RemoteReferenceResolver(baseURI, this.builder);
        Policy resolved = this.registry.lookup(ref.getURI());
        if (null != resolved) {
            return resolved;
        }
        return resolver.resolveReference(ref.getURI());
    }

    protected boolean isExternal(PolicyReference ref) {
        return !ref.getURI().startsWith("#");
    }

    protected void checkResolved(PolicyReference ref, Policy p) {
        if (null == p) {
            throw new PolicyException(new Message("UNRESOLVED_POLICY_REFERENCE_EXC", BUNDLE, ref.getURI()));
        }
    }
}

