/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameTokenBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.USERNAME_TOKEN, SP12Constants.USERNAME_TOKEN);
    PolicyBuilder builder;

    public UsernameTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    @Override
    public PolicyAssertion build(Element element) {
        Element child;
        Element polEl;
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        UsernameToken usernameToken = new UsernameToken(consts);
        usernameToken.setOptional(PolicyConstants.isOptional(element));
        String attribute = element.getAttributeNS(element.getNamespaceURI(), "IncludeToken");
        if (attribute != null) {
            usernameToken.setInclusion(consts.getInclusionFromAttributeValue(attribute));
        }
        if ((polEl = PolicyConstants.findPolicyElement(element)) != null && (child = DOMUtils.getFirstElement(polEl)) != null) {
            QName qname = new QName(child.getNamespaceURI(), child.getLocalName());
            if ("WssUsernameToken10".equals(qname.getLocalPart())) {
                usernameToken.setUseUTProfile10(true);
            } else if ("WssUsernameToken11".equals(qname.getLocalPart())) {
                usernameToken.setUseUTProfile11(true);
            } else if (SP12Constants.NO_PASSWORD.equals(qname)) {
                usernameToken.setNoPassword(true);
            } else if (SP12Constants.HASH_PASSWORD.equals(qname)) {
                usernameToken.setHashPassword(true);
            } else if (SP12Constants.REQUIRE_DERIVED_KEYS.equals(qname)) {
                usernameToken.setDerivedKeys(true);
            } else if (SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS.equals(qname)) {
                usernameToken.setExplicitDerivedKeys(true);
            } else if (SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS.equals(qname)) {
                usernameToken.setImpliedDerivedKeys(true);
            }
        }
        return usernameToken;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

