/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd.api;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import java.io.IOException;
import java.io.InputStream;
import org.owasp.dependencycheck.data.update.nvd.api.CveItemSource;

public class JsonArrayCveItemSource
implements CveItemSource<DefCveItem> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final InputStream inputStream;
    private final JsonParser jsonParser;
    private DefCveItem currentItem;
    private DefCveItem nextItem;

    public JsonArrayCveItemSource(InputStream inputStream) throws IOException {
        this.mapper.registerModule((Module)new JavaTimeModule());
        this.inputStream = inputStream;
        this.jsonParser = this.mapper.getFactory().createParser(inputStream);
        if (this.jsonParser.nextToken() == JsonToken.START_ARRAY) {
            this.nextItem = this.readItem(this.jsonParser);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.jsonParser != null) {
            try {
                this.jsonParser.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextItem != null;
    }

    @Override
    public DefCveItem next() throws IOException {
        this.currentItem = this.nextItem;
        this.nextItem = this.readItem(this.jsonParser);
        return this.currentItem;
    }

    private DefCveItem readItem(JsonParser jsonParser) throws IOException {
        if (jsonParser.nextToken() == JsonToken.START_OBJECT) {
            return (DefCveItem)this.mapper.readValue(jsonParser, DefCveItem.class);
        }
        return null;
    }
}

