/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.syntax_check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.OpenPgpMessageSyntax;
import org.pgpainless.decryption_verification.syntax_check.StackSymbol;
import org.pgpainless.decryption_verification.syntax_check.State;
import org.pgpainless.decryption_verification.syntax_check.Syntax;
import org.pgpainless.decryption_verification.syntax_check.Transition;
import org.pgpainless.exception.MalformedOpenPgpMessageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tB\u0007\b\u0016\u00a2\u0006\u0002\u0010\nB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u0004\u0018\u00010\bJ\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/pgpainless/decryption_verification/syntax_check/PDA;", "", "syntax", "Lorg/pgpainless/decryption_verification/syntax_check/Syntax;", "initialState", "Lorg/pgpainless/decryption_verification/syntax_check/State;", "initialStack", "", "Lorg/pgpainless/decryption_verification/syntax_check/StackSymbol;", "(Lorg/pgpainless/decryption_verification/syntax_check/Syntax;Lorg/pgpainless/decryption_verification/syntax_check/State;[Lorg/pgpainless/decryption_verification/syntax_check/StackSymbol;)V", "()V", "stack", "Lkotlin/collections/ArrayDeque;", "inputs", "", "Lorg/pgpainless/decryption_verification/syntax_check/InputSymbol;", "state", "(Lorg/pgpainless/decryption_verification/syntax_check/Syntax;Lkotlin/collections/ArrayDeque;Ljava/util/List;Lorg/pgpainless/decryption_verification/syntax_check/State;)V", "assertValid", "", "isValid", "", "next", "input", "peekStack", "popStack", "pushStack", "item", "toString", "", "Companion", "pgpainless-core"})
public final class PDA {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Syntax syntax;
    @NotNull
    private final ArrayDeque<StackSymbol> stack;
    @NotNull
    private final List<InputSymbol> inputs;
    @NotNull
    private State state;
    private static final Logger LOGGER = LoggerFactory.getLogger(PDA.class);

    public PDA(@NotNull Syntax syntax, @NotNull ArrayDeque<StackSymbol> stack, @NotNull List<InputSymbol> inputs, @NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)syntax, (String)"syntax");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.syntax = syntax;
        this.stack = stack;
        this.inputs = inputs;
        this.state = state;
    }

    public PDA(@NotNull Syntax syntax, @NotNull State initialState, StackSymbol ... initialStack) {
        Intrinsics.checkNotNullParameter((Object)syntax, (String)"syntax");
        Intrinsics.checkNotNullParameter((Object)((Object)initialState), (String)"initialState");
        Intrinsics.checkNotNullParameter((Object)initialStack, (String)"initialStack");
        this(syntax, (ArrayDeque<StackSymbol>)new ArrayDeque((Collection)CollectionsKt.reversed((Iterable)ArraysKt.toList((Object[])initialStack))), new ArrayList(), initialState);
    }

    public PDA() {
        StackSymbol[] stackSymbolArray = new StackSymbol[]{StackSymbol.TERMINUS, StackSymbol.MSG};
        this((Syntax)new OpenPgpMessageSyntax(), State.OPENPGP_MESSAGE, stackSymbolArray);
    }

    public final void next(@NotNull InputSymbol input) {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        StackSymbol stackSymbol = this.popStack();
        try {
            Transition transition = this.syntax.transition(this.state, input, stackSymbol);
            this.state = transition.getNewState();
            for (StackSymbol item : transition.getPushedItems()) {
                this.pushStack(item);
            }
            this.inputs.add(input);
        }
        catch (MalformedOpenPgpMessageException e) {
            String stackFormat = stackSymbol != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)this.stack), null, null, null, (int)0, null, null, (int)63, null) + "||" + stackSymbol : CollectionsKt.joinToString$default((Iterable)((Iterable)this.stack), null, null, null, (int)0, null, null, (int)63, null);
            MalformedOpenPgpMessageException wrapped = new MalformedOpenPgpMessageException("Malformed message: After reading packet sequence " + CollectionsKt.joinToString$default((Iterable)this.inputs, null, null, null, (int)0, null, null, (int)63, null) + ", token '" + input + "' is not allowed.\nNo transition from state '" + this.state + "' with stack " + stackFormat, e);
            LOGGER.debug("Invalid input '" + input + "'", (Throwable)wrapped);
            throw wrapped;
        }
    }

    @Nullable
    public final StackSymbol peekStack() {
        return (StackSymbol)((Object)this.stack.firstOrNull());
    }

    public final boolean isValid() {
        return this.state == State.VALID && this.stack.isEmpty();
    }

    public final void assertValid() {
        if (!this.isValid()) {
            throw new MalformedOpenPgpMessageException("Pushdown Automaton is not in an acceptable state: " + this);
        }
    }

    private final StackSymbol popStack() {
        return (StackSymbol)((Object)this.stack.removeFirstOrNull());
    }

    private final void pushStack(StackSymbol item) {
        this.stack.addFirst((Object)item);
    }

    @NotNull
    public String toString() {
        return "State: " + this.state + " Stack: " + CollectionsKt.joinToString$default((Iterable)((Iterable)this.stack), null, null, null, (int)0, null, null, (int)63, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/decryption_verification/syntax_check/PDA$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOGGER$annotations", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLOGGER$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

