/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.bouncycastle.extensions.PGPSecretKeyExtensionsKt;
import org.pgpainless.encryption_signing.BcPGPHashContextContentSignerBuilder;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.key.protection.SecretKeyRingProtector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/encryption_signing/BcHashContextSigner;", "", "()V", "Companion", "pgpainless-core"})
public final class BcHashContextSigner {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final PGPSignature signHashContext(@NotNull MessageDigest hashContext, @NotNull SignatureType signatureType, @NotNull PGPSecretKeyRing secretKey, @NotNull SecretKeyRingProtector protector) {
        return Companion.signHashContext(hashContext, signatureType, secretKey, protector);
    }

    @JvmStatic
    @NotNull
    public static final PGPSignature signHashContext$pgpainless_core(@NotNull MessageDigest hashContext, @NotNull SignatureType signatureType, @NotNull PGPPrivateKey privateKey) {
        return Companion.signHashContext$pgpainless_core(hashContext, signatureType, privateKey);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0001\u00a2\u0006\u0002\b\u000bJ(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/encryption_signing/BcHashContextSigner$Companion;", "", "()V", "signHashContext", "Lorg/bouncycastle/openpgp/PGPSignature;", "hashContext", "Ljava/security/MessageDigest;", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "privateKey", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "signHashContext$pgpainless_core", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nBcHashContextSigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BcHashContextSigner.kt\norg/pgpainless/encryption_signing/BcHashContextSigner$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1603#2,9:57\n1855#2:66\n1856#2:68\n1612#2:69\n1#3:67\n1#3:70\n*S KotlinDebug\n*F\n+ 1 BcHashContextSigner.kt\norg/pgpainless/encryption_signing/BcHashContextSigner$Companion\n*L\n30#1:57,9\n30#1:66\n30#1:68\n30#1:69\n30#1:67\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final PGPSignature signHashContext(@NotNull MessageDigest hashContext, @NotNull SignatureType signatureType, @NotNull PGPSecretKeyRing secretKey, @NotNull SecretKeyRingProtector protector) {
            Iterable iterable;
            block4: {
                block3: {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Intrinsics.checkNotNullParameter((Object)hashContext, (String)"hashContext");
                    Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
                    Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
                    Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
                    KeyRingInfo info = PGPainless.Companion.inspectKeyRing$default(PGPainless.Companion, (PGPKeyRing)secretKey, null, 2, null);
                    iterable = info.getSigningSubkeys();
                    boolean $i$f$mapNotNull = false;
                    void var9_8 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        PGPSecretKey it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        PGPPublicKey it = (PGPPublicKey)element$iv$iv;
                        boolean bl2 = false;
                        if (info.getSecretKey(it.getKeyID()) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    PGPSecretKey pGPSecretKey = (PGPSecretKey)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
                    if (pGPSecretKey == null) break block3;
                    PGPSecretKey it = pGPSecretKey;
                    boolean bl = false;
                    iterable = Companion.signHashContext$pgpainless_core(hashContext, signatureType, PGPSecretKeyExtensionsKt.unlock(it, protector));
                    if (iterable != null) break block4;
                }
                throw new PGPException("Key does not contain suitable signing subkey.");
            }
            return iterable;
        }

        @JvmStatic
        @NotNull
        public final PGPSignature signHashContext$pgpainless_core(@NotNull MessageDigest hashContext, @NotNull SignatureType signatureType, @NotNull PGPPrivateKey privateKey) {
            PGPSignatureGenerator pGPSignatureGenerator;
            Intrinsics.checkNotNullParameter((Object)hashContext, (String)"hashContext");
            Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            PGPSignatureGenerator $this$signHashContext_u24lambda_u242 = pGPSignatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPHashContextContentSignerBuilder(hashContext));
            boolean bl = false;
            $this$signHashContext_u24lambda_u242.init(signatureType.getCode(), privateKey);
            PGPSignature pGPSignature = pGPSignatureGenerator.generate();
            Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"PGPSignatureGenerator(Bc\u2026              .generate()");
            return pGPSignature;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

