/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.SymmetricKeyAlgorithmNegotiator;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.info.KeyAccessor;
import org.pgpainless.util.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0002\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionBuilder;", "Lorg/pgpainless/encryption_signing/EncryptionBuilderInterface;", "()V", "discardOutput", "Lorg/pgpainless/encryption_signing/EncryptionBuilderInterface$WithOptions;", "onOutputStream", "outputStream", "Ljava/io/OutputStream;", "Companion", "WithOptionsImpl", "pgpainless-core"})
public final class EncryptionBuilder
implements EncryptionBuilderInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOGGER;

    @Override
    @NotNull
    public EncryptionBuilderInterface.WithOptions onOutputStream(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        return new WithOptionsImpl(outputStream);
    }

    @Override
    @NotNull
    public EncryptionBuilderInterface.WithOptions discardOutput() {
        return this.onOutputStream(new NullOutputStream());
    }

    @NotNull
    public static final Logger getLOGGER() {
        return Companion.getLOGGER();
    }

    @JvmStatic
    @NotNull
    public static final SymmetricKeyAlgorithm negotiateSymmetricEncryptionAlgorithm(@NotNull EncryptionOptions encryptionOptions) {
        return Companion.negotiateSymmetricEncryptionAlgorithm(encryptionOptions);
    }

    @JvmStatic
    @NotNull
    public static final CompressionAlgorithm negotiateCompressionAlgorithm(@NotNull ProducerOptions producerOptions) {
        return Companion.negotiateCompressionAlgorithm(producerOptions);
    }

    static {
        Logger logger = LoggerFactory.getLogger(EncryptionBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(EncryptionBuilder::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionBuilder$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER$annotations", "getLOGGER", "()Lorg/slf4j/Logger;", "negotiateCompressionAlgorithm", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "producerOptions", "Lorg/pgpainless/encryption_signing/ProducerOptions;", "negotiateSymmetricEncryptionAlgorithm", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "encryptionOptions", "Lorg/pgpainless/encryption_signing/EncryptionOptions;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nEncryptionBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EncryptionBuilder.kt\norg/pgpainless/encryption_signing/EncryptionBuilder$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1549#2:75\n1620#2,3:76\n*S KotlinDebug\n*F\n+ 1 EncryptionBuilder.kt\norg/pgpainless/encryption_signing/EncryptionBuilder$Companion\n*L\n50#1:75\n50#1:76,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        @JvmStatic
        public static /* synthetic */ void getLOGGER$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final SymmetricKeyAlgorithm negotiateSymmetricEncryptionAlgorithm(@NotNull EncryptionOptions encryptionOptions) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)encryptionOptions, (String)"encryptionOptions");
            Iterable $this$map$iv = encryptionOptions.getKeyViews().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KeyAccessor keyAccessor = (KeyAccessor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPreferredSymmetricKeyAlgorithms());
            }
            List preferences = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
            SymmetricKeyAlgorithm algorithm = SymmetricKeyAlgorithmNegotiator.Companion.byPopularity().negotiate(PGPainless.Companion.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy(), encryptionOptions.getEncryptionAlgorithmOverride(), preferences);
            this.getLOGGER().debug("Negotiation resulted in {} being the symmetric encryption algorithm of choice.", (Object)algorithm);
            return algorithm;
        }

        @JvmStatic
        @NotNull
        public final CompressionAlgorithm negotiateCompressionAlgorithm(@NotNull ProducerOptions producerOptions) {
            Intrinsics.checkNotNullParameter((Object)producerOptions, (String)"producerOptions");
            CompressionAlgorithm compressionAlgorithmOverride = producerOptions.getCompressionAlgorithmOverride();
            CompressionAlgorithm compressionAlgorithm = compressionAlgorithmOverride;
            if (compressionAlgorithm == null) {
                compressionAlgorithm = PGPainless.Companion.getPolicy().getCompressionAlgorithmPolicy().defaultCompressionAlgorithm();
            }
            return compressionAlgorithm;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/encryption_signing/EncryptionBuilder$WithOptionsImpl;", "Lorg/pgpainless/encryption_signing/EncryptionBuilderInterface$WithOptions;", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "getOutputStream", "()Ljava/io/OutputStream;", "withOptions", "Lorg/pgpainless/encryption_signing/EncryptionStream;", "options", "Lorg/pgpainless/encryption_signing/ProducerOptions;", "pgpainless-core"})
    public static final class WithOptionsImpl
    implements EncryptionBuilderInterface.WithOptions {
        @NotNull
        private final OutputStream outputStream;

        public WithOptionsImpl(@NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.outputStream = outputStream;
        }

        @NotNull
        public final OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        @NotNull
        public EncryptionStream withOptions(@NotNull ProducerOptions options) {
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new EncryptionStream(this.outputStream, options);
        }
    }
}

