/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.AlgorithmSuite;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.Feature;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.KeyFlag;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.generation.KeySpec;
import org.pgpainless.key.generation.KeySpecBuilderInterface;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpackets;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J!\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0005\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u001bJ!\u0010\u001c\u001a\u00020\u00002\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0005\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u001dJ!\u0010\u001e\u001a\u00020\u00002\u0012\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0005\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u001fJ\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u000fH\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/pgpainless/key/generation/KeySpecBuilder;", "Lorg/pgpainless/key/generation/KeySpecBuilderInterface;", "type", "Lorg/pgpainless/key/generation/type/KeyType;", "keyFlags", "", "Lorg/pgpainless/algorithm/KeyFlag;", "(Lorg/pgpainless/key/generation/type/KeyType;[Lorg/pgpainless/algorithm/KeyFlag;)V", "", "(Lorg/pgpainless/key/generation/type/KeyType;Ljava/util/List;)V", "algorithmSuite", "Lorg/pgpainless/algorithm/AlgorithmSuite;", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "keyCreationDate", "Ljava/util/Date;", "preferredCompressionAlgorithms", "", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "preferredHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "preferredSymmetricAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "build", "Lorg/pgpainless/key/generation/KeySpec;", "overridePreferredCompressionAlgorithms", "algorithms", "([Lorg/pgpainless/algorithm/CompressionAlgorithm;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "overridePreferredHashAlgorithms", "([Lorg/pgpainless/algorithm/HashAlgorithm;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "overridePreferredSymmetricKeyAlgorithms", "([Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;)Lorg/pgpainless/key/generation/KeySpecBuilder;", "setKeyCreationDate", "creationDate", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nKeySpecBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeySpecBuilder.kt\norg/pgpainless/key/generation/KeySpecBuilder\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,70:1\n37#2,2:71\n1#3:73\n*S KotlinDebug\n*F\n+ 1 KeySpecBuilder.kt\norg/pgpainless/key/generation/KeySpecBuilder\n*L\n33#1:71,2\n*E\n"})
public final class KeySpecBuilder
implements KeySpecBuilderInterface {
    @NotNull
    private final KeyType type;
    @NotNull
    private final List<KeyFlag> keyFlags;
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final AlgorithmSuite algorithmSuite;
    @NotNull
    private Set<? extends CompressionAlgorithm> preferredCompressionAlgorithms;
    @NotNull
    private Set<? extends HashAlgorithm> preferredHashAlgorithms;
    @NotNull
    private Set<? extends SymmetricKeyAlgorithm> preferredSymmetricAlgorithms;
    @Nullable
    private Date keyCreationDate;

    public KeySpecBuilder(@NotNull KeyType type, @NotNull List<? extends KeyFlag> keyFlags) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(keyFlags, (String)"keyFlags");
        this.type = type;
        this.keyFlags = keyFlags;
        this.hashedSubpackets = new SignatureSubpackets();
        this.algorithmSuite = PGPainless.Companion.getPolicy().getKeyGenerationAlgorithmSuite();
        this.preferredCompressionAlgorithms = this.algorithmSuite.getCompressionAlgorithms();
        this.preferredHashAlgorithms = this.algorithmSuite.getHashAlgorithms();
        this.preferredSymmetricAlgorithms = this.algorithmSuite.getSymmetricKeyAlgorithms();
        Collection $this$toTypedArray$iv = this.keyFlags;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        KeyFlag[] keyFlagArray = thisCollection$iv.toArray(new KeyFlag[0]);
        SignatureSubpacketsUtil.Companion.assureKeyCanCarryFlags(this.type, Arrays.copyOf(keyFlagArray, keyFlagArray.length));
    }

    public KeySpecBuilder(@NotNull KeyType type, KeyFlag ... keyFlags) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)keyFlags, (String)"keyFlags");
        this(type, CollectionsKt.listOf((Object[])Arrays.copyOf(keyFlags, keyFlags.length)));
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredCompressionAlgorithms(CompressionAlgorithm ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredCompressionAlgorithms_u24lambda_u240 = keySpecBuilder = this;
        boolean bl = false;
        $this$overridePreferredCompressionAlgorithms_u24lambda_u240.preferredCompressionAlgorithms = ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredHashAlgorithms(HashAlgorithm ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredHashAlgorithms_u24lambda_u241 = keySpecBuilder = this;
        boolean bl = false;
        $this$overridePreferredHashAlgorithms_u24lambda_u241.preferredHashAlgorithms = ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder overridePreferredSymmetricKeyAlgorithms(SymmetricKeyAlgorithm ... algorithms) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)algorithms, (String)"algorithms");
        KeySpecBuilder $this$overridePreferredSymmetricKeyAlgorithms_u24lambda_u243 = keySpecBuilder = this;
        boolean bl = false;
        if (!(!ArraysKt.contains((Object[])algorithms, (Object)((Object)SymmetricKeyAlgorithm.NULL)))) {
            boolean bl2 = false;
            String string = "NULL (unencrypted) is an invalid symmetric key algorithm preference.";
            throw new IllegalArgumentException(string.toString());
        }
        $this$overridePreferredSymmetricKeyAlgorithms_u24lambda_u243.preferredSymmetricAlgorithms = ArraysKt.toSet((Object[])algorithms);
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpecBuilder setKeyCreationDate(@NotNull Date creationDate) {
        KeySpecBuilder keySpecBuilder;
        Intrinsics.checkNotNullParameter((Object)creationDate, (String)"creationDate");
        KeySpecBuilder $this$setKeyCreationDate_u24lambda_u244 = keySpecBuilder = this;
        boolean bl = false;
        $this$setKeyCreationDate_u24lambda_u244.keyCreationDate = creationDate;
        return keySpecBuilder;
    }

    @Override
    @NotNull
    public KeySpec build() {
        SelfSignatureSubpackets selfSignatureSubpackets;
        SelfSignatureSubpackets $this$build_u24lambda_u245 = selfSignatureSubpackets = this.hashedSubpackets;
        boolean bl = false;
        $this$build_u24lambda_u245.setKeyFlags(this.keyFlags);
        $this$build_u24lambda_u245.setPreferredCompressionAlgorithms((Collection<? extends CompressionAlgorithm>)this.preferredCompressionAlgorithms);
        $this$build_u24lambda_u245.setPreferredHashAlgorithms((Collection<? extends HashAlgorithm>)this.preferredHashAlgorithms);
        $this$build_u24lambda_u245.setPreferredSymmetricKeyAlgorithms((Collection<? extends SymmetricKeyAlgorithm>)this.preferredSymmetricAlgorithms);
        Feature[] featureArray = new Feature[]{Feature.MODIFICATION_DETECTION};
        $this$build_u24lambda_u245.setFeatures(featureArray);
        SelfSignatureSubpackets it = selfSignatureSubpackets;
        boolean bl2 = false;
        SelfSignatureSubpackets selfSignatureSubpackets2 = this.hashedSubpackets;
        Intrinsics.checkNotNull((Object)selfSignatureSubpackets2, (String)"null cannot be cast to non-null type org.pgpainless.signature.subpackets.SignatureSubpackets");
        return new KeySpec(this.type, (SignatureSubpackets)selfSignatureSubpackets2, false, this.keyCreationDate);
    }
}

