/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.info;

import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPSignature;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.key.SubkeyIdentifier;
import org.pgpainless.key.info.KeyRingInfo;
import org.pgpainless.signature.subpackets.SignatureSubpacketsUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0003\u001a\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lorg/pgpainless/key/info/KeyAccessor;", "", "info", "Lorg/pgpainless/key/info/KeyRingInfo;", "key", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/pgpainless/key/info/KeyRingInfo;Lorg/pgpainless/key/SubkeyIdentifier;)V", "getInfo", "()Lorg/pgpainless/key/info/KeyRingInfo;", "getKey", "()Lorg/pgpainless/key/SubkeyIdentifier;", "preferredCompressionAlgorithms", "", "Lorg/pgpainless/algorithm/CompressionAlgorithm;", "getPreferredCompressionAlgorithms", "()Ljava/util/Set;", "preferredHashAlgorithms", "Lorg/pgpainless/algorithm/HashAlgorithm;", "getPreferredHashAlgorithms", "preferredSymmetricKeyAlgorithms", "Lorg/pgpainless/algorithm/SymmetricKeyAlgorithm;", "getPreferredSymmetricKeyAlgorithms", "signatureWithPreferences", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignatureWithPreferences", "()Lorg/bouncycastle/openpgp/PGPSignature;", "SubKey", "ViaKeyId", "ViaUserId", "pgpainless-core"})
public abstract class KeyAccessor {
    @NotNull
    private final KeyRingInfo info;
    @NotNull
    private final SubkeyIdentifier key;

    public KeyAccessor(@NotNull KeyRingInfo info, @NotNull SubkeyIdentifier key) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.info = info;
        this.key = key;
    }

    @NotNull
    protected final KeyRingInfo getInfo() {
        return this.info;
    }

    @NotNull
    protected final SubkeyIdentifier getKey() {
        return this.key;
    }

    @NotNull
    public abstract PGPSignature getSignatureWithPreferences();

    @NotNull
    public final Set<SymmetricKeyAlgorithm> getPreferredSymmetricKeyAlgorithms() {
        return SignatureSubpacketsUtil.Companion.parsePreferredSymmetricKeyAlgorithms(this.getSignatureWithPreferences());
    }

    @NotNull
    public final Set<HashAlgorithm> getPreferredHashAlgorithms() {
        return SignatureSubpacketsUtil.Companion.parsePreferredHashAlgorithms(this.getSignatureWithPreferences());
    }

    @NotNull
    public final Set<CompressionAlgorithm> getPreferredCompressionAlgorithms() {
        return SignatureSubpacketsUtil.Companion.parsePreferredCompressionAlgorithms(this.getSignatureWithPreferences());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/key/info/KeyAccessor$SubKey;", "Lorg/pgpainless/key/info/KeyAccessor;", "info", "Lorg/pgpainless/key/info/KeyRingInfo;", "key", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/pgpainless/key/info/KeyRingInfo;Lorg/pgpainless/key/SubkeyIdentifier;)V", "signatureWithPreferences", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignatureWithPreferences", "()Lorg/bouncycastle/openpgp/PGPSignature;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nKeyAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyAccessor.kt\norg/pgpainless/key/info/KeyAccessor$SubKey\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
    public static final class SubKey
    extends KeyAccessor {
        public SubKey(@NotNull KeyRingInfo info, @NotNull SubkeyIdentifier key) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(info, key);
        }

        @Override
        @NotNull
        public PGPSignature getSignatureWithPreferences() {
            PGPSignature pGPSignature;
            if (this.getKey().isPrimaryKey()) {
                pGPSignature = this.getInfo().getLatestDirectKeySelfSignature();
                if (pGPSignature == null) {
                    String string = this.getInfo().getPrimaryUserId();
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        pGPSignature = this.getInfo().getLatestUserIdCertification(it);
                    } else {
                        pGPSignature = null;
                    }
                }
            } else {
                pGPSignature = this.getInfo().getCurrentSubkeyBindingSignature(this.getKey().getSubkeyId());
            }
            if (pGPSignature == null) {
                boolean bl = false;
                String string = "No valid signature found.";
                throw new IllegalStateException(string.toString());
            }
            return pGPSignature;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/pgpainless/key/info/KeyAccessor$ViaKeyId;", "Lorg/pgpainless/key/info/KeyAccessor;", "info", "Lorg/pgpainless/key/info/KeyRingInfo;", "key", "Lorg/pgpainless/key/SubkeyIdentifier;", "(Lorg/pgpainless/key/info/KeyRingInfo;Lorg/pgpainless/key/SubkeyIdentifier;)V", "signatureWithPreferences", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignatureWithPreferences", "()Lorg/bouncycastle/openpgp/PGPSignature;", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nKeyAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyAccessor.kt\norg/pgpainless/key/info/KeyAccessor$ViaKeyId\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
    public static final class ViaKeyId
    extends KeyAccessor {
        public ViaKeyId(@NotNull KeyRingInfo info, @NotNull SubkeyIdentifier key) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            super(info, key);
        }

        @Override
        @NotNull
        public PGPSignature getSignatureWithPreferences() {
            String string = this.getInfo().getPrimaryUserId();
            if (string != null) {
                String userId = string;
                boolean bl = false;
                PGPSignature it = this.getInfo().getLatestUserIdCertification(userId);
                boolean bl2 = false;
                PGPSignature pGPSignature = it;
                if (pGPSignature != null) {
                    return pGPSignature;
                }
            }
            PGPSignature pGPSignature = this.getInfo().getCurrentSubkeyBindingSignature(this.getKey().getSubkeyId());
            if (pGPSignature == null) {
                throw new NoSuchElementException("Key does not carry acceptable self-signature signature.");
            }
            return pGPSignature;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pgpainless/key/info/KeyAccessor$ViaUserId;", "Lorg/pgpainless/key/info/KeyAccessor;", "info", "Lorg/pgpainless/key/info/KeyRingInfo;", "key", "Lorg/pgpainless/key/SubkeyIdentifier;", "userId", "", "(Lorg/pgpainless/key/info/KeyRingInfo;Lorg/pgpainless/key/SubkeyIdentifier;Ljava/lang/CharSequence;)V", "signatureWithPreferences", "Lorg/bouncycastle/openpgp/PGPSignature;", "getSignatureWithPreferences", "()Lorg/bouncycastle/openpgp/PGPSignature;", "pgpainless-core"})
    public static final class ViaUserId
    extends KeyAccessor {
        @NotNull
        private final CharSequence userId;

        public ViaUserId(@NotNull KeyRingInfo info, @NotNull SubkeyIdentifier key, @NotNull CharSequence userId) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            super(info, key);
            this.userId = userId;
        }

        @Override
        @NotNull
        public PGPSignature getSignatureWithPreferences() {
            PGPSignature pGPSignature = this.getInfo().getLatestUserIdCertification(((Object)this.userId).toString());
            if (pGPSignature == null) {
                boolean bl = false;
                String string = "No valid user-id certification signature found for '" + this.userId + "'.";
                throw new IllegalStateException(string.toString());
            }
            return pGPSignature;
        }
    }
}

