/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.SelfSignatureSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u0018\u001a\u00020\u0007R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/signature/builder/DirectKeySelfSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "archetypeSignature", "Lorg/bouncycastle/openpgp/PGPSignature;", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;Lorg/bouncycastle/openpgp/PGPSignature;)V", "(Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "Lorg/pgpainless/algorithm/SignatureType;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/SelfSignatureSubpackets$Callback;", "build", "pgpainless-core"})
@SourceDebugExtension(value={"SMAP\nDirectKeySelfSignatureBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectKeySelfSignatureBuilder.kt\norg/pgpainless/signature/builder/DirectKeySelfSignatureBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1#2:52\n*E\n"})
public final class DirectKeySelfSignatureBuilder
extends AbstractSignatureBuilder<DirectKeySelfSignatureBuilder> {
    @NotNull
    private final SelfSignatureSubpackets hashedSubpackets;
    @NotNull
    private final SelfSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return DirectKeySelfSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public DirectKeySelfSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector, @NotNull PGPSignature archetypeSignature) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        Intrinsics.checkNotNullParameter((Object)archetypeSignature, (String)"archetypeSignature");
        super(signingKey, protector, archetypeSignature);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    public DirectKeySelfSignatureBuilder(@NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        super(SignatureType.DIRECT_KEY, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
    }

    @NotNull
    public final SelfSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final SelfSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final DirectKeySelfSignatureBuilder applyCallback(@Nullable SelfSignatureSubpackets.Callback callback2) {
        DirectKeySelfSignatureBuilder directKeySelfSignatureBuilder;
        block0: {
            DirectKeySelfSignatureBuilder $this$applyCallback_u24lambda_u242 = directKeySelfSignatureBuilder = this;
            boolean bl = false;
            SelfSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            SelfSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return directKeySelfSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build() throws PGPException {
        PGPSignatureGenerator it = this.buildAndInitSignatureGenerator();
        boolean bl = false;
        PGPSignature pGPSignature = it.generateCertification(this.getPublicSigningKey());
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"buildAndInitSignatureGen\u2026ation(publicSigningKey) }");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it == SignatureType.DIRECT_KEY;
    }
}

