/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.decryption_verification.OpenPgpInputStream;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.util.KeyRingUtils;
import org.pgpainless.util.ArmorUtils;
import org.pgpainless.util.ArmoredInputStreamFactory;
import org.pgpainless.util.ArmoredOutputStreamFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/pgpainless/util/ArmorUtils;", "", "()V", "Companion", "pgpainless-core"})
public final class ArmorUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex PATTER_MESSAGE_ID = new Regex("^\\S{32}$");
    @NotNull
    public static final String HEADER_COMMENT = "Comment";
    @NotNull
    public static final String HEADER_VERSION = "Version";
    @NotNull
    public static final String HEADER_MESSAGEID = "MessageID";
    @NotNull
    public static final String HEADER_HASH = "Hash";
    @NotNull
    public static final String HEADER_CHARSET = "Charset";

    @JvmStatic
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPSecretKey secretKey) throws IOException {
        return Companion.toAsciiArmoredString(secretKey);
    }

    @JvmStatic
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPPublicKey publicKey) throws IOException {
        return Companion.toAsciiArmoredString(publicKey);
    }

    @JvmStatic
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPSecretKeyRing secretKeys) throws IOException {
        return Companion.toAsciiArmoredString(secretKeys);
    }

    @JvmStatic
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPPublicKeyRing certificate) throws IOException {
        return Companion.toAsciiArmoredString(certificate);
    }

    @JvmStatic
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPSecretKeyRingCollection secretKeysCollection) throws IOException {
        return Companion.toAsciiArmoredString(secretKeysCollection);
    }

    @JvmStatic
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPPublicKeyRingCollection certificates) throws IOException {
        return Companion.toAsciiArmoredString(certificates);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPSignature signature, boolean export) throws IOException {
        return Companion.toAsciiArmoredString(signature, export);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String toAsciiArmoredString(@NotNull byte[] bytes, @Nullable Map<String, ? extends Set<String>> header) throws IOException {
        return Companion.toAsciiArmoredString(bytes, header);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String toAsciiArmoredString(@NotNull InputStream inputStream, @Nullable Map<String, ? extends Set<String>> header) throws IOException {
        return Companion.toAsciiArmoredString(inputStream, header);
    }

    @JvmStatic
    @NotNull
    public static final ArmoredOutputStream toAsciiArmoredStream(@NotNull PGPKeyRing keys, @NotNull OutputStream outputStream) throws IOException {
        return Companion.toAsciiArmoredStream(keys, outputStream);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ArmoredOutputStream toAsciiArmoredStream(@NotNull OutputStream outputStream, @Nullable Map<String, ? extends Set<String>> header) throws IOException {
        return Companion.toAsciiArmoredStream(outputStream, header);
    }

    @JvmStatic
    private static final Map<String, Set<String>> keyToHeader(PGPPublicKey publicKey) {
        return ArmorUtils.Companion.keyToHeader(publicKey);
    }

    @JvmStatic
    @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
    public static final void setVersionHeader(@NotNull ArmoredOutputStream armor, @Nullable String version) {
        Companion.setVersionHeader(armor, version);
    }

    @JvmStatic
    @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
    public static final void addHashAlgorithmHeader(@NotNull ArmoredOutputStream armor, @NotNull HashAlgorithm hashAlgorithm) {
        Companion.addHashAlgorithmHeader(armor, hashAlgorithm);
    }

    @JvmStatic
    @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
    public static final void addCommentHeader(@NotNull ArmoredOutputStream armor, @NotNull String comment) {
        Companion.addCommentHeader(armor, comment);
    }

    @JvmStatic
    @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
    public static final void addMessageIdHeader(@NotNull ArmoredOutputStream armor, @NotNull String messageId) {
        Companion.addMessageIdHeader(armor, messageId);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getCommentHeaderValues(@NotNull ArmoredInputStream armor) {
        return Companion.getCommentHeaderValues(armor);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getMessageIdHeaderValues(@NotNull ArmoredInputStream armor) {
        return Companion.getMessageIdHeaderValues(armor);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getHashHeaderValues(@NotNull ArmoredInputStream armor) {
        return Companion.getHashHeaderValues(armor);
    }

    @JvmStatic
    @NotNull
    public static final List<HashAlgorithm> getHashAlgorithms(@NotNull ArmoredInputStream armor) {
        return Companion.getHashAlgorithms(armor);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getVersionHeaderValues(@NotNull ArmoredInputStream armor) {
        return Companion.getVersionHeaderValues(armor);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getCharsetHeaderValues(@NotNull ArmoredInputStream armor) {
        return Companion.getCharsetHeaderValues(armor);
    }

    @JvmStatic
    @NotNull
    public static final List<String> getArmorHeaderValues(@NotNull ArmoredInputStream armor, @NotNull String key) {
        return Companion.getArmorHeaderValues(armor, key);
    }

    @JvmStatic
    @NotNull
    public static final InputStream getDecoderStream(@NotNull InputStream inputStream) throws IOException {
        return Companion.getDecoderStream(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String toAsciiArmoredString(@NotNull PGPSignature signature) throws IOException {
        return Companion.toAsciiArmoredString(signature);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String toAsciiArmoredString(@NotNull byte[] bytes) throws IOException {
        return Companion.toAsciiArmoredString(bytes);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String toAsciiArmoredString(@NotNull InputStream inputStream) throws IOException {
        return Companion.toAsciiArmoredString(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final ArmoredOutputStream toAsciiArmoredStream(@NotNull OutputStream outputStream) throws IOException {
        return Companion.toAsciiArmoredStream(outputStream);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0007J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\r\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0007J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0007J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0007J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0007J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0007J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\r\u001a\u00020\u0017H\u0007J\"\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040$0#2\u0006\u0010%\u001a\u00020&H\u0003J\u001a\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010(\u001a\u0004\u0018\u00010\u0004H\u0007J.\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+2\u001c\b\u0002\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040$\u0018\u00010#H\u0007J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020.2\u0006\u0010*\u001a\u00020+H\u0007J.\u0010/\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001c2\u001c\b\u0002\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040$\u0018\u00010#H\u0007J.\u0010/\u001a\u00020\u00042\u0006\u00100\u001a\u0002012\u001c\b\u0002\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040$\u0018\u00010#H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u00102\u001a\u000203H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u00104\u001a\u000205H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u00106\u001a\u000207H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u00108\u001a\u000209H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;H\u0007J\u001a\u0010/\u001a\u00020\u00042\u0006\u0010<\u001a\u00020=2\b\b\u0002\u0010>\u001a\u00020?H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/pgpainless/util/ArmorUtils$Companion;", "", "()V", "HEADER_CHARSET", "", "HEADER_COMMENT", "HEADER_HASH", "HEADER_MESSAGEID", "HEADER_VERSION", "PATTER_MESSAGE_ID", "Lkotlin/text/Regex;", "addCommentHeader", "", "armor", "Lorg/bouncycastle/bcpg/ArmoredOutputStream;", "comment", "addHashAlgorithmHeader", "hashAlgorithm", "Lorg/pgpainless/algorithm/HashAlgorithm;", "addMessageIdHeader", "messageId", "getArmorHeaderValues", "", "Lorg/bouncycastle/bcpg/ArmoredInputStream;", "key", "getCharsetHeaderValues", "getCommentHeaderValues", "getDecoderStream", "Ljava/io/InputStream;", "inputStream", "getHashAlgorithms", "getHashHeaderValues", "getMessageIdHeaderValues", "getVersionHeaderValues", "keyToHeader", "", "", "publicKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "setVersionHeader", "version", "toAsciiArmoredStream", "outputStream", "Ljava/io/OutputStream;", "header", "keys", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "toAsciiArmoredString", "bytes", "", "certificate", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "certificates", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "secretKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "secretKeys", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "secretKeysCollection", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "signature", "Lorg/bouncycastle/openpgp/PGPSignature;", "export", "", "pgpainless-core"})
    @SourceDebugExtension(value={"SMAP\nArmorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArmorUtils.kt\norg/pgpainless/util/ArmorUtils$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,433:1\n215#2:434\n216#2:437\n1855#3,2:435\n288#3:438\n289#3:441\n1603#3,9:471\n1855#3:480\n1856#3:482\n1612#3:483\n1549#3:487\n1620#3,3:488\n1229#4,2:439\n361#5,7:442\n361#5,7:449\n361#5,7:456\n361#5,7:463\n1#6:470\n1#6:481\n3792#7:484\n4307#7,2:485\n*S KotlinDebug\n*F\n+ 1 ArmorUtils.kt\norg/pgpainless/util/ArmorUtils$Companion\n*L\n218#1:434\n218#1:437\n219#1:435,2\n237#1:438\n237#1:441\n371#1:471,9\n371#1:480\n371#1:482\n371#1:483\n405#1:487\n405#1:488,3\n238#1:439,2\n246#1:442,7\n250#1:449,7\n256#1:456,7\n259#1:463,7\n371#1:481\n404#1:484\n404#1:485,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPSecretKey secretKey) throws IOException {
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            byte[] byArray = secretKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secretKey.encoded");
            PGPPublicKey pGPPublicKey = secretKey.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"secretKey.publicKey");
            return this.toAsciiArmoredString(byArray, this.keyToHeader(pGPPublicKey));
        }

        @JvmStatic
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPPublicKey publicKey) throws IOException {
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            byte[] byArray = publicKey.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"publicKey.encoded");
            return this.toAsciiArmoredString(byArray, this.keyToHeader(publicKey));
        }

        @JvmStatic
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPSecretKeyRing secretKeys) throws IOException {
            Intrinsics.checkNotNullParameter((Object)secretKeys, (String)"secretKeys");
            byte[] byArray = secretKeys.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"secretKeys.encoded");
            PGPPublicKey pGPPublicKey = secretKeys.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"secretKeys.publicKey");
            return this.toAsciiArmoredString(byArray, this.keyToHeader(pGPPublicKey));
        }

        @JvmStatic
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPPublicKeyRing certificate) throws IOException {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            byte[] byArray = certificate.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"certificate.encoded");
            PGPPublicKey pGPPublicKey = certificate.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"certificate.publicKey");
            return this.toAsciiArmoredString(byArray, this.keyToHeader(pGPPublicKey));
        }

        @JvmStatic
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPSecretKeyRingCollection secretKeysCollection) throws IOException {
            Intrinsics.checkNotNullParameter((Object)secretKeysCollection, (String)"secretKeysCollection");
            Iterator iterator = secretKeysCollection.getKeyRings();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"secretKeysCollection.keyRings");
            return SequencesKt.joinToString$default((Sequence)SequencesKt.asSequence((Iterator)iterator), (CharSequence)"\n", null, null, (int)0, null, (Function1)toAsciiArmoredString.1.INSTANCE, (int)30, null);
        }

        @JvmStatic
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPPublicKeyRingCollection certificates) throws IOException {
            Intrinsics.checkNotNullParameter((Object)certificates, (String)"certificates");
            return CollectionsKt.joinToString$default((Iterable)((Iterable)certificates), (CharSequence)"\n", null, null, (int)0, null, (Function1)toAsciiArmoredString.2.INSTANCE, (int)30, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPSignature signature, boolean export) throws IOException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            byte[] byArray = signature.getEncoded(export);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"signature.getEncoded(export)");
            return org.pgpainless.util.ArmorUtils$Companion.toAsciiArmoredString$default(this, byArray, null, 2, null);
        }

        public static /* synthetic */ String toAsciiArmoredString$default(Companion companion, PGPSignature pGPSignature, boolean bl, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.toAsciiArmoredString(pGPSignature, bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String toAsciiArmoredString(@NotNull byte[] bytes, @Nullable Map<String, ? extends Set<String>> header) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return this.toAsciiArmoredString(new ByteArrayInputStream(bytes), header);
        }

        public static /* synthetic */ String toAsciiArmoredString$default(Companion companion, byte[] byArray, Map map, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                map = null;
            }
            return companion.toAsciiArmoredString(byArray, (Map<String, ? extends Set<String>>)map);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String toAsciiArmoredString(@NotNull InputStream inputStream, @Nullable Map<String, ? extends Set<String>> header) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            ByteArrayOutputStream $this$toAsciiArmoredString_u24lambda_u241 = byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            ArmoredOutputStream $this$toAsciiArmoredString_u24lambda_u241_u24lambda_u240 = Companion.toAsciiArmoredStream($this$toAsciiArmoredString_u24lambda_u241, header);
            boolean bl2 = false;
            Streams.pipeAll((InputStream)inputStream, (OutputStream)((OutputStream)$this$toAsciiArmoredString_u24lambda_u241_u24lambda_u240));
            $this$toAsciiArmoredString_u24lambda_u241_u24lambda_u240.close();
            String string = byteArrayOutputStream.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ByteArrayOutputStream()\n\u2026              .toString()");
            return string;
        }

        public static /* synthetic */ String toAsciiArmoredString$default(Companion companion, InputStream inputStream, Map map, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                map = null;
            }
            return companion.toAsciiArmoredString(inputStream, (Map<String, ? extends Set<String>>)map);
        }

        @JvmStatic
        @NotNull
        public final ArmoredOutputStream toAsciiArmoredStream(@NotNull PGPKeyRing keys, @NotNull OutputStream outputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            PGPPublicKey pGPPublicKey = keys.getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"keys.publicKey");
            return this.toAsciiArmoredStream(outputStream, this.keyToHeader(pGPPublicKey));
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ArmoredOutputStream toAsciiArmoredStream(@NotNull OutputStream outputStream, @Nullable Map<String, ? extends Set<String>> header) throws IOException {
            ArmoredOutputStream armoredOutputStream;
            block2: {
                Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                ArmoredOutputStream $this$toAsciiArmoredStream_u24lambda_u244 = armoredOutputStream = ArmoredOutputStreamFactory.Companion.get$default(ArmoredOutputStreamFactory.Companion, outputStream, null, 2, null);
                boolean bl = false;
                Map<String, ? extends Set<String>> map = header;
                if (map == null) break block2;
                Map<String, ? extends Set<String>> $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, ? extends Set<String>>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, ? extends Set<String>> element$iv;
                    Map.Entry<String, ? extends Set<String>> entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Iterable $this$forEach$iv2 = entry.getValue();
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        String value = (String)element$iv2;
                        boolean bl3 = false;
                        $this$toAsciiArmoredStream_u24lambda_u244.addHeader(entry.getKey(), value);
                    }
                }
            }
            return armoredOutputStream;
        }

        public static /* synthetic */ ArmoredOutputStream toAsciiArmoredStream$default(Companion companion, OutputStream outputStream, Map map, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                map = null;
            }
            return companion.toAsciiArmoredStream(outputStream, map);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        private final Map<String, Set<String>> keyToHeader(PGPPublicKey publicKey) {
            block19: {
                headerMap = new LinkedHashMap<K, V>();
                userIds = KeyRingUtils.Companion.getUserIdsIgnoringInvalidUTF8(publicKey);
                first = (String)CollectionsKt.firstOrNull(userIds);
                $this$firstOrNull$iv = userIds;
                $i$f$firstOrNull = false;
                var8_8 = $this$firstOrNull$iv.iterator();
                while (var8_8.hasNext()) {
                    block18: {
                        element$iv = var8_8.next();
                        it = (String)element$iv;
                        $i$a$-firstOrNull-ArmorUtils$Companion$keyToHeader$primary$1 = false;
                        var12_25 = publicKey.getSignaturesForID(it);
                        v0 = var12_25;
                        if (v0 == null) ** GOTO lbl-1000
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getSignaturesForID(it)");
                        v0 = SequencesKt.asSequence((Iterator)var12_25);
                        if (v0 != null) {
                            $this$any$iv = v0;
                            $i$f$any = false;
                            var15_30 = $this$any$iv.iterator();
                            while (var15_30.hasNext()) {
                                element$iv = var15_30.next();
                                sig = (PGPSignature)element$iv;
                                $i$a$-any-ArmorUtils$Companion$keyToHeader$primary$1$1 = false;
                                if (!sig.getHashedSubPackets().isPrimaryUserID()) continue;
                                v1 = true;
                                break block18;
                            }
                            v1 = false;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v1 = false;
                        }
                    }
                    if (!v1) continue;
                    v2 = element$iv;
                    break block19;
                }
                v2 = null;
            }
            primary = v2;
            $this$firstOrNull$iv = headerMap;
            key$iv = "Comment";
            $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                $i$a$-getOrPut-ArmorUtils$Companion$keyToHeader$1 = false;
                answer$iv = new LinkedHashSet<E>();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                v3 /* !! */  = answer$iv;
            } else {
                v3 /* !! */  = value$iv;
            }
            ((Set)v3 /* !! */ ).add(OpenPgpFingerprint.Companion.of(publicKey).prettyPrint());
            v4 = primary;
            if (v4 == null) {
                v4 = first;
            }
            if (v4 != null) {
                it = v4;
                $i$a$-let-ArmorUtils$Companion$keyToHeader$2 = false;
                answer$iv = headerMap;
                key$iv = "Comment";
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    $i$a$-getOrPut-ArmorUtils$Companion$keyToHeader$2$1 = false;
                    answer$iv = new LinkedHashSet<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    v5 /* !! */  = answer$iv;
                } else {
                    v5 /* !! */  = value$iv;
                }
                ((Set)v5 /* !! */ ).add(it);
            }
            switch (userIds.size()) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    key$iv = headerMap;
                    key$iv = "Comment";
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        $i$a$-getOrPut-ArmorUtils$Companion$keyToHeader$3 = false;
                        answer$iv = new LinkedHashSet<E>();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        v6 /* !! */  = answer$iv;
                    } else {
                        v6 /* !! */  = value$iv;
                    }
                    ((Set)v6 /* !! */ ).add("1 further identity");
                    break;
                }
                default: {
                    $this$getOrPut$iv = headerMap;
                    key$iv = "Comment";
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        $i$a$-getOrPut-ArmorUtils$Companion$keyToHeader$4 = false;
                        answer$iv = new LinkedHashSet<E>();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        v7 /* !! */  = answer$iv;
                    } else {
                        v7 /* !! */  = value$iv;
                    }
                    ((Set)v7 /* !! */ ).add(userIds.size() - 1 + " further identities");
                }
            }
            return headerMap;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
        public final void setVersionHeader(@NotNull ArmoredOutputStream armor, @Nullable String version) {
            String string;
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            ArmoredOutputStream armoredOutputStream = armor;
            String string2 = ArmorUtils.HEADER_VERSION;
            String string3 = version;
            if (string3 != null) {
                CharSequence charSequence;
                void it;
                String string4 = string3;
                String string5 = string2;
                ArmoredOutputStream armoredOutputStream2 = armoredOutputStream;
                boolean bl = false;
                CharSequence charSequence2 = (CharSequence)it;
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl2 = false;
                    charSequence = null;
                } else {
                    charSequence = charSequence2;
                }
                String string6 = (String)charSequence;
                armoredOutputStream = armoredOutputStream2;
                string2 = string5;
                string = string6;
            } else {
                string = null;
            }
            armoredOutputStream.setHeader(string2, string);
        }

        @JvmStatic
        @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
        public final void addHashAlgorithmHeader(@NotNull ArmoredOutputStream armor, @NotNull HashAlgorithm hashAlgorithm) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            Intrinsics.checkNotNullParameter((Object)((Object)hashAlgorithm), (String)"hashAlgorithm");
            armor.addHeader(ArmorUtils.HEADER_HASH, hashAlgorithm.getAlgorithmName());
        }

        @JvmStatic
        @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
        public final void addCommentHeader(@NotNull ArmoredOutputStream armor, @NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            armor.addHeader(ArmorUtils.HEADER_COMMENT, comment);
        }

        @JvmStatic
        @Deprecated(message="Changing ASCII armor headers after ArmoredOutputStream creation is deprecated. Use ArmoredOutputStream builder instead.")
        public final void addMessageIdHeader(@NotNull ArmoredOutputStream armor, @NotNull String messageId) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
            if (!PATTER_MESSAGE_ID.matches((CharSequence)messageId)) {
                boolean bl = false;
                String string = "MessageIDs MUST consist of 32 printable characters.";
                throw new IllegalArgumentException(string.toString());
            }
            armor.addHeader(ArmorUtils.HEADER_MESSAGEID, messageId);
        }

        @JvmStatic
        @NotNull
        public final List<String> getCommentHeaderValues(@NotNull ArmoredInputStream armor) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            return this.getArmorHeaderValues(armor, ArmorUtils.HEADER_COMMENT);
        }

        @JvmStatic
        @NotNull
        public final List<String> getMessageIdHeaderValues(@NotNull ArmoredInputStream armor) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            return this.getArmorHeaderValues(armor, ArmorUtils.HEADER_MESSAGEID);
        }

        @JvmStatic
        @NotNull
        public final List<String> getHashHeaderValues(@NotNull ArmoredInputStream armor) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            return this.getArmorHeaderValues(armor, ArmorUtils.HEADER_HASH);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<HashAlgorithm> getHashAlgorithms(@NotNull ArmoredInputStream armor) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            Iterable $this$mapNotNull$iv = this.getHashHeaderValues(armor);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HashAlgorithm it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (HashAlgorithm.Companion.fromName(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final List<String> getVersionHeaderValues(@NotNull ArmoredInputStream armor) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            return this.getArmorHeaderValues(armor, ArmorUtils.HEADER_VERSION);
        }

        @JvmStatic
        @NotNull
        public final List<String> getCharsetHeaderValues(@NotNull ArmoredInputStream armor) {
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            return this.getArmorHeaderValues(armor, ArmorUtils.HEADER_CHARSET);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<String> getArmorHeaderValues(@NotNull ArmoredInputStream armor, @NotNull String key) {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)armor, (String)"armor");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String[] stringArray = armor.getArmorHeaders();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"armor.armorHeaders");
            Object[] $this$filter$iv = stringArray;
            boolean $i$f$filter = false;
            Object[] objectArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (String element$iv$iv : $this$filterTo$iv$iv) {
                String it = element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!StringsKt.startsWith$default((String)it, (String)(key + ": "), (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String element$iv$iv;
                element$iv$iv = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String string = it.substring(key.length() + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                collection.add(string);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @NotNull
        public final InputStream getDecoderStream(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            OpenPgpInputStream it = new OpenPgpInputStream(inputStream);
            boolean bl = false;
            InputStream inputStream2 = it.isAsciiArmored() ? PGPUtil.getDecoderStream((InputStream)((InputStream)ArmoredInputStreamFactory.Companion.get$default(ArmoredInputStreamFactory.Companion, it, null, 2, null))) : (InputStream)it;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"OpenPgpInputStream(input\u2026          }\n            }");
            return inputStream2;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String toAsciiArmoredString(@NotNull PGPSignature signature) throws IOException {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            return org.pgpainless.util.ArmorUtils$Companion.toAsciiArmoredString$default(this, signature, false, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String toAsciiArmoredString(@NotNull byte[] bytes) throws IOException {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            return org.pgpainless.util.ArmorUtils$Companion.toAsciiArmoredString$default(this, bytes, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final String toAsciiArmoredString(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return org.pgpainless.util.ArmorUtils$Companion.toAsciiArmoredString$default(this, inputStream, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final ArmoredOutputStream toAsciiArmoredStream(@NotNull OutputStream outputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            return org.pgpainless.util.ArmorUtils$Companion.toAsciiArmoredStream$default(this, outputStream, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

