/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit5;

import java.util.Optional;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.pitest.testapi.AbstractTestUnit;
import org.pitest.testapi.Description;
import org.pitest.testapi.ResultCollector;

public class JUnit5TestUnit
extends AbstractTestUnit {
    private final Class<?> testClass;
    private final TestIdentifier testIdentifier;

    public JUnit5TestUnit(Class<?> testClass, TestIdentifier testIdentifier) {
        super(new Description(testIdentifier.getUniqueId(), testClass));
        this.testClass = testClass;
        this.testIdentifier = testIdentifier;
    }

    public void execute(final ResultCollector resultCollector) {
        Launcher launcher = LauncherFactory.create();
        LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectUniqueId(this.testIdentifier.getUniqueId())).build();
        launcher.registerTestExecutionListeners(new TestExecutionListener(){

            @Override
            public void executionSkipped(TestIdentifier testIdentifier, String reason) {
                if (testIdentifier.isTest()) {
                    resultCollector.notifySkipped(new Description(testIdentifier.getUniqueId(), JUnit5TestUnit.this.testClass));
                }
            }

            @Override
            public void executionStarted(TestIdentifier testIdentifier) {
                if (testIdentifier.isTest()) {
                    resultCollector.notifyStart(new Description(testIdentifier.getUniqueId(), JUnit5TestUnit.this.testClass));
                }
            }

            @Override
            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                Optional<Throwable> throwable = testExecutionResult.getThrowable();
                if (testIdentifier.isTest()) {
                    if (TestExecutionResult.Status.ABORTED == testExecutionResult.getStatus()) {
                        resultCollector.notifyEnd(new Description(testIdentifier.getUniqueId(), JUnit5TestUnit.this.testClass));
                    } else if (throwable.isPresent()) {
                        resultCollector.notifyEnd(new Description(testIdentifier.getUniqueId(), JUnit5TestUnit.this.testClass), throwable.get());
                    } else {
                        resultCollector.notifyEnd(new Description(testIdentifier.getUniqueId(), JUnit5TestUnit.this.testClass));
                    }
                } else if (throwable.isPresent()) {
                    resultCollector.notifyEnd(new Description(testIdentifier.getUniqueId(), JUnit5TestUnit.this.testClass), throwable.get());
                }
            }
        });
        launcher.execute(launcherDiscoveryRequest, new TestExecutionListener[0]);
    }
}

