/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobPersistenceException;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.core.JobRunShell;
import org.quartz.core.QuartzScheduler;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.SchedulingContext;
import org.quartz.spi.TriggerFiredBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzSchedulerThread
extends Thread {
    private QuartzScheduler qs;
    private QuartzSchedulerResources qsRsrcs;
    private Object sigLock = new Object();
    private boolean signaled;
    private long signaledNextFireTime;
    private boolean paused;
    private AtomicBoolean halted;
    private SchedulingContext ctxt = null;
    private Random random = new Random(System.currentTimeMillis());
    private static long DEFAULT_IDLE_WAIT_TIME = 30000L;
    private long idleWaitTime = DEFAULT_IDLE_WAIT_TIME;
    private int idleWaitVariablness = 7000;
    private long dbFailureRetryInterval = 15000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt) {
        this(qs, qsRsrcs, ctxt, qsRsrcs.getMakeSchedulerThreadDaemon(), 5);
    }

    QuartzSchedulerThread(QuartzScheduler qs, QuartzSchedulerResources qsRsrcs, SchedulingContext ctxt, boolean setDaemon, int threadPrio) {
        super(qs.getSchedulerThreadGroup(), qsRsrcs.getThreadName());
        this.qs = qs;
        this.qsRsrcs = qsRsrcs;
        this.ctxt = ctxt;
        this.setDaemon(setDaemon);
        if (qsRsrcs.isThreadsInheritInitializersClassLoadContext()) {
            this.log.info("QuartzSchedulerThread Inheriting ContextClassLoader of thread: " + Thread.currentThread().getName());
            this.setContextClassLoader(Thread.currentThread().getContextClassLoader());
        }
        this.setPriority(threadPrio);
        this.paused = true;
        this.halted = new AtomicBoolean(false);
        this.start();
    }

    void setIdleWaitTime(long waitTime) {
        this.idleWaitTime = waitTime;
        this.idleWaitVariablness = (int)((double)waitTime * 0.2);
    }

    private long getDbFailureRetryInterval() {
        return this.dbFailureRetryInterval;
    }

    public void setDbFailureRetryInterval(long dbFailureRetryInterval) {
        this.dbFailureRetryInterval = dbFailureRetryInterval;
    }

    private long getRandomizedIdleWaitTime() {
        return this.idleWaitTime - (long)this.random.nextInt(this.idleWaitVariablness);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void togglePause(boolean pause) {
        Object object = this.sigLock;
        synchronized (object) {
            this.paused = pause;
            if (this.paused) {
                this.signalSchedulingChange(0L);
            } else {
                this.sigLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void halt() {
        Object object = this.sigLock;
        synchronized (object) {
            this.halted.set(true);
            if (this.paused) {
                this.sigLock.notifyAll();
            } else {
                this.signalSchedulingChange(0L);
            }
        }
    }

    boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalSchedulingChange(long candidateNewNextFireTime) {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = true;
            this.signaledNextFireTime = candidateNewNextFireTime;
            this.sigLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSignaledSchedulingChange() {
        Object object = this.sigLock;
        synchronized (object) {
            this.signaled = false;
            this.signaledNextFireTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScheduleChanged() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSignaledNextFireTime() {
        Object object = this.sigLock;
        synchronized (object) {
            return this.signaledNextFireTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean lastAcquireFailed = false;
        while (!this.halted.get()) {
            try {
                Object object = this.sigLock;
                synchronized (object) {
                    while (this.paused && !this.halted.get()) {
                        try {
                            this.sigLock.wait(1000L);
                        }
                        catch (InterruptedException ignore) {}
                    }
                    if (this.halted.get()) {
                        break;
                    }
                }
                int availTreadCount = this.qsRsrcs.getThreadPool().blockForAvailableThreads();
                if (availTreadCount <= 0) continue;
                Trigger trigger = null;
                long now = System.currentTimeMillis();
                this.clearSignaledSchedulingChange();
                try {
                    trigger = this.qsRsrcs.getJobStore().acquireNextTrigger(this.ctxt, now + this.idleWaitTime);
                    lastAcquireFailed = false;
                }
                catch (JobPersistenceException jpe) {
                    if (!lastAcquireFailed) {
                        this.qs.notifySchedulerListenersError("An error occured while scanning for the next trigger to fire.", jpe);
                    }
                    lastAcquireFailed = true;
                }
                catch (RuntimeException e) {
                    if (!lastAcquireFailed) {
                        this.getLog().error("quartzSchedulerThreadLoop: RuntimeException " + e.getMessage(), (Throwable)e);
                    }
                    lastAcquireFailed = true;
                }
                if (trigger != null) {
                    now = System.currentTimeMillis();
                    long triggerTime = trigger.getNextFireTime().getTime();
                    long timeUntilTrigger = triggerTime - now;
                    while (timeUntilTrigger > 0L) {
                        Object object2 = this.sigLock;
                        synchronized (object2) {
                            if (!this.isCandidateNewTimeEarlierWithinReason(triggerTime, false)) {
                                try {
                                    now = System.currentTimeMillis();
                                    timeUntilTrigger = triggerTime - now;
                                    if (timeUntilTrigger >= 1L) {
                                        this.sigLock.wait(timeUntilTrigger);
                                    }
                                }
                                catch (InterruptedException ignore) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.releaseIfScheduleChangedSignificantly(trigger, triggerTime)) {
                            trigger = null;
                            break;
                        }
                        now = System.currentTimeMillis();
                        timeUntilTrigger = triggerTime - now;
                    }
                    if (trigger == null) continue;
                    TriggerFiredBundle bndle = null;
                    boolean goAhead = true;
                    Object object3 = this.sigLock;
                    synchronized (object3) {
                        goAhead = !this.halted.get();
                    }
                    if (goAhead) {
                        try {
                            bndle = this.qsRsrcs.getJobStore().triggerFired(this.ctxt, trigger);
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("An error occured while firing trigger '" + trigger.getFullName() + "'", se);
                        }
                        catch (RuntimeException e) {
                            this.getLog().error("RuntimeException while firing trigger " + trigger.getFullName(), (Throwable)e);
                            this.releaseTriggerRetryLoop(trigger);
                        }
                    }
                    if (bndle == null) {
                        try {
                            this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                        }
                        catch (SchedulerException se) {
                            this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", se);
                            this.releaseTriggerRetryLoop(trigger);
                        }
                        continue;
                    }
                    JobRunShell shell = null;
                    try {
                        shell = this.qsRsrcs.getJobRunShellFactory().borrowJobRunShell();
                        shell.initialize(this.qs, bndle);
                    }
                    catch (SchedulerException se) {
                        try {
                            this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, trigger, bndle.getJobDetail(), 6);
                        }
                        catch (SchedulerException se2) {
                            this.qs.notifySchedulerListenersError("An error occured while placing job's triggers in error state '" + trigger.getFullName() + "'", se2);
                            this.errorTriggerRetryLoop(bndle);
                        }
                        continue;
                    }
                    if (this.qsRsrcs.getThreadPool().runInThread(shell)) continue;
                    try {
                        this.getLog().error("ThreadPool.runInThread() return false!");
                        this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, trigger, bndle.getJobDetail(), 6);
                    }
                    catch (SchedulerException se2) {
                        this.qs.notifySchedulerListenersError("An error occured while placing job's triggers in error state '" + trigger.getFullName() + "'", se2);
                        this.releaseTriggerRetryLoop(trigger);
                    }
                    continue;
                }
                long now2 = System.currentTimeMillis();
                long waitTime = now2 + this.getRandomizedIdleWaitTime();
                long timeUntilContinue = waitTime - now2;
                Object object4 = this.sigLock;
                synchronized (object4) {
                    try {
                        this.sigLock.wait(timeUntilContinue);
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                }
            }
            catch (RuntimeException re) {
                this.getLog().error("Runtime error occured in main trigger firing loop.", (Throwable)re);
            }
        }
        this.qs = null;
        this.qsRsrcs = null;
    }

    private boolean releaseIfScheduleChangedSignificantly(Trigger trigger, long triggerTime) {
        if (this.isScheduleChanged() && this.isCandidateNewTimeEarlierWithinReason(triggerTime, true)) {
            try {
                this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
            }
            catch (JobPersistenceException jpe) {
                this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                this.releaseTriggerRetryLoop(trigger);
            }
            catch (RuntimeException e) {
                this.getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), (Throwable)e);
                this.releaseTriggerRetryLoop(trigger);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCandidateNewTimeEarlierWithinReason(long oldTime, boolean clearSignal) {
        Object object = this.sigLock;
        synchronized (object) {
            long diff;
            boolean earlier = false;
            if (this.getSignaledNextFireTime() == 0L) {
                earlier = true;
            } else if (this.getSignaledNextFireTime() < oldTime) {
                earlier = true;
            }
            if (earlier && (diff = oldTime - System.currentTimeMillis()) < (this.qsRsrcs.getJobStore().supportsPersistence() ? 70L : 7L)) {
                earlier = false;
            }
            if (clearSignal) {
                this.clearSignaledSchedulingChange();
            }
            return earlier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorTriggerRetryLoop(TriggerFiredBundle bndle) {
        int retryCount = 0;
        try {
            while (!this.halted.get()) {
                try {
                    Thread.sleep(this.getDbFailureRetryInterval());
                    ++retryCount;
                    this.qsRsrcs.getJobStore().triggeredJobComplete(this.ctxt, bndle.getTrigger(), bndle.getJobDetail(), 6);
                    retryCount = 0;
                    break;
                }
                catch (JobPersistenceException jpe) {
                    if (retryCount % 4 != 0) continue;
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + bndle.getTrigger().getFullName() + "'", jpe);
                }
                catch (RuntimeException e) {
                    this.getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    this.getLog().error("releaseTriggerRetryLoop: InterruptedException " + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            if (retryCount == 0) {
                this.getLog().info("releaseTriggerRetryLoop: connection restored.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTriggerRetryLoop(Trigger trigger) {
        int retryCount = 0;
        try {
            while (!this.halted.get()) {
                try {
                    Thread.sleep(this.getDbFailureRetryInterval());
                    ++retryCount;
                    this.qsRsrcs.getJobStore().releaseAcquiredTrigger(this.ctxt, trigger);
                    retryCount = 0;
                    break;
                }
                catch (JobPersistenceException jpe) {
                    if (retryCount % 4 != 0) continue;
                    this.qs.notifySchedulerListenersError("An error occured while releasing trigger '" + trigger.getFullName() + "'", jpe);
                }
                catch (RuntimeException e) {
                    this.getLog().error("releaseTriggerRetryLoop: RuntimeException " + e.getMessage(), (Throwable)e);
                }
                catch (InterruptedException e) {
                    this.getLog().error("releaseTriggerRetryLoop: InterruptedException " + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            if (retryCount == 0) {
                this.getLog().info("releaseTriggerRetryLoop: connection restored.");
            }
        }
    }

    public Logger getLog() {
        return this.log;
    }
}

