/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Adapter;
import android.widget.FrameLayout;
import com.android.internal.app.AlertController;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAlertController;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowDialog;
import org.robolectric.shadows.ShadowListView;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AlertDialog.class)
public class ShadowAlertDialog
extends ShadowDialog {
    @RealObject
    private AlertDialog realAlertDialog;
    private CharSequence[] items;
    private DialogInterface.OnClickListener clickListener;
    private boolean isMultiItem;
    private boolean isSingleItem;
    private DialogInterface.OnMultiChoiceClickListener multiChoiceClickListener;
    private FrameLayout custom;

    public static AlertDialog getLatestAlertDialog() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.application);
        ShadowAlertDialog dialog = shadowApplication.getLatestAlertDialog();
        return dialog == null ? null : dialog.realAlertDialog;
    }

    public FrameLayout getCustomView() {
        if (this.custom == null) {
            this.custom = new FrameLayout(this.context);
        }
        return this.custom;
    }

    public static void reset() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.application);
        shadowApplication.setLatestAlertDialog(null);
    }

    public void clickOnItem(int index) {
        ShadowListView shadowListView = (ShadowListView)Shadow.extract((Object)this.realAlertDialog.getListView());
        shadowListView.performItemClick(index);
    }

    @Override
    public CharSequence getTitle() {
        return this.getShadowAlertController().getTitle();
    }

    public CharSequence[] getItems() {
        Adapter adapter = this.getShadowAlertController().getAdapter();
        int count = adapter.getCount();
        CharSequence[] items = new CharSequence[count];
        for (int i = 0; i < items.length; ++i) {
            items[i] = (CharSequence)adapter.getItem(i);
        }
        return items;
    }

    public Adapter getAdapter() {
        return this.getShadowAlertController().getAdapter();
    }

    public CharSequence getMessage() {
        return this.getShadowAlertController().getMessage();
    }

    @Override
    public void show() {
        super.show();
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.application);
        shadowApplication.setLatestAlertDialog(this);
    }

    public View getView() {
        return this.getShadowAlertController().getView();
    }

    public int getIconId() {
        return this.getShadowAlertController().getIconId();
    }

    public View getCustomTitleView() {
        return this.getShadowAlertController().getCustomTitleView();
    }

    private ShadowAlertController getShadowAlertController() {
        AlertController alertController = (AlertController)ReflectionHelpers.getField((Object)this.realAlertDialog, (String)"mAlert");
        return (ShadowAlertController)Shadow.extract((Object)alertController);
    }

    @Implements(value=AlertDialog.Builder.class)
    public static class ShadowBuilder {
    }
}

