/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BluetoothHeadset.class)
public class ShadowBluetoothHeadset {
    private final List<BluetoothDevice> connectedDevices = new ArrayList<BluetoothDevice>();
    private boolean allowsSendVendorSpecificResultCode = true;

    @Implementation
    protected List<BluetoothDevice> getConnectedDevices() {
        return this.connectedDevices;
    }

    public void addConnectedDevice(BluetoothDevice device) {
        this.connectedDevices.add(device);
    }

    @Implementation
    protected int getConnectionState(BluetoothDevice device) {
        return this.connectedDevices.contains(device) ? 2 : 0;
    }

    @Implementation(minSdk=19)
    protected boolean sendVendorSpecificResultCode(BluetoothDevice device, String command, String arg) {
        if (command == null) {
            throw new IllegalArgumentException("Command cannot be null");
        }
        return this.allowsSendVendorSpecificResultCode && this.connectedDevices.contains(device);
    }

    public void setAllowsSendVendorSpecificResultCode(boolean allowsSendVendorSpecificResultCode) {
        this.allowsSendVendorSpecificResultCode = allowsSendVendorSpecificResultCode;
    }
}

