/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Shader;
import android.graphics.Typeface;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.TextLayoutMode;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Paint.class, looseSignatures=true)
public class ShadowPaint {
    private int color;
    private Paint.Style style;
    private Paint.Cap cap;
    private Paint.Join join;
    private float width;
    private float shadowRadius;
    private float shadowDx;
    private float shadowDy;
    private int shadowColor;
    private Shader shader;
    private int alpha;
    private ColorFilter filter;
    private boolean antiAlias;
    private boolean dither;
    private int flags;
    private PathEffect pathEffect;
    @RealObject
    Paint paint;
    private Typeface typeface;
    private float textSize;
    private Paint.Align textAlign = Paint.Align.LEFT;

    @Implementation
    protected void __constructor__(Paint otherPaint) {
        ShadowPaint otherShadowPaint = (ShadowPaint)Shadow.extract((Object)otherPaint);
        this.color = otherShadowPaint.color;
        this.style = otherShadowPaint.style;
        this.cap = otherShadowPaint.cap;
        this.join = otherShadowPaint.join;
        this.width = otherShadowPaint.width;
        this.shadowRadius = otherShadowPaint.shadowRadius;
        this.shadowDx = otherShadowPaint.shadowDx;
        this.shadowDy = otherShadowPaint.shadowDy;
        this.shadowColor = otherShadowPaint.shadowColor;
        this.shader = otherShadowPaint.shader;
        this.alpha = otherShadowPaint.alpha;
        this.filter = otherShadowPaint.filter;
        this.antiAlias = otherShadowPaint.antiAlias;
        this.dither = otherShadowPaint.dither;
        this.flags = otherShadowPaint.flags;
        this.pathEffect = otherShadowPaint.pathEffect;
        Shadow.invokeConstructor(Paint.class, (Object)this.paint, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Paint.class, (Object)otherPaint)});
    }

    @Implementation(minSdk=24)
    protected static long nInit() {
        return 1L;
    }

    @Implementation
    protected int getFlags() {
        return this.flags;
    }

    @Implementation
    protected void setFlags(int flags) {
        this.flags = flags;
    }

    @Implementation
    protected Shader setShader(Shader shader) {
        this.shader = shader;
        return shader;
    }

    @Implementation
    protected int getAlpha() {
        return this.alpha;
    }

    @Implementation
    protected void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    @Implementation
    protected Shader getShader() {
        return this.shader;
    }

    @Implementation
    protected void setColor(int color) {
        this.color = color;
    }

    @Implementation
    protected int getColor() {
        return this.color;
    }

    @Implementation
    protected void setStyle(Paint.Style style) {
        this.style = style;
    }

    @Implementation
    protected Paint.Style getStyle() {
        return this.style;
    }

    @Implementation
    protected void setStrokeCap(Paint.Cap cap) {
        this.cap = cap;
    }

    @Implementation
    protected Paint.Cap getStrokeCap() {
        return this.cap;
    }

    @Implementation
    protected void setStrokeJoin(Paint.Join join) {
        this.join = join;
    }

    @Implementation
    protected Paint.Join getStrokeJoin() {
        return this.join;
    }

    @Implementation
    protected void setStrokeWidth(float width) {
        this.width = width;
    }

    @Implementation
    protected float getStrokeWidth() {
        return this.width;
    }

    @Implementation
    protected void setShadowLayer(float radius, float dx, float dy, int color) {
        this.shadowRadius = radius;
        this.shadowDx = dx;
        this.shadowDy = dy;
        this.shadowColor = color;
    }

    @Implementation
    protected Typeface getTypeface() {
        return this.typeface;
    }

    @Implementation
    protected Typeface setTypeface(Typeface typeface) {
        this.typeface = typeface;
        return typeface;
    }

    @Implementation
    protected float getTextSize() {
        return this.textSize;
    }

    @Implementation
    protected void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    @Implementation
    protected void setTextAlign(Paint.Align align) {
        this.textAlign = align;
    }

    @Implementation
    protected Paint.Align getTextAlign() {
        return this.textAlign;
    }

    public float getShadowRadius() {
        return this.shadowRadius;
    }

    public float getShadowDx() {
        return this.shadowDx;
    }

    public float getShadowDy() {
        return this.shadowDy;
    }

    public int getShadowColor() {
        return this.shadowColor;
    }

    public Paint.Cap getCap() {
        return this.cap;
    }

    public Paint.Join getJoin() {
        return this.join;
    }

    public float getWidth() {
        return this.width;
    }

    @Implementation
    protected ColorFilter getColorFilter() {
        return this.filter;
    }

    @Implementation
    protected ColorFilter setColorFilter(ColorFilter filter) {
        this.filter = filter;
        return filter;
    }

    @Implementation
    protected void setAntiAlias(boolean antiAlias) {
        this.flags = this.flags & 0xFFFFFFFE | (antiAlias ? 1 : 0);
    }

    @Implementation
    protected void setDither(boolean dither) {
        this.dither = dither;
    }

    @Implementation
    protected final boolean isDither() {
        return this.dither;
    }

    @Implementation
    protected final boolean isAntiAlias() {
        return (this.flags & 1) == 1;
    }

    @Implementation
    protected PathEffect getPathEffect() {
        return this.pathEffect;
    }

    @Implementation
    protected PathEffect setPathEffect(PathEffect effect) {
        this.pathEffect = effect;
        return effect;
    }

    @Implementation
    protected float measureText(String text) {
        return text.length();
    }

    @Implementation
    protected float measureText(CharSequence text, int start, int end) {
        return end - start;
    }

    @Implementation
    protected float measureText(String text, int start, int end) {
        return end - start;
    }

    @Implementation
    protected float measureText(char[] text, int index, int count) {
        return count;
    }

    @Implementation(minSdk=28)
    protected static int nGetFontMetricsInt(long paintPtr, Paint.FontMetricsInt fmi) {
        if (ConfigurationRegistry.get(TextLayoutMode.Mode.class) == TextLayoutMode.Mode.REALISTIC) {
            int descent = 7;
            int ascent = -28;
            int leading = 0;
            if (fmi != null) {
                fmi.top = -32;
                fmi.ascent = ascent;
                fmi.descent = descent;
                fmi.bottom = 9;
                fmi.leading = leading;
            }
            return descent - ascent + leading;
        }
        return 0;
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static int nGetFontMetricsInt(long nativePaint, long nativeTypeface, Paint.FontMetricsInt fmi) {
        return ShadowPaint.nGetFontMetricsInt(nativePaint, fmi);
    }

    @Implementation(minSdk=24, maxSdk=25)
    protected int nGetFontMetricsInt(Object nativePaint, Object nativeTypeface, Object fmi) {
        return ShadowPaint.nGetFontMetricsInt((Long)nativePaint, (Paint.FontMetricsInt)fmi);
    }

    @Implementation(maxSdk=23)
    protected int getFontMetricsInt(Paint.FontMetricsInt fmi) {
        return ShadowPaint.nGetFontMetricsInt(0L, fmi);
    }

    @Implementation(minSdk=28)
    protected static float nGetRunAdvance(long paintPtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        if (ConfigurationRegistry.get(TextLayoutMode.Mode.class) == TextLayoutMode.Mode.REALISTIC) {
            return end - start;
        }
        return 0.0f;
    }

    @Implementation(minSdk=24, maxSdk=27)
    protected static float nGetRunAdvance(long paintPtr, long typefacePtr, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        return ShadowPaint.nGetRunAdvance(paintPtr, text, start, end, contextStart, contextEnd, isRtl, offset);
    }

    @Implementation(minSdk=23, maxSdk=23)
    protected static float native_getRunAdvance(long nativeObject, long nativeTypeface, char[] text, int start, int end, int contextStart, int contextEnd, boolean isRtl, int offset) {
        return ShadowPaint.nGetRunAdvance(0L, text, start, end, contextStart, contextEnd, isRtl, offset);
    }

    @Implementation(minSdk=20, maxSdk=22)
    protected static float native_getTextRunAdvances(long nativeObject, long nativeTypeface, char[] text, int index, int count, int contextIndex, int contextCount, boolean isRtl, float[] advances, int advancesIndex) {
        return ShadowPaint.nGetRunAdvance(0L, text, index, index + count, contextIndex, contextIndex + contextCount, isRtl, index);
    }

    @Implementation(minSdk=20, maxSdk=22)
    protected static float native_getTextRunAdvances(long nativeObject, long nativeTypeface, String text, int start, int end, int contextStart, int contextEnd, boolean isRtl, float[] advances, int advancesIndex) {
        return ShadowPaint.nGetRunAdvance(0L, text.toCharArray(), start, end, contextStart, contextEnd, isRtl, 0);
    }

    @Implementation(minSdk=18, maxSdk=19)
    protected static float native_getTextRunAdvances(int nativeObject, char[] text, int index, int count, int contextIndex, int contextCount, int flags, float[] advances, int advancesIndex) {
        return ShadowPaint.nGetRunAdvance(0L, text, index, index + count, contextIndex, contextIndex + contextCount, false, index);
    }

    @Implementation(minSdk=18, maxSdk=19)
    protected static float native_getTextRunAdvances(int nativeObject, String text, int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesIndex) {
        return ShadowPaint.nGetRunAdvance(0L, text.toCharArray(), start, end, contextStart, contextEnd, false, 0);
    }

    @Implementation(maxSdk=17)
    protected static float native_getTextRunAdvances(int nativeObject, char[] text, int index, int count, int contextIndex, int contextCount, int flags, float[] advances, int advancesIndex, int reserved) {
        return ShadowPaint.nGetRunAdvance(0L, text, index, index + count, contextIndex, contextIndex + contextCount, false, index);
    }

    @Implementation(maxSdk=17)
    protected static float native_getTextRunAdvances(int nativeObject, String text, int start, int end, int contextStart, int contextEnd, int flags, float[] advances, int advancesIndex, int reserved) {
        return ShadowPaint.nGetRunAdvance(0L, text.toCharArray(), start, end, contextStart, contextEnd, false, 0);
    }
}

