/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.PowerManager;
import android.os.WorkSource;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=PowerManager.class)
public class ShadowPowerManager {
    private boolean isScreenOn = true;
    private boolean isInteractive = true;
    private boolean isPowerSaveMode = false;
    private boolean isDeviceIdleMode = false;
    private List<String> rebootReasons = new ArrayList<String>();
    private Map<String, Boolean> ignoringBatteryOptimizations = new HashMap<String, Boolean>();
    private Map<Integer, Boolean> supportedWakeLockLevels = new HashMap<Integer, Boolean>();

    @Implementation
    protected PowerManager.WakeLock newWakeLock(int flags, String tag) {
        PowerManager.WakeLock wl = (PowerManager.WakeLock)Shadow.newInstanceOf(PowerManager.WakeLock.class);
        ((ShadowWakeLock)Shadow.extract((Object)wl)).setTag(tag);
        ShadowApplication.getInstance().addWakeLock(wl);
        return wl;
    }

    @Implementation
    protected boolean isScreenOn() {
        return this.isScreenOn;
    }

    public void setIsScreenOn(boolean screenOn) {
        this.isScreenOn = screenOn;
    }

    @Implementation(minSdk=21)
    protected boolean isInteractive() {
        return this.isInteractive;
    }

    public void setIsInteractive(boolean interactive) {
        this.isInteractive = interactive;
    }

    @Implementation(minSdk=21)
    protected boolean isPowerSaveMode() {
        return this.isPowerSaveMode;
    }

    public void setIsPowerSaveMode(boolean powerSaveMode) {
        this.isPowerSaveMode = powerSaveMode;
    }

    @Implementation(minSdk=21)
    protected boolean isWakeLockLevelSupported(int level) {
        return this.supportedWakeLockLevels.containsKey(level) ? this.supportedWakeLockLevels.get(level) : false;
    }

    public void setIsWakeLockLevelSupported(int level, boolean supported) {
        this.supportedWakeLockLevels.put(level, supported);
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceIdleMode() {
        return this.isDeviceIdleMode;
    }

    public void setIsDeviceIdleMode(boolean isDeviceIdleMode) {
        this.isDeviceIdleMode = isDeviceIdleMode;
    }

    @Resetter
    public static void reset() {
        ShadowApplication shadowApplication = ShadowApplication.getInstance();
        if (shadowApplication != null) {
            shadowApplication.clearWakeLocks();
        }
    }

    public static PowerManager.WakeLock getLatestWakeLock() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.application);
        return shadowApplication.getLatestWakeLock();
    }

    @Implementation(minSdk=23)
    protected boolean isIgnoringBatteryOptimizations(String packageName) {
        Boolean result = this.ignoringBatteryOptimizations.get(packageName);
        return result == null ? false : result;
    }

    public void setIgnoringBatteryOptimizations(String packageName, boolean value) {
        this.ignoringBatteryOptimizations.put(packageName, value);
    }

    @Implementation
    protected void reboot(String reason) {
        this.rebootReasons.add(reason);
    }

    public int getTimesRebooted() {
        return this.rebootReasons.size();
    }

    public ImmutableList<String> getRebootReasons() {
        return ImmutableList.copyOf(this.rebootReasons);
    }

    @Implements(value=PowerManager.WakeLock.class)
    public static class ShadowWakeLock {
        private boolean refCounted = true;
        private int refCount = 0;
        private boolean locked = false;
        private WorkSource workSource = null;
        private int timesHeld = 0;
        private String tag = null;

        @Implementation
        protected void acquire() {
            this.acquire(0L);
        }

        @Implementation
        protected synchronized void acquire(long timeout) {
            ++this.timesHeld;
            if (this.refCounted) {
                ++this.refCount;
            } else {
                this.locked = true;
            }
        }

        @Implementation
        protected synchronized void release() {
            if (this.refCounted) {
                if (--this.refCount < 0) {
                    throw new RuntimeException("WakeLock under-locked");
                }
            } else {
                this.locked = false;
            }
        }

        @Implementation
        protected synchronized boolean isHeld() {
            return this.refCounted ? this.refCount > 0 : this.locked;
        }

        public boolean isReferenceCounted() {
            return this.refCounted;
        }

        @Implementation
        protected void setReferenceCounted(boolean value) {
            this.refCounted = value;
        }

        @Implementation
        protected synchronized void setWorkSource(WorkSource ws) {
            this.workSource = ws;
        }

        public synchronized WorkSource getWorkSource() {
            return this.workSource;
        }

        public int getTimesHeld() {
            return this.timesHeld;
        }

        @HiddenApi
        @Implementation(minSdk=26)
        public String getTag() {
            return this.tag;
        }

        private void setTag(String tag) {
            this.tag = tag;
        }
    }
}

