/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows.util;

import com.almworks.sqlite4java.SQLite;
import com.almworks.sqlite4java.SQLiteException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SQLiteLibraryLoader {
    private static SQLiteLibraryLoader instance;
    private static final String SQLITE4JAVA = "sqlite4java";
    private static final String OS_WIN = "windows";
    private static final String OS_LINUX = "linux";
    private static final String OS_MAC = "mac";
    private final LibraryNameMapper libraryNameMapper;
    private boolean loaded;
    private static final LibraryNameMapper DEFAULT_MAPPER;

    public SQLiteLibraryLoader() {
        this(DEFAULT_MAPPER);
    }

    public SQLiteLibraryLoader(LibraryNameMapper mapper) {
        this.libraryNameMapper = mapper;
    }

    public static synchronized void load() {
        if (instance == null) {
            instance = new SQLiteLibraryLoader();
        }
        instance.doLoad();
    }

    public void doLoad() {
        if (this.loaded) {
            return;
        }
        long startTime = System.currentTimeMillis();
        File tempDir = Files.createTempDir();
        tempDir.deleteOnExit();
        File extractedLibraryPath = new File(tempDir, this.getLibName());
        try (FileOutputStream outputStream = new FileOutputStream(extractedLibraryPath);){
            this.getLibraryByteSource().copyTo((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot extract SQLite library into " + extractedLibraryPath, e);
        }
        this.loadFromDirectory(tempDir);
        this.logWithTime("SQLite natives prepared in", startTime);
    }

    public String getLibClasspathResourceName() {
        return this.getNativesResourcesPathPart() + "/" + this.getNativesResourcesFilePart();
    }

    private ByteSource getLibraryByteSource() {
        return Resources.asByteSource((URL)Resources.getResource((String)this.getLibClasspathResourceName()));
    }

    private void logWithTime(String message, long startTime) {
        this.log(message + " " + (System.currentTimeMillis() - startTime));
    }

    private void log(String message) {
        org.robolectric.util.Logger.debug((String)message, (Object[])new Object[0]);
    }

    @VisibleForTesting
    public boolean isLoaded() {
        return this.loaded;
    }

    private void loadFromDirectory(File libPath) {
        Logger.getLogger("com.almworks.sqlite4java").setLevel(Level.WARNING);
        SQLite.setLibraryPath((String)libPath.getAbsolutePath());
        try {
            this.log("SQLite version: library " + SQLite.getLibraryVersion() + " / core " + SQLite.getSQLiteVersion());
        }
        catch (SQLiteException e) {
            throw new RuntimeException(e);
        }
        this.loaded = true;
    }

    private String getLibName() {
        return this.libraryNameMapper.mapLibraryName(SQLITE4JAVA);
    }

    private String getNativesResourcesPathPart() {
        return this.getOsPrefix() + "-" + this.getArchitectureSuffix();
    }

    private String getNativesResourcesFilePart() {
        return this.getLibName().replace(".dylib", ".jnilib");
    }

    private String getOsPrefix() {
        String name = System.getProperty("os.name").toLowerCase(Locale.US);
        if (name.contains("win")) {
            return OS_WIN;
        }
        if (name.contains(OS_LINUX)) {
            return OS_LINUX;
        }
        if (name.contains(OS_MAC)) {
            return OS_MAC;
        }
        throw new UnsupportedOperationException("Architecture '" + name + "' is not supported by SQLite library");
    }

    private String getArchitectureSuffix() {
        String arch = System.getProperty("os.arch").toLowerCase(Locale.US).replaceAll("\\W", "");
        if ("i386".equals(arch) || "x86".equals(arch)) {
            return "x86";
        }
        return "x86_64";
    }

    static {
        DEFAULT_MAPPER = System::mapLibraryName;
    }

    public static interface LibraryNameMapper {
        public String mapLibraryName(String var1);
    }
}

