/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.robolectric.AndroidMetadata;
import org.robolectric.pluginapi.perf.Metadata;
import org.robolectric.pluginapi.perf.Metric;
import org.robolectric.pluginapi.perf.PerfStatsReporter;

public class SimplePerfStatsReporter
implements PerfStatsReporter {
    private final List<Data> perfStatsData = new ArrayList<Data>();

    public synchronized void report(Metadata metadata, Collection<Metric> metrics) {
        this.perfStatsData.add(new Data(metadata, metrics));
    }

    public void register() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::finalReport));
    }

    private synchronized void finalReport() {
        TreeMap<MetricKey, MetricValue> mergedMetrics = new TreeMap<MetricKey, MetricValue>();
        for (Data data : this.perfStatsData) {
            AndroidMetadata metadata = (AndroidMetadata)data.metadata.get(AndroidMetadata.class);
            Map<String, String> deviceBootProperties = metadata.getDeviceBootProperties();
            int sdkInt = Integer.parseInt(deviceBootProperties.get("ro.build.version.sdk"));
            String resourcesMode = metadata.getResourcesMode();
            for (Metric metric : data.metrics) {
                MetricKey key = new MetricKey(metric.getName(), metric.isSuccess(), sdkInt, resourcesMode);
                MetricValue mergedMetric = (MetricValue)mergedMetrics.get(key);
                if (mergedMetric == null) {
                    mergedMetric = new MetricValue();
                    mergedMetrics.put(key, mergedMetric);
                }
                mergedMetric.report(metric);
            }
        }
        System.out.println("Name\tSDK\tResources\tSuccess\tCount\tMin ms\tMax ms\tAvg ms\tTotal ms");
        for (Map.Entry entry : mergedMetrics.entrySet()) {
            MetricKey key = (MetricKey)entry.getKey();
            MetricValue value = (MetricValue)entry.getValue();
            System.out.println(MessageFormat.format("{0}\t{1}\t{2}\t{3}\t{4}\t{5}\t{6}\t{7}\t{8}", key.name, key.sdkLevel, key.resourcesMode, key.success, value.count, (int)(value.minNs / 1000000L), (int)(value.maxNs / 1000000L), (int)(value.elapsedNs / 1000000L / (long)value.count), (int)(value.elapsedNs / 1000000L)));
        }
    }

    private static class MetricValue {
        private int count;
        private long minNs;
        private long maxNs;
        private long elapsedNs;

        private MetricValue() {
        }

        public void report(Metric metric) {
            if (this.count == 0) {
                this.count = metric.getCount();
                this.minNs = metric.getMinNs();
                this.maxNs = metric.getMaxNs();
                this.elapsedNs = metric.getElapsedNs();
            } else {
                this.count += metric.getCount();
                this.minNs = Math.min(this.minNs, metric.getMinNs());
                this.maxNs = Math.max(this.maxNs, metric.getMaxNs());
                this.elapsedNs += metric.getElapsedNs();
            }
        }
    }

    private static class MetricKey
    implements Comparable<MetricKey> {
        private final String name;
        private final boolean success;
        private final int sdkLevel;
        private final String resourcesMode;

        public MetricKey(String name, boolean success, int sdkLevel, String resourcesMode) {
            this.name = name;
            this.success = success;
            this.sdkLevel = sdkLevel;
            this.resourcesMode = resourcesMode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MetricKey metricKey = (MetricKey)o;
            if (this.success != metricKey.success) {
                return false;
            }
            if (this.name != null ? !this.name.equals(metricKey.name) : metricKey.name != null) {
                return false;
            }
            if (this.sdkLevel != metricKey.sdkLevel) {
                return false;
            }
            return this.resourcesMode != null ? this.resourcesMode.equals(metricKey.resourcesMode) : metricKey.resourcesMode == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.success ? 1 : 0);
            result = 31 * result + this.sdkLevel;
            result = 31 * result + (this.resourcesMode != null ? this.resourcesMode.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(MetricKey o) {
            int i = this.name.compareTo(o.name);
            if (i != 0) {
                return i;
            }
            i = this.resourcesMode.compareTo(o.resourcesMode);
            if (i != 0) {
                return i;
            }
            i = Integer.compare(this.sdkLevel, o.sdkLevel);
            if (i != 0) {
                return i;
            }
            return Boolean.compare(this.success, o.success);
        }
    }

    private static class Data {
        private final Metadata metadata;
        private final Collection<Metric> metrics;

        public Data(Metadata metadata, Collection<Metric> metrics) {
            this.metadata = metadata;
            this.metrics = metrics;
        }
    }
}

