/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Hashing$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.convert.impl.AnyChampStepper$;
import scala.collection.convert.impl.DoubleChampStepper$;
import scala.collection.convert.impl.IntChampStepper;
import scala.collection.convert.impl.IntChampStepper$;
import scala.collection.convert.impl.LongChampStepper$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Range;
import scala.collection.immutable.SetHashIterator;
import scala.collection.immutable.SetIterator;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.SetNode$;
import scala.collection.immutable.SetReverseIterator;
import scala.collection.immutable.StrictOptimizedSetOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public final class HashSet<A>
extends AbstractSet<A>
implements StrictOptimizedSetOps<A, HashSet, HashSet<A>>,
DefaultSerializable {
    private final BitmapIndexedSetNode<A> rootNode;

    public static Object fill(int n, Function0 function0) {
        return HashSet$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <A> HashSet<A> from(IterableOnce<A> iterableOnce) {
        return HashSet$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return HashSet$.MODULE$.iterate(object, n, function1);
    }

    public static <A> ReusableBuilder<A, HashSet<A>> newBuilder() {
        return HashSet$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return HashSet$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return HashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return HashSet$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return HashSet$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static Object unfold(Object object, Function1 function1) {
        return HashSet$.MODULE$.unfold(object, function1);
    }

    public HashSet(BitmapIndexedSetNode<A> rootNode) {
        this.rootNode = rootNode;
        StrictOptimizedIterableOps.$init$(this);
        scala.collection.StrictOptimizedSetOps.$init$(this);
        StrictOptimizedSetOps.$init$(this);
        DefaultSerializable.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<HashSet<A1>, HashSet<A2>, HashSet<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    public BitmapIndexedSetNode<A> rootNode() {
        return this.rootNode;
    }

    public HashSet() {
        this(SetNode$.MODULE$.empty());
    }

    private HashSet<A> newHashSetOrThis(BitmapIndexedSetNode<A> newRootNode) {
        if (this.rootNode() == newRootNode) {
            return this;
        }
        return new HashSet<A>(newRootNode);
    }

    @Override
    public IterableFactory<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    public int knownSize() {
        return this.rootNode().size();
    }

    @Override
    public int size() {
        return this.rootNode().size();
    }

    @Override
    public boolean isEmpty() {
        return this.rootNode().size() == 0;
    }

    @Override
    public Iterator<A> iterator() {
        if (this.isEmpty()) {
            return Iterator$.MODULE$.empty();
        }
        return new SetIterator<A>(this.rootNode());
    }

    public Iterator<A> reverseIterator() {
        return new SetReverseIterator<A>(this.rootNode());
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        int n = shape.shape();
        IntChampStepper<BitmapIndexedSetNode<A>> s = StepperShape$.MODULE$.IntShape() == n ? IntChampStepper$.MODULE$.from(this.size(), this.rootNode(), (Function2<Object, Object, Integer> & Serializable)(node, i) -> HashSet.$anonfun$1((SetNode)node, BoxesRunTime.unboxToInt(i))) : (StepperShape$.MODULE$.LongShape() == n ? LongChampStepper$.MODULE$.from(this.size(), this.rootNode(), (Function2<Object, Object, Long> & Serializable)(node, i) -> HashSet.$anonfun$2((SetNode)node, BoxesRunTime.unboxToInt(i))) : (StepperShape$.MODULE$.DoubleShape() == n ? DoubleChampStepper$.MODULE$.from(this.size(), this.rootNode(), (Function2<Object, Object, Double> & Serializable)(node, i) -> HashSet.$anonfun$3((SetNode)node, BoxesRunTime.unboxToInt(i))) : shape.parUnbox(AnyChampStepper$.MODULE$.from(this.size(), this.rootNode(), (Function2<Object, Object, Object> & Serializable)(node, i) -> ((SetNode)node).getPayload(BoxesRunTime.unboxToInt(i))))));
        return (S)s;
    }

    @Override
    public boolean contains(A element) {
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        return this.rootNode().contains(element, elementUnimprovedHash, elementHash, 0);
    }

    @Override
    public HashSet<A> incl(A element) {
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        SetNode newRootNode = this.rootNode().updated((Object)element, elementUnimprovedHash, elementHash, 0);
        return this.newHashSetOrThis((BitmapIndexedSetNode<A>)newRootNode);
    }

    @Override
    public HashSet<A> excl(A element) {
        int elementUnimprovedHash = Statics.anyHash(element);
        int elementHash = Hashing$.MODULE$.improve(elementUnimprovedHash);
        SetNode newRootNode = this.rootNode().removed((Object)element, elementUnimprovedHash, elementHash, 0);
        return this.newHashSetOrThis((BitmapIndexedSetNode<A>)newRootNode);
    }

    @Override
    public HashSet<A> concat(IterableOnce<A> that) {
        IterableOnce<A> iterableOnce = that;
        if (iterableOnce instanceof HashSet) {
            HashSet hashSet;
            HashSet hs = hashSet = (HashSet)iterableOnce;
            if (this.isEmpty()) {
                return hs;
            }
            SetNode newNode = this.rootNode().concat((SetNode)hs.rootNode(), 0);
            if (newNode == hs.rootNode()) {
                return hs;
            }
            return this.newHashSetOrThis((BitmapIndexedSetNode<A>)newNode);
        }
        if (iterableOnce instanceof scala.collection.mutable.HashSet) {
            scala.collection.mutable.HashSet hashSet;
            scala.collection.mutable.HashSet hs = hashSet = (scala.collection.mutable.HashSet)iterableOnce;
            Iterator iter = hs.nodeIterator();
            SetNode current = this.rootNode();
            while (iter.hasNext()) {
                HashSet.Node next = iter.next();
                int originalHash = hs.unimproveHash(next.hash());
                int improved = Hashing$.MODULE$.improve(originalHash);
                if ((current = ((BitmapIndexedSetNode)current).updated(next.key(), originalHash, improved, 0)) == this.rootNode()) continue;
                int shallowlyMutableNodeMap = Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(improved, 0));
                while (iter.hasNext()) {
                    HashSet.Node next2 = iter.next();
                    int originalHash2 = hs.unimproveHash(next2.hash());
                    int improved2 = Hashing$.MODULE$.improve(originalHash2);
                    shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(next2.key(), originalHash2, improved2, 0, shallowlyMutableNodeMap);
                }
                return new HashSet<A>(current);
            }
            return this;
        }
        if (iterableOnce instanceof LinkedHashSet) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet lhs = linkedHashSet = (LinkedHashSet)iterableOnce;
            Iterator iter = lhs.entryIterator();
            SetNode current = this.rootNode();
            while (iter.hasNext()) {
                LinkedHashSet.Entry next = iter.next();
                int originalHash = lhs.unimproveHash(next.hash());
                int improved = Hashing$.MODULE$.improve(originalHash);
                if ((current = ((BitmapIndexedSetNode)current).updated(next.key(), originalHash, improved, 0)) == this.rootNode()) continue;
                int shallowlyMutableNodeMap = Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(improved, 0));
                while (iter.hasNext()) {
                    LinkedHashSet.Entry next3 = iter.next();
                    int originalHash3 = lhs.unimproveHash(next3.hash());
                    int improved3 = Hashing$.MODULE$.improve(originalHash3);
                    shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(next3.key(), originalHash3, improved3, 0, shallowlyMutableNodeMap);
                }
                return new HashSet<A>(current);
            }
            return this;
        }
        Iterator<A> iter = that.iterator();
        SetNode current = this.rootNode();
        while (iter.hasNext()) {
            int improved;
            int originalHash;
            A element = iter.next();
            if ((current = ((BitmapIndexedSetNode)current).updated((Object)element, originalHash = Statics.anyHash(element), improved = Hashing$.MODULE$.improve(originalHash), 0)) == this.rootNode()) continue;
            int shallowlyMutableNodeMap = Node$.MODULE$.bitposFrom(Node$.MODULE$.maskFrom(improved, 0));
            while (iter.hasNext()) {
                A element2 = iter.next();
                int originalHash4 = Statics.anyHash(element2);
                int improved4 = Hashing$.MODULE$.improve(originalHash4);
                shallowlyMutableNodeMap = ((BitmapIndexedSetNode)current).updateWithShallowMutations(element2, originalHash4, improved4, 0, shallowlyMutableNodeMap);
            }
            return new HashSet<A>(current);
        }
        return this;
    }

    @Override
    public HashSet<A> tail() {
        return (HashSet)this.$minus((Object)this.head());
    }

    @Override
    public HashSet<A> init() {
        return (HashSet)this.$minus((Object)this.last());
    }

    @Override
    public A head() {
        return this.iterator().next();
    }

    @Override
    public A last() {
        return this.reverseIterator().next();
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        this.rootNode().foreach(f);
    }

    public void foreachWithHash(Function2<A, Object, BoxedUnit> f) {
        this.rootNode().foreachWithHash(f);
    }

    public void foreachWithHashWhile(Function2<A, Object, Object> f) {
        this.rootNode().foreachWithHashWhile(f);
    }

    @Override
    public boolean subsetOf(scala.collection.immutable.Set<A> that) {
        return this.subsetOf((Set<A>)that);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean subsetOf(Set<A> that) {
        boolean bl;
        if (this.isEmpty()) return true;
        if (that.isEmpty()) return false;
        Set<A> set = that;
        if (set instanceof HashSet) {
            HashSet hashSet;
            HashSet set2 = hashSet = (HashSet)set;
            bl = this.rootNode().subsetOf(set2.rootNode(), 0);
        } else {
            bl = SetOps.subsetOf$(this, that);
        }
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof HashSet)) return Set.equals$(this, that);
        HashSet hashSet = (HashSet)object;
        HashSet set = hashSet;
        if (this == set) return true;
        BitmapIndexedSetNode<A> bitmapIndexedSetNode = this.rootNode();
        BitmapIndexedSetNode<A> bitmapIndexedSetNode2 = set.rootNode();
        if (bitmapIndexedSetNode != null) {
            if (!((Object)bitmapIndexedSetNode).equals(bitmapIndexedSetNode2)) return false;
            return true;
        }
        if (bitmapIndexedSetNode2 == null) return true;
        return false;
    }

    @Override
    public String className() {
        return "HashSet";
    }

    @Override
    public int hashCode() {
        SetHashIterator<A> it = new SetHashIterator<A>(this.rootNode());
        int hash = MurmurHash3$.MODULE$.unorderedHash(it, MurmurHash3$.MODULE$.setSeed());
        return hash;
    }

    @Override
    public HashSet<A> diff(Set<A> that) {
        if (this.isEmpty()) {
            return this;
        }
        Set set = that;
        if (set instanceof HashSet) {
            HashSet hashSet = (HashSet)set;
            HashSet hashSet2 = hashSet;
            if (hashSet2.isEmpty()) {
                return this;
            }
            SetNode newRootNode = this.rootNode().diff((SetNode)hashSet2.rootNode(), 0);
            if (((BitmapIndexedSetNode)newRootNode).size() == 0) {
                return HashSet$.MODULE$.empty();
            }
            return this.newHashSetOrThis((BitmapIndexedSetNode<A>)this.rootNode().diff((SetNode)hashSet2.rootNode(), 0));
        }
        if (set instanceof scala.collection.mutable.HashSet) {
            scala.collection.mutable.HashSet hashSet;
            scala.collection.mutable.HashSet hashSet3 = hashSet = (scala.collection.mutable.HashSet)set;
            Iterator iter = hashSet3.nodeIterator();
            SetNode curr = this.rootNode();
            while (iter.hasNext()) {
                HashSet.Node next = iter.next();
                int originalHash = hashSet3.unimproveHash(next.hash());
                int improved = Hashing$.MODULE$.improve(originalHash);
                if ((curr = ((BitmapIndexedSetNode)curr).removed(next.key(), originalHash, improved, 0)) == this.rootNode()) continue;
                if (((BitmapIndexedSetNode)curr).size() == 0) {
                    return HashSet$.MODULE$.empty();
                }
                while (iter.hasNext()) {
                    HashSet.Node next2 = iter.next();
                    int originalHash2 = hashSet3.unimproveHash(next2.hash());
                    int improved2 = Hashing$.MODULE$.improve(originalHash2);
                    ((BitmapIndexedSetNode)curr).removeWithShallowMutations(next2.key(), originalHash2, improved2);
                    if (((BitmapIndexedSetNode)curr).size() != 0) continue;
                    return HashSet$.MODULE$.empty();
                }
                return new HashSet<A>(curr);
            }
            return this;
        }
        Set other = set;
        int thatKnownSize = other.knownSize();
        if (thatKnownSize == 0) {
            return this;
        }
        if (thatKnownSize <= this.size()) {
            return this.removedAllWithShallowMutations(other);
        }
        return (HashSet)this.filterNot((Function1<Object, Boolean> & Serializable)(T1 elem) -> other.contains(elem));
    }

    private HashSet<A> removedAllWithShallowMutations(IterableOnce<A> that) {
        Iterator<A> iter = that.iterator();
        SetNode curr = this.rootNode();
        while (iter.hasNext()) {
            int improved;
            int originalHash;
            A next = iter.next();
            if ((curr = ((BitmapIndexedSetNode)curr).removed((Object)next, originalHash = Statics.anyHash(next), improved = Hashing$.MODULE$.improve(originalHash), 0)) == this.rootNode()) continue;
            if (((BitmapIndexedSetNode)curr).size() == 0) {
                return HashSet$.MODULE$.empty();
            }
            while (iter.hasNext()) {
                A next2 = iter.next();
                int originalHash2 = Statics.anyHash(next2);
                int improved2 = Hashing$.MODULE$.improve(originalHash2);
                ((BitmapIndexedSetNode)curr).removeWithShallowMutations(next2, originalHash2, improved2);
                if (((BitmapIndexedSetNode)curr).size() != 0) continue;
                return HashSet$.MODULE$.empty();
            }
            return new HashSet<A>(curr);
        }
        return this;
    }

    @Override
    public HashSet<A> removedAll(IterableOnce<A> that) {
        Range range;
        Range range2;
        IterableOnce<A> iterableOnce = that;
        if (iterableOnce instanceof Set) {
            Set set;
            Set set2 = set = (Set)iterableOnce;
            return this.diff(set2);
        }
        if (iterableOnce instanceof Range && (range2 = (range = (Range)iterableOnce)).length() > this.size()) {
            return (HashSet)this.filter((Function1<Object, Boolean> & Serializable)(T1 x$1) -> {
                Object object = x$1;
                if (object instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt(object);
                    int i = n;
                    return !range2.contains(i);
                }
                return true;
            });
        }
        return this.removedAllWithShallowMutations(that);
    }

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public HashSet<A> filterImpl(Function1<A, Object> pred, boolean isFlipped) {
        SetNode newRootNode = this.rootNode().filterImpl((Function1)pred, isFlipped);
        if (newRootNode == this.rootNode()) {
            return this;
        }
        if (((BitmapIndexedSetNode)newRootNode).size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        return new HashSet<A>(newRootNode);
    }

    @Override
    public HashSet<A> intersect(Set<A> that) {
        return (HashSet)SetOps.intersect$(this, that);
    }

    @Override
    public HashSet<A> take(int n) {
        return (HashSet)IterableOps.take$(this, n);
    }

    @Override
    public HashSet<A> takeRight(int n) {
        return (HashSet)StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public HashSet<A> takeWhile(Function1<A, Object> p) {
        return (HashSet)IterableOps.takeWhile$(this, p);
    }

    @Override
    public HashSet<A> drop(int n) {
        return (HashSet)IterableOps.drop$(this, n);
    }

    @Override
    public HashSet<A> dropRight(int n) {
        return (HashSet)StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public HashSet<A> dropWhile(Function1<A, Object> p) {
        return (HashSet)IterableOps.dropWhile$(this, p);
    }

    private static final /* synthetic */ int $anonfun$1(SetNode node, int i) {
        return BoxesRunTime.unboxToInt(node.getPayload(i));
    }

    private static final /* synthetic */ long $anonfun$2(SetNode node, int i) {
        return BoxesRunTime.unboxToLong(node.getPayload(i));
    }

    private static final /* synthetic */ double $anonfun$3(SetNode node, int i) {
        return BoxesRunTime.unboxToDouble(node.getPayload(i));
    }
}

