package org.openqa.selenium.devtools.v114.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

public enum PreloadEnabledState {

    ENABLED("Enabled"), DISABLEDBYDATASAVER("DisabledByDataSaver"), DISABLEDBYBATTERYSAVER("DisabledByBatterySaver"), DISABLEDBYPREFERENCE("DisabledByPreference"), NOTSUPPORTED("NotSupported");

    private String value;

    PreloadEnabledState(String value) {
        this.value = value;
    }

    public static PreloadEnabledState fromString(String s) {
        return java.util.Arrays.stream(PreloadEnabledState.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within PreloadEnabledState "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static PreloadEnabledState fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
