package org.openqa.selenium.devtools.v114.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * The origin's IndexedDB database list has been modified.
 */
public class IndexedDBListUpdated {

    private final java.lang.String origin;

    private final java.lang.String storageKey;

    public IndexedDBListUpdated(java.lang.String origin, java.lang.String storageKey) {
        this.origin = java.util.Objects.requireNonNull(origin, "origin is required");
        this.storageKey = java.util.Objects.requireNonNull(storageKey, "storageKey is required");
    }

    /**
     * Origin to update.
     */
    public java.lang.String getOrigin() {
        return origin;
    }

    /**
     * Storage key to update.
     */
    public java.lang.String getStorageKey() {
        return storageKey;
    }

    private static IndexedDBListUpdated fromJson(JsonInput input) {
        java.lang.String origin = null;
        java.lang.String storageKey = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "origin":
                    origin = input.nextString();
                    break;
                case "storageKey":
                    storageKey = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new IndexedDBListUpdated(origin, storageKey);
    }
}
