/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.devtools.DevToolsException;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.log.Log;
import org.openqa.selenium.devtools.target.Target;
import org.openqa.selenium.devtools.target.model.SessionID;
import org.openqa.selenium.devtools.target.model.TargetID;
import org.openqa.selenium.devtools.target.model.TargetInfo;
import org.openqa.selenium.internal.Require;

public class DevTools
implements Closeable {
    private final Duration timeout = Duration.ofSeconds(10L);
    private final Connection connection;
    private SessionID cdpSession = null;

    public DevTools(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void close() {
        if (this.cdpSession != null) {
            SessionID id = this.cdpSession;
            this.cdpSession = null;
            this.connection.sendAndWait(this.cdpSession, Target.detachFromTarget(Optional.of(id), Optional.empty()), this.timeout);
        }
    }

    public <X> X send(Command<X> command) {
        Require.nonNull((String)"Command to send", command);
        return this.connection.sendAndWait(this.cdpSession, command, this.timeout);
    }

    public <X> void addListener(Event<X> event, Consumer<X> handler) {
        Require.nonNull((String)"Event to listen for", event);
        Require.nonNull((String)"Handler to call", handler);
        this.connection.addListener(event, handler);
    }

    public void clearListeners() {
        this.connection.clearListeners();
    }

    public void createSessionIfThereIsNotOne() {
        if (this.cdpSession == null) {
            this.createSession();
        }
    }

    public void createSession() {
        List<TargetInfo> infos = this.connection.sendAndWait(this.cdpSession, Target.getTargets(), this.timeout);
        TargetID targetId = infos.stream().filter(info -> "page".equals(info.getType())).map(TargetInfo::getTargetId).findAny().orElseThrow(() -> new DevToolsException("Unable to find target id of a page"));
        this.cdpSession = this.connection.sendAndWait(this.cdpSession, Target.attachToTarget(targetId, Optional.of(true)), this.timeout);
        try {
            CompletableFuture.allOf(this.connection.send(this.cdpSession, Target.setAutoAttach(true, false, Optional.empty())), this.connection.send(this.cdpSession, Log.clear())).get(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread has been interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e;
            if (e.getCause() != null) {
                cause = e.getCause();
            }
            throw new DevToolsException(cause);
        }
        catch (java.util.concurrent.TimeoutException e) {
            throw new TimeoutException((Throwable)e);
        }
    }

    public SessionID getCdpSession() {
        return this.cdpSession;
    }
}

