/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.domdebugger;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.dom.model.NodeId;
import org.openqa.selenium.devtools.domdebugger.model.DOMBreakpointType;
import org.openqa.selenium.devtools.domdebugger.model.EventListener;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;

public class DOMDebugger {
    public static Command<List<EventListener>> getEventListeners(RemoteObjectId objectId, Optional<Integer> depth, Optional<Boolean> pierce) {
        Objects.requireNonNull(objectId, "objectId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"objectId", (Object)objectId);
        depth.ifPresent(p -> params.put((Object)"depth", p));
        pierce.ifPresent(p -> params.put((Object)"pierce", p));
        return new Command<List<EventListener>>("DOMDebugger.getEventListeners", (Map<String, Object>)params.build(), ConverterFunctions.map("listeners", new TypeToken<List<EventListener>>(){}.getType()));
    }

    public static Command<Void> removeDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"type", (Object)type);
        return new Command<Void>("DOMDebugger.removeDOMBreakpoint", (Map<String, Object>)params.build());
    }

    public static Command<Void> removeEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        targetName.ifPresent(p -> params.put((Object)"targetName", p));
        return new Command<Void>("DOMDebugger.removeEventListenerBreakpoint", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> removeInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        return new Command<Void>("DOMDebugger.removeInstrumentationBreakpoint", (Map<String, Object>)params.build());
    }

    public static Command<Void> removeXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        return new Command<Void>("DOMDebugger.removeXHRBreakpoint", (Map<String, Object>)params.build());
    }

    public static Command<Void> setDOMBreakpoint(NodeId nodeId, DOMBreakpointType type) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        Objects.requireNonNull(type, "type is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        params.put((Object)"type", (Object)type);
        return new Command<Void>("DOMDebugger.setDOMBreakpoint", (Map<String, Object>)params.build());
    }

    public static Command<Void> setEventListenerBreakpoint(String eventName, Optional<String> targetName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        targetName.ifPresent(p -> params.put((Object)"targetName", p));
        return new Command<Void>("DOMDebugger.setEventListenerBreakpoint", (Map<String, Object>)params.build());
    }

    @Beta
    public static Command<Void> setInstrumentationBreakpoint(String eventName) {
        Objects.requireNonNull(eventName, "eventName is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"eventName", (Object)eventName);
        return new Command<Void>("DOMDebugger.setInstrumentationBreakpoint", (Map<String, Object>)params.build());
    }

    public static Command<Void> setXHRBreakpoint(String url) {
        Objects.requireNonNull(url, "url is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"url", (Object)url);
        return new Command<Void>("DOMDebugger.setXHRBreakpoint", (Map<String, Object>)params.build());
    }
}

