/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.fetch;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.fetch.model.AuthChallengeResponse;
import org.openqa.selenium.devtools.fetch.model.AuthRequired;
import org.openqa.selenium.devtools.fetch.model.HeaderEntry;
import org.openqa.selenium.devtools.fetch.model.RequestId;
import org.openqa.selenium.devtools.fetch.model.RequestPattern;
import org.openqa.selenium.devtools.fetch.model.RequestPaused;
import org.openqa.selenium.devtools.io.model.StreamHandle;
import org.openqa.selenium.devtools.network.model.ErrorReason;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Fetch {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Fetch.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable(Optional<List<RequestPattern>> patterns, Optional<Boolean> handleAuthRequests) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        patterns.ifPresent(p -> params.put((Object)"patterns", p));
        handleAuthRequests.ifPresent(p -> params.put((Object)"handleAuthRequests", p));
        return new Command<Void>("Fetch.enable", (Map<String, Object>)params.build());
    }

    public static Command<Void> failRequest(RequestId requestId, ErrorReason errorReason) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(errorReason, "errorReason is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        params.put((Object)"errorReason", (Object)errorReason);
        return new Command<Void>("Fetch.failRequest", (Map<String, Object>)params.build());
    }

    public static Command<Void> fulfillRequest(RequestId requestId, Integer responseCode, Optional<List<HeaderEntry>> responseHeaders, Optional<String> binaryResponseHeaders, Optional<String> body, Optional<String> responsePhrase) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(responseCode, "responseCode is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        params.put((Object)"responseCode", (Object)responseCode);
        responseHeaders.ifPresent(p -> params.put((Object)"responseHeaders", p));
        binaryResponseHeaders.ifPresent(p -> params.put((Object)"binaryResponseHeaders", p));
        body.ifPresent(p -> params.put((Object)"body", p));
        responsePhrase.ifPresent(p -> params.put((Object)"responsePhrase", p));
        return new Command<Void>("Fetch.fulfillRequest", (Map<String, Object>)params.build());
    }

    public static Command<Void> continueRequest(RequestId requestId, Optional<String> url, Optional<String> method, Optional<String> postData, Optional<List<HeaderEntry>> headers) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        url.ifPresent(p -> params.put((Object)"url", p));
        method.ifPresent(p -> params.put((Object)"method", p));
        postData.ifPresent(p -> params.put((Object)"postData", p));
        headers.ifPresent(p -> params.put((Object)"headers", p));
        return new Command<Void>("Fetch.continueRequest", (Map<String, Object>)params.build());
    }

    public static Command<Void> continueWithAuth(RequestId requestId, AuthChallengeResponse authChallengeResponse) {
        Objects.requireNonNull(requestId, "requestId is required");
        Objects.requireNonNull(authChallengeResponse, "authChallengeResponse is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        params.put((Object)"authChallengeResponse", (Object)authChallengeResponse);
        return new Command<Void>("Fetch.continueWithAuth", (Map<String, Object>)params.build());
    }

    public static Command<GetResponseBodyResponse> getResponseBody(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        return new Command<GetResponseBodyResponse>("Fetch.getResponseBody", (Map<String, Object>)params.build(), input -> (GetResponseBodyResponse)input.read(GetResponseBodyResponse.class));
    }

    public static Command<StreamHandle> takeResponseBodyAsStream(RequestId requestId) {
        Objects.requireNonNull(requestId, "requestId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"requestId", (Object)requestId);
        return new Command<StreamHandle>("Fetch.takeResponseBodyAsStream", (Map<String, Object>)params.build(), ConverterFunctions.map("stream", StreamHandle.class));
    }

    public static Event<RequestPaused> requestPaused() {
        return new Event<RequestPaused>("Fetch.requestPaused", input -> (RequestPaused)input.read(RequestPaused.class));
    }

    public static Event<AuthRequired> authRequired() {
        return new Event<AuthRequired>("Fetch.authRequired", input -> (AuthRequired)input.read(AuthRequired.class));
    }

    public static class GetResponseBodyResponse {
        private final String body;
        private final Boolean base64Encoded;

        public GetResponseBodyResponse(String body, Boolean base64Encoded) {
            this.body = Objects.requireNonNull(body, "body is required");
            this.base64Encoded = Objects.requireNonNull(base64Encoded, "base64Encoded is required");
        }

        public String getBody() {
            return this.body;
        }

        public Boolean getBase64Encoded() {
            return this.base64Encoded;
        }

        private static GetResponseBodyResponse fromJson(JsonInput input) {
            String body = null;
            Boolean base64Encoded = null;
            input.beginObject();
            block8: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "body": {
                        body = input.nextString();
                        continue block8;
                    }
                    case "base64Encoded": {
                        base64Encoded = input.nextBoolean();
                        continue block8;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new GetResponseBodyResponse(body, base64Encoded);
        }
    }
}

