/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webaudio;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.webaudio.model.AudioListener;
import org.openqa.selenium.devtools.webaudio.model.AudioListenerWillBeDestroyed;
import org.openqa.selenium.devtools.webaudio.model.AudioNode;
import org.openqa.selenium.devtools.webaudio.model.AudioNodeWillBeDestroyed;
import org.openqa.selenium.devtools.webaudio.model.AudioParam;
import org.openqa.selenium.devtools.webaudio.model.AudioParamWillBeDestroyed;
import org.openqa.selenium.devtools.webaudio.model.BaseAudioContext;
import org.openqa.selenium.devtools.webaudio.model.ContextRealtimeData;
import org.openqa.selenium.devtools.webaudio.model.GraphObjectId;
import org.openqa.selenium.devtools.webaudio.model.NodeParamConnected;
import org.openqa.selenium.devtools.webaudio.model.NodeParamDisconnected;
import org.openqa.selenium.devtools.webaudio.model.NodesConnected;
import org.openqa.selenium.devtools.webaudio.model.NodesDisconnected;

@Beta
public class WebAudio {
    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("WebAudio.enable", (Map<String, Object>)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("WebAudio.disable", (Map<String, Object>)params.build());
    }

    public static Command<ContextRealtimeData> getRealtimeData(GraphObjectId contextId) {
        Objects.requireNonNull(contextId, "contextId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"contextId", (Object)contextId);
        return new Command<ContextRealtimeData>("WebAudio.getRealtimeData", (Map<String, Object>)params.build(), ConverterFunctions.map("realtimeData", ContextRealtimeData.class));
    }

    public static Event<BaseAudioContext> contextCreated() {
        return new Event<BaseAudioContext>("WebAudio.contextCreated", ConverterFunctions.map("context", BaseAudioContext.class));
    }

    public static Event<GraphObjectId> contextWillBeDestroyed() {
        return new Event<GraphObjectId>("WebAudio.contextWillBeDestroyed", ConverterFunctions.map("contextId", GraphObjectId.class));
    }

    public static Event<BaseAudioContext> contextChanged() {
        return new Event<BaseAudioContext>("WebAudio.contextChanged", ConverterFunctions.map("context", BaseAudioContext.class));
    }

    public static Event<AudioListener> audioListenerCreated() {
        return new Event<AudioListener>("WebAudio.audioListenerCreated", ConverterFunctions.map("listener", AudioListener.class));
    }

    public static Event<AudioListenerWillBeDestroyed> audioListenerWillBeDestroyed() {
        return new Event<AudioListenerWillBeDestroyed>("WebAudio.audioListenerWillBeDestroyed", input -> (AudioListenerWillBeDestroyed)input.read(AudioListenerWillBeDestroyed.class));
    }

    public static Event<AudioNode> audioNodeCreated() {
        return new Event<AudioNode>("WebAudio.audioNodeCreated", ConverterFunctions.map("node", AudioNode.class));
    }

    public static Event<AudioNodeWillBeDestroyed> audioNodeWillBeDestroyed() {
        return new Event<AudioNodeWillBeDestroyed>("WebAudio.audioNodeWillBeDestroyed", input -> (AudioNodeWillBeDestroyed)input.read(AudioNodeWillBeDestroyed.class));
    }

    public static Event<AudioParam> audioParamCreated() {
        return new Event<AudioParam>("WebAudio.audioParamCreated", ConverterFunctions.map("param", AudioParam.class));
    }

    public static Event<AudioParamWillBeDestroyed> audioParamWillBeDestroyed() {
        return new Event<AudioParamWillBeDestroyed>("WebAudio.audioParamWillBeDestroyed", input -> (AudioParamWillBeDestroyed)input.read(AudioParamWillBeDestroyed.class));
    }

    public static Event<NodesConnected> nodesConnected() {
        return new Event<NodesConnected>("WebAudio.nodesConnected", input -> (NodesConnected)input.read(NodesConnected.class));
    }

    public static Event<NodesDisconnected> nodesDisconnected() {
        return new Event<NodesDisconnected>("WebAudio.nodesDisconnected", input -> (NodesDisconnected)input.read(NodesDisconnected.class));
    }

    public static Event<NodeParamConnected> nodeParamConnected() {
        return new Event<NodeParamConnected>("WebAudio.nodeParamConnected", input -> (NodeParamConnected)input.read(NodeParamConnected.class));
    }

    public static Event<NodeParamDisconnected> nodeParamDisconnected() {
        return new Event<NodeParamDisconnected>("WebAudio.nodeParamDisconnected", input -> (NodeParamDisconnected)input.read(NodeParamDisconnected.class));
    }
}

