/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webauthn;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.webauthn.model.AuthenticatorId;
import org.openqa.selenium.devtools.webauthn.model.Credential;
import org.openqa.selenium.devtools.webauthn.model.VirtualAuthenticatorOptions;

@Beta
public class WebAuthn {
    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("WebAuthn.enable", (Map<String, Object>)params.build());
    }

    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("WebAuthn.disable", (Map<String, Object>)params.build());
    }

    public static Command<AuthenticatorId> addVirtualAuthenticator(VirtualAuthenticatorOptions options) {
        Objects.requireNonNull(options, "options is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"options", (Object)options);
        return new Command<AuthenticatorId>("WebAuthn.addVirtualAuthenticator", (Map<String, Object>)params.build(), ConverterFunctions.map("authenticatorId", AuthenticatorId.class));
    }

    public static Command<Void> removeVirtualAuthenticator(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        return new Command<Void>("WebAuthn.removeVirtualAuthenticator", (Map<String, Object>)params.build());
    }

    public static Command<Void> addCredential(AuthenticatorId authenticatorId, Credential credential) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credential, "credential is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"credential", (Object)credential);
        return new Command<Void>("WebAuthn.addCredential", (Map<String, Object>)params.build());
    }

    public static Command<Credential> getCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"credentialId", (Object)credentialId);
        return new Command<Credential>("WebAuthn.getCredential", (Map<String, Object>)params.build(), ConverterFunctions.map("credential", Credential.class));
    }

    public static Command<List<Credential>> getCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        return new Command<List<Credential>>("WebAuthn.getCredentials", (Map<String, Object>)params.build(), ConverterFunctions.map("credentials", new TypeToken<List<Credential>>(){}.getType()));
    }

    public static Command<Void> removeCredential(AuthenticatorId authenticatorId, String credentialId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(credentialId, "credentialId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"credentialId", (Object)credentialId);
        return new Command<Void>("WebAuthn.removeCredential", (Map<String, Object>)params.build());
    }

    public static Command<Void> clearCredentials(AuthenticatorId authenticatorId) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        return new Command<Void>("WebAuthn.clearCredentials", (Map<String, Object>)params.build());
    }

    public static Command<Void> setUserVerified(AuthenticatorId authenticatorId, Boolean isUserVerified) {
        Objects.requireNonNull(authenticatorId, "authenticatorId is required");
        Objects.requireNonNull(isUserVerified, "isUserVerified is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"authenticatorId", (Object)authenticatorId);
        params.put((Object)"isUserVerified", (Object)isUserVerified);
        return new Command<Void>("WebAuthn.setUserVerified", (Map<String, Object>)params.build());
    }
}

