/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webauthn.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.webauthn.model.AuthenticatorProtocol;
import org.openqa.selenium.devtools.webauthn.model.AuthenticatorTransport;
import org.openqa.selenium.json.JsonInput;

public class VirtualAuthenticatorOptions {
    private final AuthenticatorProtocol protocol;
    private final AuthenticatorTransport transport;
    private final Optional<Boolean> hasResidentKey;
    private final Optional<Boolean> hasUserVerification;
    private final Optional<Boolean> automaticPresenceSimulation;
    private final Optional<Boolean> isUserVerified;

    public VirtualAuthenticatorOptions(AuthenticatorProtocol protocol, AuthenticatorTransport transport, Optional<Boolean> hasResidentKey, Optional<Boolean> hasUserVerification, Optional<Boolean> automaticPresenceSimulation, Optional<Boolean> isUserVerified) {
        this.protocol = Objects.requireNonNull(protocol, "protocol is required");
        this.transport = Objects.requireNonNull(transport, "transport is required");
        this.hasResidentKey = hasResidentKey;
        this.hasUserVerification = hasUserVerification;
        this.automaticPresenceSimulation = automaticPresenceSimulation;
        this.isUserVerified = isUserVerified;
    }

    public AuthenticatorProtocol getProtocol() {
        return this.protocol;
    }

    public AuthenticatorTransport getTransport() {
        return this.transport;
    }

    public Optional<Boolean> getHasResidentKey() {
        return this.hasResidentKey;
    }

    public Optional<Boolean> getHasUserVerification() {
        return this.hasUserVerification;
    }

    public Optional<Boolean> getAutomaticPresenceSimulation() {
        return this.automaticPresenceSimulation;
    }

    public Optional<Boolean> getIsUserVerified() {
        return this.isUserVerified;
    }

    private static VirtualAuthenticatorOptions fromJson(JsonInput input) {
        AuthenticatorProtocol protocol = null;
        AuthenticatorTransport transport = null;
        Optional<Boolean> hasResidentKey = Optional.empty();
        Optional<Boolean> hasUserVerification = Optional.empty();
        Optional<Boolean> automaticPresenceSimulation = Optional.empty();
        Optional<Boolean> isUserVerified = Optional.empty();
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "protocol": {
                    protocol = (AuthenticatorProtocol)((Object)input.read(AuthenticatorProtocol.class));
                    continue block16;
                }
                case "transport": {
                    transport = (AuthenticatorTransport)((Object)input.read(AuthenticatorTransport.class));
                    continue block16;
                }
                case "hasResidentKey": {
                    hasResidentKey = Optional.ofNullable(input.nextBoolean());
                    continue block16;
                }
                case "hasUserVerification": {
                    hasUserVerification = Optional.ofNullable(input.nextBoolean());
                    continue block16;
                }
                case "automaticPresenceSimulation": {
                    automaticPresenceSimulation = Optional.ofNullable(input.nextBoolean());
                    continue block16;
                }
                case "isUserVerified": {
                    isUserVerified = Optional.ofNullable(input.nextBoolean());
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new VirtualAuthenticatorOptions(protocol, transport, hasResidentKey, hasUserVerification, automaticPresenceSimulation, isUserVerified);
    }
}

