/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.metrics.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.writer.Delta;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;

public class CompositeMetricWriter
implements MetricWriter {
    private final List<MetricWriter> writers = new ArrayList<MetricWriter>();

    public CompositeMetricWriter(MetricWriter ... writers) {
        Collections.addAll(this.writers, writers);
    }

    public CompositeMetricWriter(List<MetricWriter> writers) {
        this.writers.addAll(writers);
    }

    @Override
    public void increment(Delta<?> delta) {
        for (MetricWriter writer : this.writers) {
            writer.increment(delta);
        }
    }

    @Override
    public void set(Metric<?> value) {
        for (MetricWriter writer : this.writers) {
            writer.set(value);
        }
    }

    @Override
    public void reset(String metricName) {
        for (MetricWriter writer : this.writers) {
            writer.reset(metricName);
        }
    }
}

