/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul.serviceregistry;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulClient;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.cloud.consul.discovery.HeartbeatProperties;
import org.springframework.cloud.consul.discovery.TtlScheduler;
import org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration(proxyBeanMethods=false)
@ConditionalOnConsulEnabled
@Conditional(value={OnConsulRegistrationEnabledCondition.class})
@AutoConfigureBefore(value={ServiceRegistryAutoConfiguration.class})
public class ConsulServiceRegistryAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulServiceRegistry consulServiceRegistry(ConsulClient consulClient, ConsulDiscoveryProperties properties, HeartbeatProperties heartbeatProperties, @Autowired(required=false) TtlScheduler ttlScheduler) {
        return new ConsulServiceRegistry(consulClient, properties, ttlScheduler, heartbeatProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public HeartbeatProperties heartbeatProperties() {
        return new HeartbeatProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulDiscoveryProperties consulDiscoveryProperties(InetUtils inetUtils) {
        return new ConsulDiscoveryProperties(inetUtils);
    }

    protected static class OnConsulRegistrationEnabledCondition
    extends AllNestedConditions {
        OnConsulRegistrationEnabledCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(value={"spring.cloud.consul.service-registry.enabled"}, matchIfMissing=true)
        static class ConsulServiceRegistryEnabledClass {
            ConsulServiceRegistryEnabledClass() {
            }
        }

        @ConditionalOnProperty(value={"spring.cloud.service-registry.enabled"}, matchIfMissing=true)
        static class ServiceRegistryEnabledClass {
            ServiceRegistryEnabledClass() {
            }
        }
    }
}

