/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.vault.core.util.PropertyTransformer;

public class PropertyNameTransformer
implements PropertyTransformer {
    private final Map<String, String> nameMapping = new HashMap<String, String>();

    public void addKeyTransformation(String sourceKeyName, String targetKeyName) {
        Assert.hasText((String)sourceKeyName, (String)"Source key name must not be empty");
        Assert.hasText((String)targetKeyName, (String)"Target key name must not be empty");
        this.nameMapping.put(sourceKeyName, targetKeyName);
    }

    public Map<String, Object> transformProperties(Map<String, ? extends Object> input) {
        LinkedHashMap<String, Object> transformed = new LinkedHashMap<String, Object>(input.size(), 1.0f);
        Iterator<String> iterator = input.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String translatedKey = key = iterator.next();
            if (this.nameMapping.containsKey(key)) {
                translatedKey = this.nameMapping.get(key);
            }
            transformed.put(translatedKey, input.get(key));
        }
        return transformed;
    }
}

