/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.file.remote.synchronizer;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.springframework.integration.core.LifecycleMessageSource;
import org.springframework.integration.endpoint.AbstractMessageSource;
import org.springframework.integration.file.FileReadingMessageSource;
import org.springframework.integration.file.filters.AcceptOnceFileListFilter;
import org.springframework.integration.file.filters.CompositeFileListFilter;
import org.springframework.integration.file.filters.FileListFilter;
import org.springframework.integration.file.filters.RegexPatternFileListFilter;
import org.springframework.integration.file.remote.synchronizer.AbstractInboundFileSynchronizer;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public abstract class AbstractInboundFileSynchronizingMessageSource<F>
extends AbstractMessageSource<File>
implements LifecycleMessageSource<File> {
    private volatile boolean running;
    private volatile boolean autoCreateLocalDirectory = true;
    private final AbstractInboundFileSynchronizer<F> synchronizer;
    private volatile File localDirectory;
    private final FileReadingMessageSource fileSource;
    private volatile FileListFilter<File> localFileListFilter = new AcceptOnceFileListFilter<File>();

    public AbstractInboundFileSynchronizingMessageSource(AbstractInboundFileSynchronizer<F> synchronizer) {
        this(synchronizer, null);
    }

    public AbstractInboundFileSynchronizingMessageSource(AbstractInboundFileSynchronizer<F> synchronizer, Comparator<File> comparator) {
        Assert.notNull(synchronizer, (String)"synchronizer must not be null");
        this.synchronizer = synchronizer;
        this.fileSource = comparator == null ? new FileReadingMessageSource() : new FileReadingMessageSource(comparator);
    }

    public void setAutoCreateLocalDirectory(boolean autoCreateLocalDirectory) {
        this.autoCreateLocalDirectory = autoCreateLocalDirectory;
    }

    public void setLocalDirectory(File localDirectory) {
        this.localDirectory = localDirectory;
    }

    public void setLocalFilter(FileListFilter<File> localFileListFilter) {
        this.localFileListFilter = localFileListFilter;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.localDirectory, (String)"localDirectory must not be null");
        try {
            if (!this.localDirectory.exists()) {
                if (this.autoCreateLocalDirectory) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("The '" + this.localDirectory + "' directory doesn't exist; Will create."));
                    }
                    this.localDirectory.mkdirs();
                } else {
                    throw new FileNotFoundException(this.localDirectory.getName());
                }
            }
            this.fileSource.setDirectory(this.localDirectory);
            this.fileSource.setFilter(this.buildFilter());
            if (this.getBeanFactory() != null) {
                this.fileSource.setBeanFactory(this.getBeanFactory());
            }
            this.fileSource.afterPropertiesSet();
            this.synchronizer.afterPropertiesSet();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessagingException("Failure during initialization of MessageSource for: " + ((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
        if (this.synchronizer instanceof Closeable) {
            try {
                this.synchronizer.close();
            }
            catch (IOException e) {
                this.logger.error((Object)"Error closing synchronizer", (Throwable)e);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public final Message<File> doReceive() {
        Assert.state((this.fileSource != null ? 1 : 0) != 0, (String)"fileSource must not be null");
        Assert.state((this.synchronizer != null ? 1 : 0) != 0, (String)"synchronizer must not be null");
        Message<File> message = this.fileSource.receive();
        if (message == null) {
            this.synchronizer.synchronizeToLocalDirectory(this.localDirectory);
            message = this.fileSource.receive();
        }
        return message;
    }

    private FileListFilter<File> buildFilter() {
        Pattern completePattern = Pattern.compile("^.*(?<!" + this.synchronizer.getTemporaryFileSuffix() + ")$");
        return new CompositeFileListFilter<File>(Arrays.asList(this.localFileListFilter, new RegexPatternFileListFilter(completePattern)));
    }
}

