/*
 * Decompiled with CFR 0.152.
 */
package tachyon.heartbeat;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import tachyon.heartbeat.ScheduledTimer;

public final class HeartbeatScheduler {
    private static Map<String, ScheduledTimer> sTimers = new HashMap<String, ScheduledTimer>();
    private static Lock sLock = new ReentrantLock();
    private static Condition sCondition = sLock.newCondition();

    public static void addTimer(ScheduledTimer timer) {
        Preconditions.checkNotNull((Object)timer);
        sLock.lock();
        sTimers.put(timer.getThreadName(), timer);
        sCondition.signal();
        sLock.unlock();
    }

    public static synchronized void removeTimer(ScheduledTimer timer) {
        Preconditions.checkNotNull((Object)timer);
        sLock.lock();
        sTimers.remove(timer.getThreadName());
        sLock.unlock();
    }

    public static synchronized Set<String> getThreadNames() {
        sLock.lock();
        Set<String> result = sTimers.keySet();
        sLock.unlock();
        return result;
    }

    public static void schedule(String threadName) {
        sLock.lock();
        ScheduledTimer timer = sTimers.get(threadName);
        if (timer == null) {
            sLock.unlock();
            throw new RuntimeException("Timer for thread " + threadName + " not found.");
        }
        timer.schedule();
        sTimers.remove(threadName);
        sLock.unlock();
    }

    public static void await(String name) throws InterruptedException {
        sLock.lock();
        while (!sTimers.containsKey(name)) {
            sCondition.await();
        }
        sLock.unlock();
    }

    public static boolean await(String name, long time, TimeUnit unit) throws InterruptedException {
        sLock.lock();
        while (!sTimers.containsKey(name)) {
            if (sCondition.await(time, unit)) continue;
            sLock.unlock();
            return false;
        }
        sLock.unlock();
        return true;
    }
}

