/*
 * Decompiled with CFR 0.152.
 */
package tachyon.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class RawTableInfo
implements TBase<RawTableInfo, _Fields>,
Serializable,
Cloneable,
Comparable<RawTableInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("RawTableInfo");
    private static final TField ID_FIELD_DESC = new TField("id", 10, 1);
    private static final TField NAME_FIELD_DESC = new TField("name", 11, 2);
    private static final TField PATH_FIELD_DESC = new TField("path", 11, 3);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 8, 4);
    private static final TField METADATA_FIELD_DESC = new TField("metadata", 11, 5);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public long id;
    public String name;
    public String path;
    public int columns;
    public ByteBuffer metadata;
    private static final int __ID_ISSET_ID = 0;
    private static final int __COLUMNS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public RawTableInfo() {
    }

    public RawTableInfo(long id, String name, String path, int columns, ByteBuffer metadata) {
        this();
        this.id = id;
        this.setIdIsSet(true);
        this.name = name;
        this.path = path;
        this.columns = columns;
        this.setColumnsIsSet(true);
        this.metadata = TBaseHelper.copyBinary((ByteBuffer)metadata);
    }

    public RawTableInfo(RawTableInfo other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.id = other.id;
        if (other.isSetName()) {
            this.name = other.name;
        }
        if (other.isSetPath()) {
            this.path = other.path;
        }
        this.columns = other.columns;
        if (other.isSetMetadata()) {
            this.metadata = TBaseHelper.copyBinary((ByteBuffer)other.metadata);
        }
    }

    public RawTableInfo deepCopy() {
        return new RawTableInfo(this);
    }

    public void clear() {
        this.setIdIsSet(false);
        this.id = 0L;
        this.name = null;
        this.path = null;
        this.setColumnsIsSet(false);
        this.columns = 0;
        this.metadata = null;
    }

    public long getId() {
        return this.id;
    }

    public RawTableInfo setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
        return this;
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public String getName() {
        return this.name;
    }

    public RawTableInfo setName(String name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public RawTableInfo setPath(String path) {
        this.path = path;
        return this;
    }

    public void unsetPath() {
        this.path = null;
    }

    public boolean isSetPath() {
        return this.path != null;
    }

    public void setPathIsSet(boolean value) {
        if (!value) {
            this.path = null;
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public RawTableInfo setColumns(int columns) {
        this.columns = columns;
        this.setColumnsIsSet(true);
        return this;
    }

    public void unsetColumns() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetColumns() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setColumnsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public byte[] getMetadata() {
        this.setMetadata(TBaseHelper.rightSize((ByteBuffer)this.metadata));
        return this.metadata == null ? null : this.metadata.array();
    }

    public ByteBuffer bufferForMetadata() {
        return TBaseHelper.copyBinary((ByteBuffer)this.metadata);
    }

    public RawTableInfo setMetadata(byte[] metadata) {
        this.metadata = metadata == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(metadata, metadata.length));
        return this;
    }

    public RawTableInfo setMetadata(ByteBuffer metadata) {
        this.metadata = TBaseHelper.copyBinary((ByteBuffer)metadata);
        return this;
    }

    public void unsetMetadata() {
        this.metadata = null;
    }

    public boolean isSetMetadata() {
        return this.metadata != null;
    }

    public void setMetadataIsSet(boolean value) {
        if (!value) {
            this.metadata = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
                break;
            }
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((String)value);
                break;
            }
            case PATH: {
                if (value == null) {
                    this.unsetPath();
                    break;
                }
                this.setPath((String)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((Integer)value);
                break;
            }
            case METADATA: {
                if (value == null) {
                    this.unsetMetadata();
                    break;
                }
                this.setMetadata((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case ID: {
                return this.getId();
            }
            case NAME: {
                return this.getName();
            }
            case PATH: {
                return this.getPath();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case METADATA: {
                return this.getMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case ID: {
                return this.isSetId();
            }
            case NAME: {
                return this.isSetName();
            }
            case PATH: {
                return this.isSetPath();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case METADATA: {
                return this.isSetMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof RawTableInfo) {
            return this.equals((RawTableInfo)that);
        }
        return false;
    }

    public boolean equals(RawTableInfo that) {
        if (that == null) {
            return false;
        }
        boolean this_present_id = true;
        boolean that_present_id = true;
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_path = this.isSetPath();
        boolean that_present_path = that.isSetPath();
        if (this_present_path || that_present_path) {
            if (!this_present_path || !that_present_path) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
        }
        boolean this_present_columns = true;
        boolean that_present_columns = true;
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (this.columns != that.columns) {
                return false;
            }
        }
        boolean this_present_metadata = this.isSetMetadata();
        boolean that_present_metadata = that.isSetMetadata();
        if (this_present_metadata || that_present_metadata) {
            if (!this_present_metadata || !that_present_metadata) {
                return false;
            }
            if (!this.metadata.equals(that.metadata)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_id = true;
        list.add(present_id);
        if (present_id) {
            list.add(this.id);
        }
        boolean present_name = this.isSetName();
        list.add(present_name);
        if (present_name) {
            list.add(this.name);
        }
        boolean present_path = this.isSetPath();
        list.add(present_path);
        if (present_path) {
            list.add(this.path);
        }
        boolean present_columns = true;
        list.add(present_columns);
        if (present_columns) {
            list.add(this.columns);
        }
        boolean present_metadata = this.isSetMetadata();
        list.add(present_metadata);
        if (present_metadata) {
            list.add(this.metadata);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(RawTableInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetId()).compareTo(other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((long)this.id, (long)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetName()).compareTo(other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((String)this.name, (String)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPath()).compareTo(other.isSetPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPath() && (lastComparison = TBaseHelper.compareTo((String)this.path, (String)other.path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo((int)this.columns, (int)other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMetadata()).compareTo(other.isSetMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMetadata() && (lastComparison = TBaseHelper.compareTo((Comparable)this.metadata, (Comparable)other.metadata)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RawTableInfo(");
        boolean first = true;
        sb.append("id:");
        sb.append(this.id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("path:");
        if (this.path == null) {
            sb.append("null");
        } else {
            sb.append(this.path);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columns:");
        sb.append(this.columns);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("metadata:");
        if (this.metadata == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.metadata, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new RawTableInfoStandardSchemeFactory());
        schemes.put(TupleScheme.class, new RawTableInfoTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 3, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PATH, new FieldMetaData("path", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.METADATA, new FieldMetaData("metadata", 3, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(RawTableInfo.class, metaDataMap);
    }

    private static class RawTableInfoTupleScheme
    extends TupleScheme<RawTableInfo> {
        private RawTableInfoTupleScheme() {
        }

        public void write(TProtocol prot, RawTableInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetId()) {
                optionals.set(0);
            }
            if (struct.isSetName()) {
                optionals.set(1);
            }
            if (struct.isSetPath()) {
                optionals.set(2);
            }
            if (struct.isSetColumns()) {
                optionals.set(3);
            }
            if (struct.isSetMetadata()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetId()) {
                oprot.writeI64(struct.id);
            }
            if (struct.isSetName()) {
                oprot.writeString(struct.name);
            }
            if (struct.isSetPath()) {
                oprot.writeString(struct.path);
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns);
            }
            if (struct.isSetMetadata()) {
                oprot.writeBinary(struct.metadata);
            }
        }

        public void read(TProtocol prot, RawTableInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.id = iprot.readI64();
                struct.setIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.name = iprot.readString();
                struct.setNameIsSet(true);
            }
            if (incoming.get(2)) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
            }
            if (incoming.get(3)) {
                struct.columns = iprot.readI32();
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(4)) {
                struct.metadata = iprot.readBinary();
                struct.setMetadataIsSet(true);
            }
        }
    }

    private static class RawTableInfoTupleSchemeFactory
    implements SchemeFactory {
        private RawTableInfoTupleSchemeFactory() {
        }

        public RawTableInfoTupleScheme getScheme() {
            return new RawTableInfoTupleScheme();
        }
    }

    private static class RawTableInfoStandardScheme
    extends StandardScheme<RawTableInfo> {
        private RawTableInfoStandardScheme() {
        }

        public void read(TProtocol iprot, RawTableInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.id = iprot.readI64();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.name = iprot.readString();
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.path = iprot.readString();
                            struct.setPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.columns = iprot.readI32();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.metadata = iprot.readBinary();
                            struct.setMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, RawTableInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(ID_FIELD_DESC);
            oprot.writeI64(struct.id);
            oprot.writeFieldEnd();
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                oprot.writeString(struct.name);
                oprot.writeFieldEnd();
            }
            if (struct.path != null) {
                oprot.writeFieldBegin(PATH_FIELD_DESC);
                oprot.writeString(struct.path);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
            oprot.writeI32(struct.columns);
            oprot.writeFieldEnd();
            if (struct.metadata != null) {
                oprot.writeFieldBegin(METADATA_FIELD_DESC);
                oprot.writeBinary(struct.metadata);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class RawTableInfoStandardSchemeFactory
    implements SchemeFactory {
        private RawTableInfoStandardSchemeFactory() {
        }

        public RawTableInfoStandardScheme getScheme() {
            return new RawTableInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        ID(1, "id"),
        NAME(2, "name"),
        PATH(3, "path"),
        COLUMNS(4, "columns"),
        METADATA(5, "metadata");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return ID;
                }
                case 2: {
                    return NAME;
                }
                case 3: {
                    return PATH;
                }
                case 4: {
                    return COLUMNS;
                }
                case 5: {
                    return METADATA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

