/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class CommonUtils {
    public static long getCurrentMs() {
        return System.currentTimeMillis();
    }

    public static <T> String listToString(List<T> list) {
        StringBuilder sb = new StringBuilder();
        for (T s : list) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String[] toStringArray(ArrayList<String> src) {
        String[] ret = new String[src.size()];
        return src.toArray(ret);
    }

    public static void sleepMs(long timeMs) {
        CommonUtils.sleepMs(null, timeMs);
    }

    public static void sleepMs(Logger logger, long timeMs) {
        CommonUtils.sleepMs(logger, timeMs, false);
    }

    public static void sleepMs(Logger logger, long timeMs, boolean shouldInterrupt) {
        block3: {
            try {
                Thread.sleep(timeMs);
            }
            catch (InterruptedException e) {
                if (logger != null) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
                if (!shouldInterrupt) break block3;
                Thread.currentThread().interrupt();
            }
        }
    }

    public static void warmUpLoop() {
        for (int k = 0; k < 10000000; ++k) {
        }
    }

    public static <T> T createNewClassInstance(Class<T> cls, Class<?>[] ctorClassArgs, Object[] ctorArgs) throws InstantiationException, IllegalAccessException, NoSuchMethodException, SecurityException, InvocationTargetException {
        if (ctorClassArgs == null) {
            return cls.newInstance();
        }
        Constructor<T> ctor = cls.getConstructor(ctorClassArgs);
        return ctor.newInstance(ctorArgs);
    }

    private CommonUtils() {
    }
}

