/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.immutables.value.Value;
import org.talend.bigdata.common.storage.GoogleStorage;
import scala.Tuple2;

public interface Component
extends Serializable {

    public static interface WithMergeConfiguration {
        @Value.Default
        default public boolean mergeResultToSingleFile() {
            return false;
        }

        @Value.Default
        default public boolean removeSourceDirectory() {
            return false;
        }

        @Value.Default
        default public boolean overwriteTargetFile() {
            return false;
        }

        @Value.Default
        default public String mergeFilePath() {
            return "";
        }
    }

    public static interface WithUriBuildPrefix {
        @Value.Default
        default public boolean isS3StorageWithBucketNameSpecified() {
            return false;
        }

        @Value.Default
        default public boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration() {
            return false;
        }

        @Value.Default
        default public boolean isGSSparkStorageWithDBKSparkMode() {
            return false;
        }

        @Value.Default
        default public boolean isHdfsStorageClass() {
            return false;
        }

        @Value.Default
        default public boolean useCDPKnox() {
            return false;
        }

        @Value.Default
        default public boolean isSetHadoopConf() {
            return false;
        }

        @Value.Default
        default public String gSStorageName() {
            return "";
        }

        @Value.Default
        default public String s3UriExtractedFromPath() {
            return "";
        }

        @Value.Default
        default public String uriPrefixHadoopConf() {
            return "";
        }

        @Value.Default
        default public Class<?> gSClass() {
            return Object.class;
        }

        @Value.Derived
        default public Tuple2<URI, String> setUriPrefix(JavaSparkContext context, SparkSession sparkSession, String folderPath) throws URISyntaxException, IOException {
            URI currentURI = FileSystem.getDefaultUri((Configuration)context.hadoopConfiguration());
            if (this.isS3StorageWithBucketNameSpecified()) {
                currentURI = new URI(this.s3UriExtractedFromPath());
            } else if (this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration()) {
                currentURI = new URI(this.uriPrefixHadoopConf());
                if (this.isHdfsStorageClass()) {
                    if (this.useCDPKnox()) {
                        currentURI = FileSystem.getDefaultUri((Configuration)context.hadoopConfiguration());
                    } else if (this.isSetHadoopConf()) {
                        currentURI = new URI(context.hadoopConfiguration().get("spark.hadoop.fs.defaultFS"));
                    }
                }
            }
            if (this.isGSSparkStorageWithDBKSparkMode()) {
                GoogleStorage.GoogleCredentials googleCredentials = GoogleStorage.credentials(this.gSStorageName(), sparkSession, this.gSClass());
                Configuration hadoopConfiguration = context.hadoopConfiguration();
                hadoopConfiguration.set("fs.gs.auth.service.account.email", googleCredentials.clientEmail());
                hadoopConfiguration.set("fs.gs.project.id", googleCredentials.projectId());
                hadoopConfiguration.set("fs.gs.auth.service.account.private.key", googleCredentials.privateKey());
                hadoopConfiguration.set("fs.gs.auth.service.account.private.key.id", googleCredentials.privateKeyId());
            }
            FileSystem.setDefaultUri((Configuration)context.hadoopConfiguration(), (URI)currentURI);
            FileSystem.get((Configuration)context.hadoopConfiguration());
            String currentURIPrefix = currentURI.toString();
            if (Stream.of(folderPath).anyMatch(path -> path.contains(":/"))) {
                currentURIPrefix = "";
            }
            return new Tuple2((Object)currentURI, (Object)currentURIPrefix);
        }
    }

    public static interface WithRejects<DT> {
        public DT rejects();
    }

    @Value.Immutable
    public static interface SchemaFieldDescription
    extends Serializable {
        public String name();

        public String type();

        public Optional<String> comment();

        @Value.Default
        default public boolean isNullable() {
            return true;
        }

        @Value.Default
        default public String pattern() {
            return "";
        }

        @Value.Default
        default public boolean useLocalTimezone() {
            return false;
        }

        @Value.Default
        default public boolean trim() {
            return false;
        }

        @Value.Default
        default public boolean isPrecisionSet() {
            return false;
        }

        @Value.Default
        default public Integer precision() {
            return 0;
        }

        @Value.Default
        default public boolean isScaleSet() {
            return false;
        }

        @Value.Default
        default public Integer scale() {
            return 0;
        }

        @Value.Derived
        default public Object parseObject(Object value, Schema.Field field) {
            ArrayList<Schema> fieldTypes = new ArrayList<Schema>();
            if (field.schema().getType().equals((Object)Schema.Type.UNION)) {
                fieldTypes.addAll(field.schema().getTypes());
            } else {
                fieldTypes.add(field.schema());
            }
            switch (this.type()) {
                case "java.lang.Character": {
                    if (fieldTypes.stream().anyMatch(type -> "java.lang.Character".equals(type.getProp("java-class")))) {
                        if (value instanceof Integer) {
                            return Character.valueOf((char)((Integer)value).intValue());
                        }
                        if (value instanceof String) {
                            return this.parse((String)value);
                        }
                        return value;
                    }
                    if (fieldTypes.stream().anyMatch(type -> "java.lang.String".equals(type.getProp("java-class")))) {
                        if (value instanceof Integer) {
                            return Character.toString((char)((Integer)value).intValue());
                        }
                        return value;
                    }
                    if (value instanceof Integer) {
                        return value.toString();
                    }
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return value;
                }
                case "java.nio.ByteBuffer": {
                    if (fieldTypes.stream().anyMatch(type -> "byte[]".equals(type.getProp("java-class")))) {
                        if (Optional.ofNullable(value).map(object -> object.getClass().isArray()).orElse(false).booleanValue()) {
                            return value;
                        }
                        if (value instanceof String) {
                            ByteBuffer buffer = ByteBuffer.wrap(((String)value).getBytes(StandardCharsets.UTF_8));
                            byte[] bytes = new byte[buffer.remaining()];
                            buffer.get(bytes);
                            return bytes;
                        }
                        if (value instanceof ByteBuffer) {
                            ByteBuffer buffer = (ByteBuffer)value;
                            byte[] bytes = new byte[buffer.remaining()];
                            buffer.get(bytes);
                            return bytes;
                        }
                        return value;
                    }
                    if (Optional.ofNullable(value).map(object -> object.getClass().isArray()).orElse(false).booleanValue()) {
                        return ByteBuffer.wrap((byte[])value);
                    }
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return value;
                }
                case "java.lang.Byte": {
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return Optional.ofNullable(value).map(v -> Byte.decode(v.toString())).orElse(null);
                }
                case "java.util.Date": {
                    if (value instanceof Long) {
                        if (fieldTypes.stream().anyMatch(type -> "java.sql.Date".equals(type.getProp("java-class")))) {
                            return new Date((Long)value);
                        }
                        if (fieldTypes.stream().anyMatch(type -> "java.sql.Timestamp".equals(type.getProp("java-class")))) {
                            return new Timestamp((Long)value);
                        }
                        return new java.util.Date((Long)value);
                    }
                    if (value instanceof String) {
                        java.util.Date date = this.parseDate(this.trim() ? ((String)value).trim() : (String)value);
                        if (fieldTypes.stream().anyMatch(type -> "java.sql.Date".equals(type.getProp("java-class")))) {
                            return new Date(date.getTime());
                        }
                        if (fieldTypes.stream().anyMatch(type -> "java.sql.Timestamp".equals(type.getProp("java-class")))) {
                            return new Timestamp(date.getTime());
                        }
                        return this.parseDate(value.toString());
                    }
                    return value;
                }
                case "java.math.BigDecimal": {
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return Optional.ofNullable(value).map(v -> new BigDecimal(v.toString())).orElse(null);
                }
                case "java.lang.Short": {
                    if (value instanceof Integer) {
                        return ((Integer)value).shortValue();
                    }
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return value;
                }
                case "java.lang.Float": {
                    if (value instanceof Double) {
                        return Optional.ofNullable(value).map(v -> Float.valueOf(Float.parseFloat(Double.toString((Double)value)))).orElse(null);
                    }
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return value;
                }
                case "java.lang.Long": {
                    if (value instanceof Integer) {
                        return Optional.ofNullable(value).map(v -> Long.valueOf(Integer.toString((Integer)value))).orElse(null);
                    }
                    if (value instanceof String) {
                        return this.parse((String)value);
                    }
                    return value;
                }
            }
            if (value instanceof String) {
                return this.parse((String)value);
            }
            return value;
        }

        @Value.Derived
        default public Object parse(String value) {
            String preparedValue = this.trim() && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value}) ? StringUtils.trim((String)value) : value;
            switch (this.type()) {
                case "java.lang.Integer": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Integer.valueOf(preparedValue);
                }
                case "java.lang.Byte": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Byte.decode(preparedValue);
                }
                case "java.nio.ByteBuffer": {
                    return ByteBuffer.wrap(preparedValue.getBytes(StandardCharsets.UTF_8));
                }
                case "java.lang.Character": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Character.valueOf(preparedValue.charAt(0));
                }
                case "java.lang.Long": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Long.decode(preparedValue);
                }
                case "java.lang.Float": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Float.valueOf(Float.parseFloat(preparedValue));
                }
                case "java.math.BigDecimal": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : new BigDecimal(preparedValue);
                }
                case "java.lang.Double": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Double.valueOf(Double.parseDouble(preparedValue));
                }
                case "java.lang.Boolean": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Boolean.valueOf(Boolean.parseBoolean(preparedValue));
                }
                case "java.lang.Short": {
                    return StringUtils.isBlank((CharSequence)preparedValue) ? null : Short.decode(preparedValue);
                }
                case "java.util.Date": {
                    return this.parseDate(preparedValue);
                }
            }
            return preparedValue;
        }

        public static Class<?> structFieldToJavaType(StructField field) {
            DataType dataType = field.dataType();
            if (dataType instanceof StringType) {
                return String.class;
            }
            if (dataType instanceof IntegerType) {
                return Integer.class;
            }
            if (dataType instanceof LongType) {
                return Long.class;
            }
            if (dataType instanceof DoubleType) {
                return Double.class;
            }
            if (dataType instanceof BooleanType) {
                return Boolean.class;
            }
            if (dataType instanceof TimestampType) {
                return Timestamp.class;
            }
            if (dataType instanceof DateType) {
                return Date.class;
            }
            if (dataType instanceof FloatType) {
                return Float.class;
            }
            if (dataType instanceof ShortType) {
                return Short.class;
            }
            if (dataType instanceof ByteType) {
                return Byte.class;
            }
            if (dataType instanceof BinaryType) {
                return byte[].class;
            }
            if (dataType instanceof DecimalType) {
                return BigDecimal.class;
            }
            if (dataType instanceof ArrayType) {
                return List.class;
            }
            if (dataType instanceof MapType) {
                return Map.class;
            }
            if (dataType instanceof StructType) {
                return Row.class;
            }
            return Object.class;
        }

        @Value.Derived
        default public Object parseObject(Object value, StructField field) {
            if (value == null) {
                return null;
            }
            Class<?> javaType = SchemaFieldDescription.structFieldToJavaType(field);
            if (javaType.equals(Byte.class)) {
                return Byte.toString((Byte)value);
            }
            if (javaType == String.class) {
                return value.toString();
            }
            if (javaType == Integer.class) {
                return Integer.valueOf(value.toString());
            }
            if (javaType == Long.class) {
                return Long.valueOf(value.toString());
            }
            if (javaType == Double.class) {
                return Double.valueOf(value.toString());
            }
            if (javaType == Boolean.class) {
                return Boolean.valueOf(value.toString());
            }
            if (javaType == Timestamp.class && value instanceof java.util.Date) {
                return new Timestamp(((java.util.Date)value).getTime()).toString();
            }
            if (javaType == Date.class && value instanceof java.util.Date) {
                return new Date(((java.util.Date)value).getTime()).toString();
            }
            if (javaType == Float.class) {
                return Float.valueOf(value.toString());
            }
            if (javaType == BigDecimal.class) {
                return this.parseBigDecimal(value);
            }
            if (javaType == Short.class) {
                return value.toString();
            }
            if (javaType.isInstance(value)) {
                return value;
            }
            return value;
        }

        private BigDecimal parseBigDecimal(Object value) {
            if (value instanceof String) {
                return new BigDecimal((String)value);
            }
            if (value instanceof Number) {
                return BigDecimal.valueOf(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }

        @Value.Derived
        default public java.util.Date parseDate(String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return null;
            }
            String pattern = this.pattern().trim();
            if (StringUtils.isBlank((CharSequence)pattern)) {
                pattern = "dd-MM-yyyy";
            } else if (pattern.equals("yyyy-MM-dd'T'HH:mm:ss'000Z'")) {
                pattern = "yyyy-MM-dd'T'HH:mm:ss";
            }
            String patternWithoutQuote = pattern.replace("'", "");
            if (value.length() < patternWithoutQuote.length()) {
                throw new RuntimeException("Unable to parse date " + value + " for pattern " + pattern);
            }
            TemporalAccessor parsedDate = DateTimeFormatter.ofPattern(pattern).parse(value.substring(0, patternWithoutQuote.length()));
            if (parsedDate.query(TemporalQueries.localTime()) == null) {
                return this.useLocalTimezone() ? java.util.Date.from(LocalDate.from(parsedDate).atStartOfDay(ZoneId.systemDefault()).toInstant()) : java.util.Date.from(LocalDate.from(parsedDate).atStartOfDay(ZoneOffset.UTC).toInstant());
            }
            return this.useLocalTimezone() ? java.util.Date.from(LocalDateTime.from(parsedDate).atZone(ZoneId.systemDefault()).toInstant()) : java.util.Date.from(LocalDateTime.from(parsedDate).atOffset(ZoneOffset.UTC).toInstant());
        }
    }

    public static interface WithOutputFileGeneration
    extends Serializable {
        public void save() throws IOException, URISyntaxException;
    }

    public static interface WithSchemaDescription
    extends Serializable {
        public List<SchemaFieldDescription> schemaFieldDescriptions();

        @Value.Derived
        default public StructType getOutputRowStruct() {
            StructType structType = new StructType();
            for (SchemaFieldDescription schemaFieldDescription : this.schemaFieldDescriptions()) {
                structType = structType.add(schemaFieldDescription.name(), DataTypes.StringType, schemaFieldDescription.isNullable());
            }
            return structType;
        }

        default public Dataset<Row> castBigDecimal(Dataset<?> input) {
            Dataset castedDataset = input.toDF();
            List bigDecimalFields = this.schemaFieldDescriptions().stream().filter(schemaFieldDescription -> schemaFieldDescription.type().equals("java.math.BigDecimal")).collect(Collectors.toList());
            for (SchemaFieldDescription schemaFieldDescription2 : bigDecimalFields) {
                if (!schemaFieldDescription2.isPrecisionSet() || !schemaFieldDescription2.isScaleSet()) continue;
                castedDataset = castedDataset.withColumn(schemaFieldDescription2.name(), functions.col((String)schemaFieldDescription2.name()).cast("Decimal(" + schemaFieldDescription2.precision() + "," + schemaFieldDescription2.scale() + ")"));
            }
            return castedDataset;
        }

        @Value.Derived
        default public Map<String, SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            return this.schemaFieldDescriptions().stream().collect(Collectors.toMap(SchemaFieldDescription::name, schemaFieldDescription -> schemaFieldDescription));
        }
    }

    public static class Conversions {
        public static String asString(ByteBuffer buffer) {
            return StandardCharsets.UTF_8.decode(buffer).toString();
        }

        public static String asString(byte[] bytes) {
            return new String(bytes);
        }
    }

    public static class SparkConfigurationAwareComponentsManager {
        private final List<SparkConfigurationAware> registeredComponents = new ArrayList<SparkConfigurationAware>();
        private static final ThreadLocal<SparkConfigurationAwareComponentsManager> instance = new ThreadLocal();

        private SparkConfigurationAwareComponentsManager() {
        }

        public static SparkConfigurationAwareComponentsManager getInstance() {
            if (instance.get() == null) {
                instance.set(new SparkConfigurationAwareComponentsManager());
            }
            return instance.get();
        }

        public void register(SparkConfigurationAware component) {
            this.registeredComponents.add(component);
        }

        public void publish(SparkConf conf) {
            this.registeredComponents.forEach(component -> component.push(conf));
        }
    }

    public static interface SparkConfigurationAware
    extends Component {
        public void push(SparkConf var1);
    }
}

